/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.creation;

import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.filters.icml.ICMLFilter;
import net.sf.okapi.filters.its.html5.HTML5Filter;
import net.sf.okapi.filters.openoffice.OpenOfficeFilter;
import net.sf.okapi.filters.openxml.OpenXMLFilter;
import net.sf.okapi.filters.properties.PropertiesFilter;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.filters.xmlstream.XmlStreamFilter;
import net.sf.okapi.lib.xliff2.document.XLIFFDocument;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.common.createtarget.CreateTargetStep;
import net.sf.okapi.steps.rainbowkit.creation.ExtractionStep;
import net.sf.okapi.steps.rainbowkit.creation.Parameters;
import net.sf.okapi.steps.rainbowkit.ontram.OntramPackageWriter;
import net.sf.okapi.steps.rainbowkit.xliff.XLIFFPackageWriter;
import net.sf.okapi.steps.xsltransform.XSLTransformStep;
import org.custommonkey.xmlunit.XMLAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class ExtractionStepTest {
    private FileLocation root;
    private LocaleId locEN = LocaleId.fromString((String)"en");
    private LocaleId locFR = LocaleId.fromString((String)"fr");
    private LocaleId locENUS = LocaleId.fromString((String)"en-us");
    private LocaleId locRURU = LocaleId.fromString((String)"ru-ru");

    @Before
    public void setUp() {
        this.root = FileLocation.fromClass(this.getClass());
    }

    @Test
    public void stub() {
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testSimpleStep() {
        Assert.assertTrue((boolean)Util.deleteDirectory((File)this.root.out("/pack1").asFile()));
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(PropertiesFilter.class.getName());
        fcMapper.addConfigurations(OpenOfficeFilter.class.getName());
        fcMapper.addConfigurations(HTML5Filter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        ExtractionStep extStep = new ExtractionStep();
        String outputDir = this.root.out("/").toString();
        extStep.getParameters().setPackageDirectory(outputDir);
        pdriver.addStep((IPipelineStep)extStep);
        URI inputURI = this.root.in("/test01.properties").asUri();
        URI outputURI = new File("/test01.out.properties").toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_properties", outputURI, "UTF-8", this.locEN, this.locFR));
        inputURI = this.root.in("/test02.html").asUri();
        outputURI = new File("/test02.out.html").toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_itshtml5", outputURI, "UTF-8", this.locEN, this.locFR));
        inputURI = this.root.in("/sub Dir/test01.odt").asUri();
        outputURI = new File("/sub Dir/test01.out.odt").toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_openoffice", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        File file = this.root.out("/pack1/work/test01.properties.xlf").asFile();
        Assert.assertTrue((boolean)file.exists());
        file = this.root.out("/pack1/work/test02.html.xlf").asFile();
        Assert.assertTrue((boolean)file.exists());
        file = this.root.out("/pack1/work/sub Dir/test01.odt.xlf").asFile();
        Assert.assertTrue((boolean)file.exists());
    }

    @Test
    public void testICMLwithCDATAtoXLIFF2() {
        Assert.assertTrue((boolean)Util.deleteDirectory((File)this.root.out("/pack1").asFile()));
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(ICMLFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        ExtractionStep extractionStep = new ExtractionStep();
        Parameters params = new Parameters();
        String outputDir = this.root.out("/").toString();
        params.setPackageDirectory(outputDir);
        params.setWriterClass("net.sf.okapi.steps.rainbowkit.xliff.XLIFF2PackageWriter");
        extractionStep.setParameters((IParameters)params);
        pdriver.addStep((IPipelineStep)extractionStep);
        URI inputURI = this.root.in("/CDATA_Test.icml").asUri();
        URI outputURI = new File("/CDATA_Test.out.icml").toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_icml", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        File file = this.root.out("/pack1/work/CDATA_Test.icml.xlf").asFile();
        Assert.assertTrue((boolean)file.exists());
        XLIFFDocument xlf = new XLIFFDocument();
        xlf.load(file);
        Assert.assertNotNull((String)"There should be a file element in the generated XLIFF file.", (Object)xlf.getFileNode("f1"));
        Assert.assertEquals((String)"The XLIFF file should have two units.", (long)2L, (long)xlf.getUnits().size());
    }

    @DataProvider
    public static Object[][] extendedCodeTypesDataProvider() {
        return new Object[][]{{"extended-code-type-support.docx", OpenXMLFilter.class.getName(), "okf_openxml"}, {"extended-code-type-support.docx_en-US_fr-FR.sdlxliff", XLIFFFilter.class.getName(), "okf_xliff"}};
    }

    @Test
    @UseDataProvider(value="extendedCodeTypesDataProvider")
    public void testExtendedCodeTypes(String filename, String filterClassName, String filterConfigurationId) throws Exception {
        Path rootPath = this.root.in("/").asPath();
        Path packPath = rootPath.resolve("pack1");
        Assert.assertTrue((boolean)Util.deleteDirectory((File)packPath.toFile()));
        FilterConfigurationMapper filterConfigurationMapper = new FilterConfigurationMapper();
        filterConfigurationMapper.addConfigurations(filterClassName);
        Parameters parameters = new Parameters();
        parameters.setWriterOptions("#v1\nincludeCodeAttrs.b=true");
        ExtractionStep extractionStep = new ExtractionStep();
        extractionStep.setParameters((IParameters)parameters);
        PipelineDriver pdriver = new PipelineDriver();
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)filterConfigurationMapper);
        pdriver.setRootDirectories(rootPath.toString(), rootPath.toString());
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)extractionStep);
        Path inputPath = rootPath.resolve("code-type").resolve(filename);
        Path outputPath = packPath.resolve("work/code-type").resolve(filename + ".xlf");
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputPath.toUri(), StandardCharsets.UTF_8.name(), filterConfigurationId, outputPath.toUri(), StandardCharsets.UTF_8.name(), this.locENUS, this.locFR));
        pdriver.processBatch();
        Assert.assertTrue((boolean)outputPath.toFile().exists());
        try (BufferedReader out = Files.newBufferedReader(outputPath, StandardCharsets.UTF_8);
             BufferedReader gold = Files.newBufferedReader(rootPath.resolve("code-type/gold").resolve(filename + ".xlf"), StandardCharsets.UTF_8);){
            XMLAssert.assertXMLEqual((Reader)gold, (Reader)out);
        }
    }

    @Test
    public void testXINICreation() throws Exception {
        this.deleteOutputDir("/pack2");
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XLIFFFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)new CreateTargetStep());
        ExtractionStep es = new ExtractionStep();
        pdriver.addStep((IPipelineStep)es);
        Parameters params = es.getParameters();
        String outputDir = this.root.out("/").toString();
        params.setPackageDirectory(outputDir);
        params.setWriterClass(OntramPackageWriter.class.getName());
        params.setPackageName("pack2");
        URI inputURI = this.root.in("/xiniPack/original/test1.xlf").asUri();
        URI outputURI = new File("/pack2/original/test1.out.xlf").toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_xliff", outputURI, "UTF-8", this.locENUS, this.locRURU));
        pdriver.processBatch();
        File file = this.root.out("/pack2/xini/contents.xini").asFile();
        Assert.assertTrue((boolean)file.exists());
        try (BufferedReader goldReader = Files.newBufferedReader(this.root.in("/xiniPack/xini/contents.xini").asPath(), StandardCharsets.UTF_8);){
            String actual = new String(Files.readAllBytes(this.root.out("/pack2/xini/contents.xini").asPath()), StandardCharsets.UTF_8).replaceFirst("xiniPack/original", "");
            XMLAssert.assertXMLEqual((Reader)goldReader, (Reader)new StringReader(actual));
        }
        this.deleteOutputDir("/pack2");
    }

    @Test
    public void testExtractionAfterXSLTStep() throws Exception {
        this.deleteOutputDir("/pack3");
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XmlStreamFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.setOutputDirectory(rootDir);
        XSLTransformStep xslTransformStep = new XSLTransformStep();
        net.sf.okapi.steps.xsltransform.Parameters xsltParams = xslTransformStep.getParameters();
        xsltParams.setXsltPath(this.root.in("/xsltAndXliffPack/renameTags.xslt").toString());
        xsltParams.setPassOnOutput(true);
        pdriver.addStep((IPipelineStep)xslTransformStep);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        ExtractionStep es = new ExtractionStep();
        Parameters params = es.getParameters();
        params.setWriterClass(XLIFFPackageWriter.class.getName());
        params.setPackageName("pack3");
        pdriver.addStep((IPipelineStep)es);
        URI inputURI = this.root.in("/xsltAndXliffPack/original/test.xml").asUri();
        URI outputURI = this.root.out("/xsltAndXliffPack-Output/test.xml").asUri();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_xmlstream", outputURI, "UTF-8", this.locENUS, this.locRURU));
        pdriver.processBatch();
        File xsltOutputFile = this.root.out("/xsltAndXliffPack-Output/test.xml").asFile();
        Assert.assertTrue((boolean)xsltOutputFile.exists());
        File rainbowkitOriginalFile = this.root.in("/pack3/original/xsltAndXliffPack/original/test.xml").asFile();
        Assert.assertTrue((boolean)rainbowkitOriginalFile.exists());
        try (BufferedReader xsltOutputFileReader = Files.newBufferedReader(xsltOutputFile.toPath(), StandardCharsets.UTF_8);
             BufferedReader rainbowkitOriginalFileReader = Files.newBufferedReader(rainbowkitOriginalFile.toPath(), StandardCharsets.UTF_8);){
            XMLAssert.assertXMLEqual((Reader)xsltOutputFileReader, (Reader)rainbowkitOriginalFileReader);
        }
        this.deleteOutputDir("/pack3");
        this.deleteOutputDir("/xsltAndXliffPack-Output");
    }

    public void deleteOutputDir(String dirname) {
        Util.deleteDirectory((String)this.root.out(dirname).toString(), (boolean)false);
    }
}

