/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.postprocess;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.PipelineParameters;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.filters.rainbowkit.Manifest;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.filters.xliff.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Merger {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IFilter filter;
    private IFilterWriter writer;
    private Manifest manifest;
    private LocaleId trgLoc;
    private IFilterConfigurationMapper fcMapper;
    private boolean skipEmptySourceEntries;
    private boolean useSource;
    private boolean preserveSegmentation;
    private boolean forceSegmentationInMerge;
    private boolean returnRawDocument;
    private String overrideOutputPath;
    private RawDocument rawDoc;
    private boolean useSubDoc;
    private int errorCount;

    public Merger(Manifest manifest, IFilterConfigurationMapper fcMapper, boolean preserveSegmentation, LocaleId forcedTargetLocale, boolean returnRawDocument, String overrideOutputPath) {
        this.fcMapper = fcMapper;
        this.manifest = manifest;
        this.trgLoc = forcedTargetLocale != null ? forcedTargetLocale : manifest.getTargetLocale();
        this.preserveSegmentation = preserveSegmentation;
        this.returnRawDocument = returnRawDocument;
        this.overrideOutputPath = overrideOutputPath;
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.filter != null) {
            this.filter.close();
            this.filter = null;
        }
    }

    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case TEXT_UNIT: {
                this.processTextUnit(event);
                if (!this.returnRawDocument) break;
                event = Event.createNoopEvent();
                break;
            }
            case START_SUBDOCUMENT: {
                if (!this.returnRawDocument) break;
                this.useSubDoc = true;
                event = Event.createNoopEvent();
                break;
            }
            case END_DOCUMENT: {
                this.flushFilterEvents();
                this.close();
                if (!this.returnRawDocument || this.useSubDoc) break;
                event = this.createMultiEvent();
                break;
            }
            default: {
                if (!this.returnRawDocument) break;
                event = Event.createNoopEvent();
            }
        }
        return event;
    }

    private void processStartDocument(StartDocument sd) {
        Parameters prm;
        this.forceSegmentationInMerge = sd.getMimeType().equals("application/x-xliff+xml") ? (prm = (Parameters)sd.getFilterParameters()).getOutputSegmentationType() == Parameters.SegmentationType.SEGMENTED : false;
    }

    private Event createMultiEvent() {
        ArrayList<Event> list = new ArrayList<Event>();
        PipelineParameters pp = new PipelineParameters();
        pp.setOutputURI(this.rawDoc.getInputURI());
        pp.setSourceLocale(this.rawDoc.getSourceLocale());
        pp.setTargetLocale(this.rawDoc.getTargetLocale());
        pp.setOutputEncoding(this.rawDoc.getEncoding());
        pp.setInputRawDocument(this.rawDoc);
        list.add(new Event(EventType.PIPELINE_PARAMETERS, (IResource)pp));
        list.add(new Event(EventType.RAW_DOCUMENT, (IResource)this.rawDoc));
        return new Event(EventType.MULTI_EVENT, (IResource)new MultiEvent(list));
    }

    public Event startMerging(MergingInfo info, Event event) {
        this.errorCount = 0;
        this.useSubDoc = false;
        this.logger.info("Merging: {}", (Object)info.getRelativeInputPath());
        this.filter = this.fcMapper.createFilter(info.getFilterId(), this.filter);
        if (this.filter == null) {
            throw new OkapiBadFilterInputException(String.format("Filter cannot be created (%s).", info.getFilterId()));
        }
        IParameters fprm = this.filter.getParameters();
        if (fprm != null) {
            fprm.fromString(info.getFilterParameters());
        }
        File file = new File(this.manifest.getTempOriginalDirectory() + info.getRelativeInputPath());
        RawDocument rd = new RawDocument(file.toURI(), info.getInputEncoding(), this.manifest.getSourceLocale(), this.trgLoc);
        this.filter.open(rd);
        this.writer = this.filter.createFilterWriter();
        this.writer.setOptions(this.trgLoc, info.getTargetEncoding());
        String outPath = this.getOutputPath(info);
        this.writer.setOutput(outPath);
        this.skipEmptySourceEntries = info.getExtractionType().equals("po") || info.getExtractionType().equals("transifex") || info.getExtractionType().equals("table");
        this.useSource = info.getExtractionType().equals("ontram");
        Event internalEvent = null;
        if (this.filter.hasNext()) {
            internalEvent = this.filter.next();
        }
        if (internalEvent == null || internalEvent.getEventType() != EventType.START_DOCUMENT) {
            ++this.errorCount;
            this.logger.error("The start document event is missing when parsing the original file.");
        } else {
            this.writer.handleEvent(internalEvent);
            this.processStartDocument(internalEvent.getStartDocument());
        }
        if (this.returnRawDocument) {
            this.rawDoc = event.getStartDocument().isMultilingual() ? new RawDocument(new File(outPath).toURI(), info.getTargetEncoding(), this.manifest.getSourceLocale(), this.manifest.getTargetLocale()) : new RawDocument(new File(outPath).toURI(), info.getTargetEncoding(), this.manifest.getTargetLocale(), this.manifest.getTargetLocale());
            event = Event.createNoopEvent();
        } else {
            event = internalEvent;
        }
        return event;
    }

    private String getOutputPath(MergingInfo info) {
        if (Util.isEmpty((String)this.overrideOutputPath)) {
            return this.manifest.getMergeDirectory() + info.getRelativeTargetPath();
        }
        return Util.ensureSeparator((String)this.overrideOutputPath, (boolean)false) + info.getRelativeTargetPath();
    }

    private void flushFilterEvents() {
        while (this.filter.hasNext()) {
            this.writer.handleEvent(this.filter.next());
        }
        this.writer.close();
    }

    private void processTextUnit(Event event) {
        ITextUnit traTu = event.getTextUnit();
        if (!traTu.isTranslatable()) {
            return;
        }
        Event oriEvent = this.processUntilTextUnit();
        if (oriEvent == null) {
            ++this.errorCount;
            this.logger.error("No corresponding text unit for id='{}' in the original file.", (Object)traTu.getId());
            return;
        }
        ITextUnit oriTu = oriEvent.getTextUnit();
        if (!traTu.getId().equals(oriTu.getId())) {
            ++this.errorCount;
            this.logger.error("De-synchronized files: translated TU id='{}', Original TU id='{}'.", (Object)traTu.getId(), (Object)oriTu.getId());
            return;
        }
        TextContainer trgTraCont = this.useSource ? traTu.getSource() : traTu.getTarget(this.trgLoc);
        if (trgTraCont == null) {
            if (oriTu.getSource().hasText()) {
                this.logger.warn("No translation found for TU id='{}'. Using source instead.", (Object)traTu.getId());
            }
            this.writer.handleEvent(oriEvent);
            return;
        }
        boolean isTransApproved = false;
        Property traProp = this.useSource ? traTu.getSourceProperty("approved") : traTu.getTargetProperty(this.trgLoc, "approved");
        if (traProp != null) {
            isTransApproved = traProp.getValue().equals("yes");
        }
        if (!isTransApproved && this.manifest.getUseApprovedOnly()) {
            this.logger.warn("Item id='{}': Target is not approved. Using source instead.", (Object)traTu.getId());
            this.writer.handleEvent(oriEvent);
            return;
        }
        boolean mergeAsSegments = false;
        if (oriTu.getMimeType() != null && (oriTu.getMimeType().equals("application/x-ttx+xml") || oriTu.getMimeType().equals("application/x-xliff+xml"))) {
            mergeAsSegments = true;
        }
        TextContainer srcOriCont = oriTu.getSource();
        TextContainer srcTraCont = traTu.getSource();
        if (this.forceSegmentationInMerge && !srcOriCont.getUnSegmentedContentCopy().getCodedText().equals(srcTraCont.getUnSegmentedContentCopy().getCodedText())) {
            this.logger.warn("Item id='{}': Original source and source in the translated file are different.\nCannot use the source of the translation as the new segmented source.", (Object)traTu.getId());
        }
        List srcRanges = null;
        List trgRanges = null;
        if (!srcOriCont.contentIsOneSegment()) {
            if (mergeAsSegments) {
                srcRanges = srcOriCont.getSegments().getRanges();
            }
            srcOriCont.joinAll();
        }
        if (this.forceSegmentationInMerge) {
            if (!srcTraCont.contentIsOneSegment()) {
                srcRanges = srcTraCont.getSegments().getRanges();
            }
        } else if (!srcOriCont.contentIsOneSegment()) {
            srcRanges = srcOriCont.getSegments().getRanges();
        }
        if (!trgTraCont.contentIsOneSegment()) {
            trgRanges = trgTraCont.getSegments().getRanges();
            trgTraCont.joinAll();
        }
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes((TextFragment)srcOriCont.getFirstContent(), (TextFragment)trgTraCont.getFirstContent(), (boolean)true, (boolean)true, null, (ITextUnit)oriTu);
        if (mergeAsSegments) {
            if (srcRanges != null) {
                srcOriCont.getSegments().create(srcRanges, true);
            }
            if (trgRanges != null) {
                trgTraCont.getSegments().create(trgRanges, true);
            }
        }
        if (srcOriCont.getSegments().count() < trgTraCont.getSegments().count()) {
            this.logger.warn("Item id='{}': There is at least one extra segment in the translation file.\nExtra segments are not merged into the translated output.", (Object)traTu.getId());
        }
        oriTu.setTarget(this.trgLoc, trgTraCont);
        if (this.manifest.getUpdateApprovedFlag()) {
            Property oriProp = oriTu.createTargetProperty(this.trgLoc, "approved", false, 0);
            if (traProp != null) {
                oriProp.setValue(traProp.getValue());
            } else {
                oriProp.setValue("yes");
            }
        }
        this.writer.handleEvent(oriEvent);
        if (this.preserveSegmentation && !mergeAsSegments) {
            if (srcRanges != null) {
                srcOriCont.getSegments().create(srcRanges, true);
            }
            if (trgRanges != null) {
                trgTraCont.getSegments().create(trgRanges, true);
            }
        }
    }

    private Event processUntilTextUnit() {
        while (this.filter.hasNext()) {
            Event event = this.filter.next();
            if (event.getEventType() == EventType.TEXT_UNIT) {
                ITextUnit tu = event.getTextUnit();
                if (!tu.isTranslatable()) {
                    this.writer.handleEvent(event);
                    continue;
                }
                if (this.skipEmptySourceEntries && tu.isEmpty()) {
                    this.writer.handleEvent(event);
                    continue;
                }
                return event;
            }
            this.writer.handleEvent(event);
        }
        return null;
    }

    public int getErrorCount() {
        return this.errorCount;
    }
}

