/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.xliff;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.rainbowkit.creation.ExtractionStep;
import net.sf.okapi.steps.segmentation.Parameters;
import net.sf.okapi.steps.segmentation.SegmentationStep;
import net.sf.okapi.steps.terminologyleveraging.BaseTerminologyConnector;
import net.sf.okapi.steps.terminologyleveraging.TerminologyLeveragingStep;
import net.sf.okapi.steps.terminologyleveraging.TerminologyParameters;
import net.sf.okapi.steps.terminologyleveraging.TerminologyQueryResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class TerminologyStepTest {
    private FileLocation root;
    private LocaleId locEN = LocaleId.fromString((String)"en");
    private LocaleId locFR = LocaleId.fromString((String)"fr");

    @Before
    public void setUp() {
        this.root = FileLocation.fromClass(this.getClass());
    }

    @Test
    public void test() {
        Util.deleteDirectory((String)this.root.out("/xliff-terminology/work").toString(), (boolean)false);
        String outFile = "/xliff-terminology/work/test-terminology.html.xlf";
        PipelineDriver pipelineDriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(HtmlFilter.class.getName());
        pipelineDriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = this.root.in("/").toString();
        pipelineDriver.setRootDirectories(rootDir, rootDir);
        pipelineDriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        SegmentationStep segmentationStep = new SegmentationStep();
        Parameters segmentationParameters = (Parameters)segmentationStep.getParameters();
        segmentationParameters.setSegmentSource(true);
        segmentationParameters.setSegmentTarget(false);
        segmentationParameters.setRenumberCodes(false);
        segmentationParameters.setSourceSrxPath(this.root.in("/defaultSegmentation.srx").toString());
        segmentationParameters.setCopySource(true);
        segmentationParameters.setCheckSegments(false);
        segmentationParameters.setTrimSrcLeadingWS(-1);
        segmentationParameters.setTrimSrcTrailingWS(-1);
        segmentationParameters.setTrimTrgLeadingWS(-1);
        segmentationParameters.setTrimTrgTrailingWS(-1);
        segmentationParameters.setForcesegmentedOutput(true);
        segmentationParameters.setOverwriteSegmentation(false);
        segmentationParameters.setDeepenSegmentation(false);
        pipelineDriver.addStep((IPipelineStep)segmentationStep);
        TerminologyLeveragingStep terminologyLeveragingStep = new TerminologyLeveragingStep();
        TerminologyParameters terminologyParams = (TerminologyParameters)terminologyLeveragingStep.getParameters();
        terminologyParams.setLeverage(true);
        terminologyParams.setAnnotateSource(true);
        terminologyParams.setAnnotateTarget(true);
        terminologyParams.setConnectorClassName("net.sf.okapi.steps.rainbowkit.xliff.TerminologyStepTest$DefaultTerminologyConnector");
        pipelineDriver.addStep((IPipelineStep)terminologyLeveragingStep);
        ExtractionStep extractionStep = new ExtractionStep();
        String outputDir = this.root.out("/").toString();
        ((net.sf.okapi.steps.rainbowkit.creation.Parameters)extractionStep.getParameters()).setPackageDirectory(outputDir);
        pipelineDriver.addStep((IPipelineStep)extractionStep);
        net.sf.okapi.steps.rainbowkit.creation.Parameters ep = (net.sf.okapi.steps.rainbowkit.creation.Parameters)extractionStep.getParameters();
        ep.setWriterClass("net.sf.okapi.steps.rainbowkit.xliff.XLIFF2TerminologyPackageWriter");
        ep.setPackageName("xliff-terminology");
        URI inputURI = this.root.in("/test-terminology.html").asUri();
        URI outputURI = new File(outFile).toURI();
        pipelineDriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_html", outputURI, "UTF-8", this.locEN, this.locFR));
        pipelineDriver.processBatch();
        Assert.assertTrue((boolean)this.root.out(outFile).asFile().exists());
    }

    public static class DefaultTerminologyConnector
    extends BaseTerminologyConnector {
        private final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        public static Map<String, TerminologyQueryResult> translations = new HashMap<String, TerminologyQueryResult>();

        public String generateGlossEntryId(int segmentIndex, int termIndexInSegment, TerminologyQueryResult.Term term) {
            return term.getId() + GLOSS_ENTRY_SEPARATOR_CHAR + segmentIndex + GLOSS_ENTRY_SEPARATOR_CHAR + termIndexInSegment;
        }

        public String generateGlossEntryTranslationId(int segmentIndex, int termIndexInSegment, TerminologyQueryResult.Term term, TerminologyQueryResult.Translation translation) {
            return term.getId() + GLOSS_ENTRY_SEPARATOR_CHAR + segmentIndex + GLOSS_ENTRY_SEPARATOR_CHAR + termIndexInSegment + GLOSS_ENTRY_TRANSLATION_ID_SEPARATOR_CHAR + translation.getId();
        }

        public String getName() {
            return "Default-Terminology-Connector";
        }

        public void open() {
            this.LOGGER.info("Opening terminology connector");
        }

        public void close() {
            this.LOGGER.info("Closing terminology connector");
        }

        protected List<List<TerminologyQueryResult>> query(List<String> sourceSegments) {
            ArrayList<List<TerminologyQueryResult>> results = new ArrayList<List<TerminologyQueryResult>>();
            for (String segmentSource : sourceSegments) {
                ArrayList<TerminologyQueryResult> segmentResults = new ArrayList<TerminologyQueryResult>();
                for (String term : translations.keySet()) {
                    if (!segmentSource.contains(term)) continue;
                    segmentResults.add(translations.get(term));
                }
                results.add(segmentResults);
            }
            return results;
        }

        static {
            TerminologyQueryResult queryResult = new TerminologyQueryResult();
            queryResult.setTerm(new TerminologyQueryResult.Term("0", "censhare", "Alice"));
            queryResult.addTranslation("52", "Alice");
            queryResult.addTranslation("53", "Anya");
            translations.put(queryResult.getTerm().getTermText(), queryResult);
            TerminologyQueryResult queryResult1 = new TerminologyQueryResult();
            queryResult1.setTerm(new TerminologyQueryResult.Term("0", "censhare", "White Rabbit"));
            queryResult1.addTranslation("48", "wei\u00dfes Kaninchen");
            queryResult1.addTranslation("49", "Kaninchen (wei\u00df)");
            translations.put(queryResult1.getTerm().getTermText(), queryResult1);
            TerminologyQueryResult queryResult2 = new TerminologyQueryResult();
            queryResult2.setTerm(new TerminologyQueryResult.Term("0", "censhare", "Rabbit"));
            queryResult2.addTranslation("42", "Kaninchen");
            translations.put(queryResult2.getTerm().getTermText(), queryResult2);
        }
    }
}

