/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.xliff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.filters.properties.PropertiesFilter;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.rainbowkit.creation.ExtractionStep;
import net.sf.okapi.steps.rainbowkit.xliff.XLIFFPackageWriter;
import net.sf.okapi.steps.xsltransform.Parameters;
import net.sf.okapi.steps.xsltransform.XSLTransformStep;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@RunWith(value=JUnit4.class)
public class ExtractionStepTest {
    private FileLocation root;
    private LocaleId locEN = LocaleId.fromString((String)"en");
    private LocaleId locFR = LocaleId.fromString((String)"fr");

    @Before
    public void setUp() {
        this.root = FileLocation.fromClass(this.getClass());
    }

    @Test
    public void testSimpleStep() throws XpathException, FileNotFoundException, SAXException, IOException {
        Assert.assertTrue((boolean)Util.deleteDirectory((File)this.root.out("/packXliff1").asFile()));
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(PropertiesFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        ExtractionStep es = new ExtractionStep();
        net.sf.okapi.steps.rainbowkit.creation.Parameters params = (net.sf.okapi.steps.rainbowkit.creation.Parameters)es.getParameters();
        String outputDir = this.root.out("/").toString();
        params.setPackageDirectory(outputDir);
        params.setWriterClass(XLIFFPackageWriter.class.getName());
        params.setSendOutput(true);
        params.setPackageName("packXliff1");
        pdriver.addStep((IPipelineStep)es);
        XSLTransformStep xslTransformStep = new XSLTransformStep();
        Parameters xsltParams = (Parameters)xslTransformStep.getParameters();
        xsltParams.setXsltPath(this.root.in("/addCustomAttribute.xsl").toString());
        xsltParams.setPassOnOutput(true);
        pdriver.addStep((IPipelineStep)xslTransformStep);
        URI inputURI = this.root.in("/test01.properties").asUri();
        URI outputURI = new File("/test01.out.properties").toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_properties", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        File file = this.root.out("/packXliff1/work/test01.properties.xlf").asFile();
        Assert.assertTrue((boolean)file.exists());
        HashMap<String, String> nsPrefixes = new HashMap<String, String>();
        nsPrefixes.put("custom", "custom-uri");
        nsPrefixes.put("xlf", "urn:oasis:names:tc:xliff:document:1.2");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(nsPrefixes));
        XMLAssert.assertXpathEvaluatesTo((String)"custom-val", (String)"/xlf:xliff/xlf:file/@custom:custom-attribute", (InputSource)new InputSource(new FileInputStream(file)));
    }
}

