/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.msbatchtranslation;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.AbstractPart;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.PathInputPart;
import net.sf.okapi.common.uidescription.SeparatorPart;
import net.sf.okapi.common.uidescription.SpinInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;
import net.sf.okapi.common.uidescription.TextLabelPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String AZUREKEY = "azureKey";
    private static final String CATEGORY = "category";
    private static final String CONFIGPATH = "configPath";
    private static final String ANNOTATE = "annotate";
    private static final String MAKETMX = "makeTmx";
    private static final String TMXPATH = "tmxPath";
    private static final String MARKASMT = "markAsMT";
    private static final String MAXEVENTS = "maxEvents";
    private static final String MAXMATCHES = "maxMatches";
    private static final String THRESHOLD = "threshold";
    private static final String FILLTARGET = "fillTarget";
    private static final String FILLTARGETTHRESHOLD = "fillTargetThreshold";
    private static final String ONLYWHENWITHOUTCANDIDATE = "onlyWhenWithoutCandidate";
    private static final String SENDTMX = "sendTmx";

    public Parameters() {
    }

    public Parameters(String initialData) {
        super(initialData);
    }

    public void reset() {
        super.reset();
        this.setAzureKey("");
        this.setCategory("");
        this.setTmxPath("${rootDir}/tmFromMS.tmx");
        this.setConfigPath("");
        this.setMarkAsMT(true);
        this.setMaxEvents(20);
        this.setMaxMatches(1);
        this.setThreshold(80);
        this.setMakeTmx(false);
        this.setAnnotate(true);
        this.setFillTarget(true);
        this.setFillTargetThreshold(95);
        this.setOnlyWhenWithoutCandidate(true);
        this.setSendTmx(false);
    }

    public boolean getFillTarget() {
        return this.getBoolean(FILLTARGET);
    }

    public void setFillTarget(boolean fillTarget) {
        this.setBoolean(FILLTARGET, fillTarget);
    }

    public int getFillTargetThreshold() {
        return this.getInteger(FILLTARGETTHRESHOLD);
    }

    public void setFillTargetThreshold(int fillTargetThreshold) {
        this.setInteger(FILLTARGETTHRESHOLD, fillTargetThreshold);
    }

    public boolean getMarkAsMT() {
        return this.getBoolean(MARKASMT);
    }

    public void setMarkAsMT(boolean markAsMT) {
        this.setBoolean(MARKASMT, markAsMT);
    }

    public int getMaxEvents() {
        return this.getInteger(MAXEVENTS);
    }

    public void setMaxEvents(int maxEvents) {
        this.setInteger(MAXEVENTS, maxEvents);
    }

    public int getThreshold() {
        return this.getInteger(THRESHOLD);
    }

    public void setThreshold(int threshold) {
        this.setInteger(THRESHOLD, threshold);
    }

    public int getMaxMatches() {
        return this.getInteger(MAXMATCHES);
    }

    public void setMaxMatches(int maxMatches) {
        this.setInteger(MAXMATCHES, maxMatches);
    }

    public String getTmxPath() {
        return this.getString(TMXPATH);
    }

    public void setTmxPath(String tmxPath) {
        this.setString(TMXPATH, tmxPath);
    }

    public String getConfigPath() {
        return this.getString(CONFIGPATH);
    }

    public void setConfigPath(String configPath) {
        this.setString(CONFIGPATH, configPath);
    }

    public String getAzureKey() {
        return this.getString(AZUREKEY);
    }

    public void setAzureKey(String azureKey) {
        this.setString(AZUREKEY, azureKey);
    }

    public String getCategory() {
        return this.getString(CATEGORY);
    }

    public void setCategory(String category) {
        this.setString(CATEGORY, category);
    }

    public boolean getMakeTmx() {
        return this.getBoolean(MAKETMX);
    }

    public void setMakeTmx(boolean makeTmx) {
        this.setBoolean(MAKETMX, makeTmx);
    }

    public boolean getAnnotate() {
        return this.getBoolean(ANNOTATE);
    }

    public void setAnnotate(boolean annotate) {
        this.setBoolean(ANNOTATE, annotate);
    }

    public boolean getOnlyWhenWithoutCandidate() {
        return this.getBoolean(ONLYWHENWITHOUTCANDIDATE);
    }

    public void setOnlyWhenWithoutCandidate(boolean onlyWhenWithoutCandidate) {
        this.setBoolean(ONLYWHENWITHOUTCANDIDATE, onlyWhenWithoutCandidate);
    }

    public boolean getSendTmx() {
        return this.getBoolean(SENDTMX);
    }

    public void setSendTmx(boolean sendTmx) {
        this.setBoolean(SENDTMX, sendTmx);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(AZUREKEY, "Azure Key", "Microsoft Azure subscription key");
        desc.add(CATEGORY, "Category", "Category code if accessing a trained system");
        desc.add(CONFIGPATH, "Engine mapping", "Full path of the properties file listing the engines");
        desc.add(MAXEVENTS, "Events buffer", "Number of events to store before sending a query");
        desc.add(MAXMATCHES, "Maximum matches", "Maximum number of matches allowed");
        desc.add(THRESHOLD, "Threshold", "Score below which matches are not retained");
        desc.add(ONLYWHENWITHOUTCANDIDATE, "Query only entries without existing candidate", null);
        desc.add(TMXPATH, null, "Full path of the new TMX document to create");
        desc.add(MARKASMT, "Mark the generated translation as machine translation results", null);
        desc.add(MAKETMX, "Generate a TMX document", null);
        desc.add(SENDTMX, "Send the TMX document to the next step", null);
        desc.add(ANNOTATE, "Annotate the text units with the translations", null);
        desc.add(FILLTARGET, "Fill the target with the best translation candidate", null);
        desc.add(FILLTARGETTHRESHOLD, "Fill threshold", "Fill the target when the best candidate is equal or above this score");
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Microsoft Batch Translation Settings");
        TextLabelPart tlp = desc.addTextLabelPart("Powered by Microsoft\u00ae Translator");
        tlp.setVertical(true);
        SeparatorPart sp = desc.addSeparatorPart();
        sp.setVertical(true);
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(AZUREKEY));
        tip.setPassword(true);
        tip = desc.addTextInputPart(paramsDesc.get(CATEGORY));
        tip.setAllowEmpty(true);
        tip.setPassword(false);
        PathInputPart pip1 = desc.addPathInputPart(paramsDesc.get(CONFIGPATH), "Config Path", false);
        pip1.setBrowseFilters("MS HUB Config (*.properties)\tAll Files (*.*)", "*.properties\t*.*");
        pip1.setVertical(false);
        pip1.setWithLabel(true);
        pip1.setAllowEmpty(true);
        sp = desc.addSeparatorPart();
        sp.setVertical(true);
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get(MAXEVENTS));
        sip.setRange(1, 999);
        sip = desc.addSpinInputPart(paramsDesc.get(MAXMATCHES));
        sip.setRange(1, 100);
        sip = desc.addSpinInputPart(paramsDesc.get(THRESHOLD));
        sip.setRange(1, 100);
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(ONLYWHENWITHOUTCANDIDATE));
        cbp.setVertical(true);
        sp = desc.addSeparatorPart();
        sp.setVertical(true);
        cbp = desc.addCheckboxPart(paramsDesc.get(ANNOTATE));
        cbp.setVertical(true);
        CheckboxPart master = desc.addCheckboxPart(paramsDesc.get(MAKETMX));
        master.setVertical(true);
        PathInputPart pip = desc.addPathInputPart(paramsDesc.get(TMXPATH), "TMX Path", true);
        pip.setBrowseFilters("TMX Documents (*.tmx)\tAll Files (*.*)", "*.tmx\t*.*");
        pip.setVertical(true);
        pip.setWithLabel(false);
        pip.setMasterPart((AbstractPart)master, true);
        cbp = desc.addCheckboxPart(paramsDesc.get(SENDTMX));
        cbp.setVertical(true);
        cbp.setMasterPart((AbstractPart)master, true);
        cbp = desc.addCheckboxPart(paramsDesc.get(MARKASMT));
        cbp.setVertical(true);
        cbp.setMasterPart((AbstractPart)master, true);
        sp = desc.addSeparatorPart();
        sp.setVertical(true);
        cbp = desc.addCheckboxPart(paramsDesc.get(FILLTARGET));
        cbp.setVertical(true);
        sip = desc.addSpinInputPart(paramsDesc.get(FILLTARGETTHRESHOLD));
        sip.setRange(1, 100);
        sip.setMasterPart((AbstractPart)cbp, true);
        return desc;
    }
}

