/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.moses;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.AbstractPart;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=MergingParameters.class)
public class MergingParameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String COPYTOTARGET = "copyToTarget";
    private static final String OVERWRITEEXISINGTARGET = "overwriteExistingTarget";
    private static final String FORCEALTTRANSOUTPUT = "forceAltTransOutput";
    private static final String USEGMODEINALTTRANS = "useGModeInAltTrans";

    public boolean getCopyToTarget() {
        return this.getBoolean(COPYTOTARGET);
    }

    public void setCopyToTarget(boolean copyToTarget) {
        this.setBoolean(COPYTOTARGET, copyToTarget);
    }

    public boolean getOverwriteExistingTarget() {
        return this.getBoolean(OVERWRITEEXISINGTARGET);
    }

    public void setOverwriteExistingTarget(boolean overwriteExistingTarget) {
        this.setBoolean(OVERWRITEEXISINGTARGET, overwriteExistingTarget);
    }

    public boolean getForceAltTransOutput() {
        return this.getBoolean(FORCEALTTRANSOUTPUT);
    }

    public void setForceAltTransOutput(boolean forceAltTransOutput) {
        this.setBoolean(FORCEALTTRANSOUTPUT, forceAltTransOutput);
    }

    public boolean getUseGModeInAltTrans() {
        return this.getBoolean(USEGMODEINALTTRANS);
    }

    public void setUseGModeInAltTrans(boolean useGModeInAltTrans) {
        this.setBoolean(USEGMODEINALTTRANS, useGModeInAltTrans);
    }

    public void reset() {
        super.reset();
        this.setCopyToTarget(false);
        this.setOverwriteExistingTarget(false);
        this.setForceAltTransOutput(true);
        this.setUseGModeInAltTrans(true);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(COPYTOTARGET, "Copy the leveraged translation into the target", null);
        desc.add(OVERWRITEEXISINGTARGET, "Overwrite any existing target text", null);
        desc.add(FORCEALTTRANSOUTPUT, "In XLIFF, force the new <alt-trans> in the output", null);
        desc.add(USEGMODEINALTTRANS, "Use the <g> notation in new <alt-trans> elements", null);
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Moses InlineText Leveraging", true, false);
        CheckboxPart cbp1 = desc.addCheckboxPart(paramDesc.get(COPYTOTARGET));
        CheckboxPart cbp2 = desc.addCheckboxPart(paramDesc.get(OVERWRITEEXISINGTARGET));
        cbp2.setMasterPart((AbstractPart)cbp1, true);
        cbp1 = desc.addCheckboxPart(paramDesc.get(FORCEALTTRANSOUTPUT));
        desc.addCheckboxPart(paramDesc.get(USEGMODEINALTTRANS)).setMasterPart((AbstractPart)cbp1, true);
        return desc;
    }
}

