/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.moses;

import java.io.File;
import java.util.ArrayList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.FileCompare;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.filters.FilterTestDriver;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.steps.common.FilterEventsToRawDocumentStep;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.moses.ExtractionStep;
import net.sf.okapi.steps.moses.MergingParameters;
import net.sf.okapi.steps.moses.MergingStep;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ExtractMergeTest {
    private FileLocation root;
    private LocaleId locEN = LocaleId.ENGLISH;
    private LocaleId locJA = LocaleId.JAPANESE;
    private LocaleId locFR = LocaleId.FRENCH;
    private FileCompare fc;

    public ExtractMergeTest() {
        this.root = FileLocation.fromClass(this.getClass());
        this.fc = new FileCompare();
    }

    @Test
    public void testExtracThenMerge() {
        File inFile = this.root.in("/Test-XLIFF01.xlf").asFile();
        File out1File = this.root.out("/Test-XLIFF01.xlf.en").asFile();
        File gold1File = this.root.in("/Test-XLIFF01.xlf.en_gold").asFile();
        File transFile = this.root.in("/Test-XLIFF01.xlf.en_trans").asFile();
        File out2File = this.root.out("/Test-XLIFF01.out.xlf").asFile();
        out1File.delete();
        Assert.assertFalse((boolean)out1File.exists());
        out2File.delete();
        Assert.assertFalse((boolean)out2File.exists());
        PipelineDriver pd = new PipelineDriver();
        pd.addStep((IPipelineStep)new RawDocumentToFilterEventsStep((IFilter)new XLIFFFilter()));
        pd.addStep((IPipelineStep)new ExtractionStep());
        BatchItemContext item = new BatchItemContext(inFile.toURI(), "UTF-8", "okf_xliff", out1File.toURI(), "UTF-8", this.locEN, this.locJA);
        pd.addBatchItem((IBatchItemContext)item);
        pd.processBatch();
        Assert.assertTrue((boolean)out1File.exists());
        Assert.assertTrue((boolean)this.fc.compareFilesPerLines(out1File.getAbsolutePath(), gold1File.getAbsolutePath(), "UTF-8"));
        pd = new PipelineDriver();
        pd.addStep((IPipelineStep)new RawDocumentToFilterEventsStep((IFilter)new XLIFFFilter()));
        pd.addStep((IPipelineStep)new MergingStep());
        pd.addStep((IPipelineStep)new FilterEventsToRawDocumentStep());
        RawDocument rd1 = new RawDocument(inFile.toURI(), "UTF-8", this.locEN, this.locJA, "okf_xliff");
        RawDocument rd2 = new RawDocument(transFile.toURI(), "UTF-8", this.locJA);
        pd.addBatchItem((IBatchItemContext)new BatchItemContext(rd1, out2File.toURI(), "UTF-8", new RawDocument[]{rd2}));
        pd.processBatch();
        Assert.assertTrue((boolean)out2File.exists());
    }

    @Test
    public void testExtracThenMergeWithAlt() {
        File inFile = this.root.in("/Test-XLIFF02.xlf").asFile();
        File out1File = this.root.out("/Test-XLIFF02.xlf.en").asFile();
        File transFile = this.root.in("/Test-XLIFF02.xlf.en_trans").asFile();
        File out2File = this.root.out("/Test-XLIFF02.out.xlf").asFile();
        out1File.delete();
        Assert.assertFalse((boolean)out1File.exists());
        out2File.delete();
        Assert.assertFalse((boolean)out2File.exists());
        PipelineDriver pd = new PipelineDriver();
        pd.addStep((IPipelineStep)new RawDocumentToFilterEventsStep((IFilter)new XLIFFFilter()));
        pd.addStep((IPipelineStep)new ExtractionStep());
        BatchItemContext item = new BatchItemContext(inFile.toURI(), "UTF-8", "okf_xliff", out1File.toURI(), "UTF-8", this.locEN, this.locFR);
        pd.addBatchItem((IBatchItemContext)item);
        pd.processBatch();
        Assert.assertTrue((boolean)out1File.exists());
        pd = new PipelineDriver();
        pd.addStep((IPipelineStep)new RawDocumentToFilterEventsStep((IFilter)new XLIFFFilter()));
        MergingStep step = new MergingStep();
        MergingParameters p = (MergingParameters)step.getParameters();
        p.setCopyToTarget(true);
        pd.addStep((IPipelineStep)step);
        pd.addStep((IPipelineStep)new FilterEventsToRawDocumentStep());
        RawDocument rd1 = new RawDocument(inFile.toURI(), "UTF-8", this.locEN, this.locFR, "okf_xliff");
        RawDocument rd2 = new RawDocument(transFile.toURI(), "UTF-8", this.locFR);
        pd.addBatchItem((IBatchItemContext)new BatchItemContext(rd1, out2File.toURI(), "UTF-8", new RawDocument[]{rd2}));
        pd.processBatch();
        Assert.assertTrue((boolean)out2File.exists());
        ArrayList<Event> list = this.getEventsFromFile((IFilter)new XLIFFFilter(), out2File.getAbsolutePath(), this.locFR);
        ITextUnit tu = FilterTestDriver.getTextUnit(list, (int)2);
        Assert.assertNotNull((Object)tu);
        Assert.assertEquals((Object)"2", (Object)tu.getId());
        ISegments segs = tu.getTarget(this.locFR).getSegments();
        Assert.assertEquals((long)2L, (long)segs.count());
        for (Segment seg : segs) {
            Assert.assertTrue((boolean)seg.text.toText().startsWith("FR "));
            AltTranslationsAnnotation ann = (AltTranslationsAnnotation)seg.getAnnotation(AltTranslationsAnnotation.class);
            Assert.assertNotNull((Object)ann);
            Assert.assertTrue((boolean)ann.getFirst().getTarget().toString().startsWith("FR "));
        }
    }

    private ArrayList<Event> getEventsFromFile(IFilter filter, String path, LocaleId trgLoc) {
        return FilterTestDriver.getEvents((IFilter)filter, (RawDocument)new RawDocument(new File(path).toURI(), "UTF-8", this.locEN, trgLoc), null);
    }
}

