/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.linebreakconversion;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String LINEBREAK = "lineBreak";

    public String getLineBreak() {
        return this.getString(LINEBREAK);
    }

    public void setLineBreak(String lineBreak) {
        this.setString(LINEBREAK, lineBreak);
    }

    public void reset() {
        super.reset();
        this.setLineBreak(System.getProperty("line.separator"));
        if (this.getLineBreak() == null) {
            this.setLineBreak("\r\n");
        }
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(LINEBREAK, "Convert line-breaks to the following type", "Select the new type of line-break for the output.");
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Line-Break Conversion", true, false);
        String[] values = new String[]{"\r\n", "\n", "\r"};
        String[] labels = new String[]{"DOS/Windows (Carriage-Return + Line-Feed, \\r\\n, 0x0D+0x0A)", "Unix/Linux (Line-Feed, \\n, 0x0A)", "Macintosh (Carriage-Return, \\r, 0x0D)"};
        ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(LINEBREAK), values);
        lsp.setChoicesLabels(labels);
        lsp.setListType(0);
        return desc;
    }
}

