/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.linebreakconversion;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.linebreakconversion.Parameters;

@UsingParameters(value=Parameters.class)
public class LineBreakConversionStep
extends BasePipelineStep {
    private static final int BUFFER_SIZE = 1024;
    private Parameters params = new Parameters();
    private URI outputURI;

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    public String getDescription() {
        return "Convert the type of line-breaks in a text-based file. Expects: raw document. Sends back: raw document.";
    }

    public String getName() {
        return "Line-Break Conversion";
    }

    public IParameters getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    protected Event handleRawDocument(Event event) {
        BufferedReader reader = null;
        OutputStreamWriter writer = null;
        try {
            File outFile;
            RawDocument rawDoc = event.getRawDocument();
            BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(rawDoc.getStream(), rawDoc.getEncoding());
            detector.detectAndRemoveBom();
            rawDoc.setEncoding(detector.getEncoding());
            reader = new BufferedReader(new InputStreamReader(detector.getInputStream(), rawDoc.getEncoding()));
            if (this.isLastOutputStep()) {
                outFile = rawDoc.createOutputFile(this.outputURI);
            } else {
                try {
                    outFile = File.createTempFile("~okapi-48_okp-lbc_", ".tmp");
                }
                catch (Throwable e) {
                    throw new OkapiIOException("Cannot create temporary output.", e);
                }
            }
            FileOutputStream output = new FileOutputStream(outFile);
            writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(output), rawDoc.getEncoding());
            Util.writeBOMIfNeeded((Writer)writer, (boolean)detector.hasUtf8Bom(), (String)rawDoc.getEncoding());
            char[] buf = new char[1024];
            int length = 0;
            int done = 0;
            while ((length = reader.read(buf, 0, 1023)) > 0) {
                int count;
                if (buf[length - 1] == '\r' && (count = reader.read(buf, length, 1)) > -1) {
                    ++length;
                }
                done = done == 1 ? ++done : 0;
                int start = 0;
                for (int i = 0; i < length; ++i) {
                    if (buf[i] == '\n') {
                        if (i != 0 || done == 0) {
                            writer.write(buf, start, i - start);
                            writer.write(this.params.getLineBreak());
                        }
                        start = i + 1;
                        continue;
                    }
                    if (buf[i] != '\r') continue;
                    writer.write(buf, start, i - start);
                    writer.write(this.params.getLineBreak());
                    if (i + 1 < length && buf[i + 1] == '\n') {
                        ++i;
                    }
                    start = i + 1;
                    done = 1;
                }
                if (length - start <= 0) continue;
                writer.write(buf, start, length - start);
            }
            reader.close();
            reader = null;
            writer.close();
            writer = null;
            rawDoc.finalizeOutput();
            event.setResource((IResource)new RawDocument(outFile.toURI(), rawDoc.getEncoding(), rawDoc.getSourceLocale(), rawDoc.getTargetLocale()));
        }
        catch (IOException e) {
            throw new OkapiIOException("IO error while converting.", (Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new OkapiIOException("IO error while closing.", (Throwable)e);
            }
        }
        return event;
    }
}

