/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.leveraging;

import java.io.File;
import java.net.URI;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.FilterTestDriver;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filters.InputDocument;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.steps.common.FilterEventsToRawDocumentStep;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.leveraging.LeveragingStep;
import net.sf.okapi.steps.leveraging.Parameters;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.common.TranslationUnitVariant;
import net.sf.okapi.tm.pensieve.writer.ITmWriter;
import net.sf.okapi.tm.pensieve.writer.TmWriterFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.MethodSorters;

@RunWith(value=JUnit4.class)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LeveragingStepTest {
    private static FileLocation root;
    private static String tmDir;
    private static String tmDir2;
    private static LocaleId locEN;
    private static LocaleId locFR;
    private static final TextFragment TRG_1;
    private static final TextFragment TRG_2;

    @BeforeClass
    public static void setupClass() {
        root = FileLocation.fromClass(LeveragingStepTest.class);
        tmDir = Util.ensureSeparator((String)Util.getTempDirectory(), (boolean)true) + "levtestTM";
        tmDir2 = Util.ensureSeparator((String)Util.getTempDirectory(), (boolean)true) + "levtestTM2";
        LeveragingStepTest.createTM();
        LeveragingStepTest.createTM2();
    }

    @AfterClass
    public static void cleanupClass() {
        Util.deleteDirectory((String)tmDir, (boolean)false);
        Util.deleteDirectory((String)tmDir2, (boolean)false);
    }

    @Test
    public void testSimpleStep() {
        File outFile = root.out("test01.out.html").asFile();
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(HtmlFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        LeveragingStep levStep = new LeveragingStep();
        Parameters params = levStep.getParameters();
        net.sf.okapi.connectors.pensieve.Parameters tmParams = new net.sf.okapi.connectors.pensieve.Parameters();
        tmParams.fromString(params.getResourceParameters());
        tmParams.setDbDirectory(tmDir);
        params.setResourceParameters(tmParams.toString());
        params.setThreshold(90);
        params.setFillTargetThreshold(90);
        pdriver.addStep((IPipelineStep)levStep);
        pdriver.addStep((IPipelineStep)new FilterEventsToRawDocumentStep());
        URI inputURI = root.in("/test01.html").asUri();
        URI outputURI = outFile.toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_html", outputURI, "UTF-8", locEN, locFR));
        pdriver.processBatch();
        Assert.assertTrue((boolean)outFile.exists());
        InputDocument doc = new InputDocument(outFile.getPath(), null);
        ITextUnit tu = FilterTestDriver.getTextUnit((IFilter)new HtmlFilter(), (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)1);
        Assert.assertNotNull((Object)tu);
        Assert.assertEquals((Object)TRG_1.toText(), (Object)tu.getSource().getFirstContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)new HtmlFilter(), (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)2);
        Assert.assertNotNull((Object)tu);
        Assert.assertEquals((Object)TRG_2.toText(), (Object)tu.getSource().getFirstContent().toText());
    }

    private static void createTM() {
        Util.deleteDirectory((String)tmDir, (boolean)true);
        Util.createDirectories((String)(tmDir + "/"));
        ITmWriter tmWriter = TmWriterFactory.createFileBasedTmWriter((String)tmDir, (boolean)true);
        TranslationUnitVariant source = new TranslationUnitVariant(locEN, new TextFragment("This is an example of text"));
        TranslationUnitVariant target = new TranslationUnitVariant(locFR, TRG_1);
        TranslationUnit tu = new TranslationUnit(source, target);
        tmWriter.indexTranslationUnit(tu);
        source = new TranslationUnitVariant(locEN, new TextFragment("This is an example of TEXT"));
        target = new TranslationUnitVariant(locFR, TRG_2);
        tu = new TranslationUnit(source, target);
        tmWriter.indexTranslationUnit(tu);
        tmWriter.commit();
        tmWriter.close();
    }

    @Test
    public void testWithTranslations1() {
        File outFile = this.processWithTranslations(true, true);
        Assert.assertTrue((boolean)outFile.exists());
        InputDocument doc = new InputDocument(outFile.getPath(), null);
        XLIFFFilter filter = new XLIFFFilter();
        ITextUnit tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)1);
        Assert.assertEquals((Object)"TEXTE UN.", (Object)tu.getTarget(locFR).getFirstContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)2);
        Assert.assertEquals((Object)"Texte un bis.", (Object)tu.getTarget(locFR).getFirstContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)3);
        Assert.assertEquals((Object)"TEXTE UN TER.", (Object)tu.getTarget(locFR).getFirstContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)4);
        ISegments segs = tu.getTarget(locFR).getSegments();
        Assert.assertEquals((Object)"TEXTE DEUX. ", (Object)segs.get(0).getContent().toText());
        Assert.assertEquals((Object)"Texte trois.", (Object)segs.get(1).getContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)5);
        segs = tu.getTarget(locFR).getSegments();
        Assert.assertEquals((Object)"Texte quatre. ", (Object)segs.get(0).getContent().toText());
        Assert.assertEquals((Object)"TEXTE CINQ.", (Object)segs.get(1).getContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)6);
        segs = tu.getTarget(locFR).getSegments();
        Assert.assertEquals((Object)"TEXTE SIX. ", (Object)segs.get(0).getContent().toText());
        Assert.assertEquals((Object)"TEXTE SEPT.", (Object)segs.get(1).getContent().toText());
    }

    @Test
    public void testWithTranslations2() {
        File outFile = this.processWithTranslations(true, false);
        Assert.assertTrue((boolean)outFile.exists());
        InputDocument doc = new InputDocument(outFile.getPath(), null);
        XLIFFFilter filter = new XLIFFFilter();
        ITextUnit tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)1);
        Assert.assertEquals((Object)"Text one.", (Object)tu.getTarget(locFR).getFirstContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)2);
        Assert.assertEquals((Object)"Texte un bis.", (Object)tu.getTarget(locFR).getFirstContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)3);
        Assert.assertEquals((Object)"TEXTE UN TER.", (Object)tu.getTarget(locFR).getFirstContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)4);
        ISegments segs = tu.getTarget(locFR).getSegments();
        Assert.assertEquals((Object)"Text two. ", (Object)segs.get(0).getContent().toText());
        Assert.assertEquals((Object)"Texte trois.", (Object)segs.get(1).getContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)5);
        segs = tu.getTarget(locFR).getSegments();
        Assert.assertEquals((Object)"Texte quatre. ", (Object)segs.get(0).getContent().toText());
        Assert.assertEquals((Object)"Text five.", (Object)segs.get(1).getContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)6);
        segs = tu.getTarget(locFR).getSegments();
        Assert.assertEquals((Object)"TEXTE SIX. ", (Object)segs.get(0).getContent().toText());
        Assert.assertEquals((Object)"TEXTE SEPT.", (Object)segs.get(1).getContent().toText());
    }

    @Test
    public void testWithTranslations3() {
        File outFile = this.processWithTranslations(false, true);
        Assert.assertTrue((boolean)outFile.exists());
        InputDocument doc = new InputDocument(outFile.getPath(), null);
        XLIFFFilter filter = new XLIFFFilter();
        ITextUnit tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)1);
        Assert.assertEquals((Object)"TEXTE UN.", (Object)tu.getTarget(locFR).getFirstContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)2);
        Assert.assertEquals((Object)"TEXTE UN BIS.", (Object)tu.getTarget(locFR).getFirstContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)3);
        Assert.assertEquals((Object)"TEXTE UN TER.", (Object)tu.getTarget(locFR).getFirstContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)4);
        ISegments segs = tu.getTarget(locFR).getSegments();
        Assert.assertEquals((Object)"TEXTE DEUX. ", (Object)segs.get(0).getContent().toText());
        Assert.assertEquals((Object)"TEXTE TROIS.", (Object)segs.get(1).getContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)5);
        segs = tu.getTarget(locFR).getSegments();
        Assert.assertEquals((Object)"TEXTE QUATRE. ", (Object)segs.get(0).getContent().toText());
        Assert.assertEquals((Object)"TEXTE CINQ.", (Object)segs.get(1).getContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)6);
        segs = tu.getTarget(locFR).getSegments();
        Assert.assertEquals((Object)"TEXTE SIX. ", (Object)segs.get(0).getContent().toText());
        Assert.assertEquals((Object)"TEXTE SEPT.", (Object)segs.get(1).getContent().toText());
    }

    @Test
    public void testWithTranslations4() {
        File outFile = this.processWithTranslations(false, false);
        Assert.assertTrue((boolean)outFile.exists());
        InputDocument doc = new InputDocument(outFile.getPath(), null);
        XLIFFFilter filter = new XLIFFFilter();
        ITextUnit tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)1);
        Assert.assertEquals((Object)"TEXTE UN.", (Object)tu.getTarget(locFR).getFirstContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)2);
        Assert.assertEquals((Object)"TEXTE UN BIS.", (Object)tu.getTarget(locFR).getFirstContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)3);
        Assert.assertEquals((Object)"TEXTE UN TER.", (Object)tu.getTarget(locFR).getFirstContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)4);
        ISegments segs = tu.getTarget(locFR).getSegments();
        Assert.assertEquals((Object)"TEXTE DEUX. ", (Object)segs.get(0).getContent().toText());
        Assert.assertEquals((Object)"TEXTE TROIS.", (Object)segs.get(1).getContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)5);
        segs = tu.getTarget(locFR).getSegments();
        Assert.assertEquals((Object)"TEXTE QUATRE. ", (Object)segs.get(0).getContent().toText());
        Assert.assertEquals((Object)"TEXTE CINQ.", (Object)segs.get(1).getContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)filter, (InputDocument)doc, (String)"UTF-8", (LocaleId)locEN, (LocaleId)locFR, (int)6);
        segs = tu.getTarget(locFR).getSegments();
        Assert.assertEquals((Object)"TEXTE SIX. ", (Object)segs.get(0).getContent().toText());
        Assert.assertEquals((Object)"TEXTE SEPT.", (Object)segs.get(1).getContent().toText());
    }

    public File processWithTranslations(boolean onlyIfTargetIsEmpty, boolean onlyIfTargetIsSameAsSource) {
        File outFile = root.out("with-trans.out.xlf").asFile();
        if (outFile.exists()) {
            outFile.delete();
        }
        Assert.assertFalse((boolean)outFile.exists());
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XLIFFFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        LeveragingStep levStep = new LeveragingStep();
        Parameters params = levStep.getParameters();
        net.sf.okapi.connectors.pensieve.Parameters tmParams = new net.sf.okapi.connectors.pensieve.Parameters();
        tmParams.fromString(params.getResourceParameters());
        tmParams.setDbDirectory(tmDir2);
        params.setResourceParameters(tmParams.toString());
        params.setThreshold(90);
        params.setFillTargetThreshold(90);
        params.setFillIfTargetIsEmpty(onlyIfTargetIsEmpty);
        params.setFillIfTargetIsSameAsSource(onlyIfTargetIsSameAsSource);
        pdriver.addStep((IPipelineStep)levStep);
        pdriver.addStep((IPipelineStep)new FilterEventsToRawDocumentStep());
        URI inputURI = root.in("/with-trans.xlf").asUri();
        URI outputURI = outFile.toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_xliff", outputURI, "UTF-8", locEN, locFR));
        pdriver.processBatch();
        return outFile;
    }

    private static void createTM2() {
        Util.deleteDirectory((String)tmDir2, (boolean)true);
        Util.createDirectories((String)(tmDir2 + "/"));
        ITmWriter tmWriter = TmWriterFactory.createFileBasedTmWriter((String)tmDir2, (boolean)true);
        TranslationUnitVariant source = new TranslationUnitVariant(locEN, new TextFragment("Text one."));
        TranslationUnitVariant target = new TranslationUnitVariant(locFR, new TextFragment("TEXTE UN."));
        TranslationUnit tu = new TranslationUnit(source, target);
        tmWriter.indexTranslationUnit(tu);
        source = new TranslationUnitVariant(locEN, new TextFragment("Text one bis."));
        target = new TranslationUnitVariant(locFR, new TextFragment("TEXTE UN BIS."));
        tu = new TranslationUnit(source, target);
        tmWriter.indexTranslationUnit(tu);
        source = new TranslationUnitVariant(locEN, new TextFragment("Text one ter."));
        target = new TranslationUnitVariant(locFR, new TextFragment("TEXTE UN TER."));
        tu = new TranslationUnit(source, target);
        tmWriter.indexTranslationUnit(tu);
        source = new TranslationUnitVariant(locEN, new TextFragment("Text two. "));
        target = new TranslationUnitVariant(locFR, new TextFragment("TEXTE DEUX. "));
        tu = new TranslationUnit(source, target);
        tmWriter.indexTranslationUnit(tu);
        source = new TranslationUnitVariant(locEN, new TextFragment("Text three."));
        target = new TranslationUnitVariant(locFR, new TextFragment("TEXTE TROIS."));
        tu = new TranslationUnit(source, target);
        tmWriter.indexTranslationUnit(tu);
        source = new TranslationUnitVariant(locEN, new TextFragment("Text four. "));
        target = new TranslationUnitVariant(locFR, new TextFragment("TEXTE QUATRE. "));
        tu = new TranslationUnit(source, target);
        tmWriter.indexTranslationUnit(tu);
        source = new TranslationUnitVariant(locEN, new TextFragment("Text five."));
        target = new TranslationUnitVariant(locFR, new TextFragment("TEXTE CINQ."));
        tu = new TranslationUnit(source, target);
        tmWriter.indexTranslationUnit(tu);
        source = new TranslationUnitVariant(locEN, new TextFragment("Text six. "));
        target = new TranslationUnitVariant(locFR, new TextFragment("TEXTE SIX. "));
        tu = new TranslationUnit(source, target);
        tmWriter.indexTranslationUnit(tu);
        source = new TranslationUnitVariant(locEN, new TextFragment("Text seven."));
        target = new TranslationUnitVariant(locFR, new TextFragment("TEXTE SEPT."));
        tu = new TranslationUnit(source, target);
        tmWriter.indexTranslationUnit(tu);
        tmWriter.commit();
        tmWriter.close();
    }

    static {
        locEN = LocaleId.fromString((String)"en");
        locFR = LocaleId.fromString((String)"fr");
        TRG_1 = new TextFragment("FR This is an example of text");
        TRG_2 = new TextFragment("FR This is an example of TEXT");
    }
}

