/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.leveraging;

import java.io.File;
import java.net.URI;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.FilterTestDriver;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filters.InputDocument;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.steps.common.FilterEventsToRawDocumentStep;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.leveraging.LeveragingStep;
import net.sf.okapi.steps.leveraging.Parameters;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.common.TranslationUnitVariant;
import net.sf.okapi.tm.pensieve.writer.ITmWriter;
import net.sf.okapi.tm.pensieve.writer.TmWriterFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class LeveragingStepTest {
    private FileLocation root;
    private String tmDir;
    private LocaleId locEN = LocaleId.fromString((String)"en");
    private LocaleId locFR = LocaleId.fromString((String)"fr");
    private static final TextFragment TRG_1 = new TextFragment("FR This is an example of text");
    private static final TextFragment TRG_2 = new TextFragment("FR This is an example of TEXT");

    public LeveragingStepTest() {
        this.root = FileLocation.fromClass(this.getClass());
        this.tmDir = Util.ensureSeparator((String)Util.getTempDirectory(), (boolean)true) + "levtestTM";
    }

    @Test
    public void testSimpleStep() {
        File outFile = this.root.out("test01.out.html").asFile();
        this.createTM();
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(HtmlFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        LeveragingStep levStep = new LeveragingStep();
        Parameters params = (Parameters)levStep.getParameters();
        net.sf.okapi.connectors.pensieve.Parameters tmParams = new net.sf.okapi.connectors.pensieve.Parameters();
        tmParams.fromString(params.getResourceParameters());
        tmParams.setDbDirectory(this.tmDir);
        params.setResourceParameters(tmParams.toString());
        params.setThreshold(90);
        params.setFillTargetThreshold(90);
        pdriver.addStep((IPipelineStep)levStep);
        pdriver.addStep((IPipelineStep)new FilterEventsToRawDocumentStep());
        URI inputURI = this.root.in("/test01.html").asUri();
        URI outputURI = outFile.toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_html", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        Assert.assertTrue((boolean)outFile.exists());
        InputDocument doc = new InputDocument(outFile.getPath(), null);
        ITextUnit tu = FilterTestDriver.getTextUnit((IFilter)new HtmlFilter(), (InputDocument)doc, (String)"UTF-8", (LocaleId)this.locFR, (LocaleId)LocaleId.EMPTY, (int)1);
        Assert.assertNotNull((Object)tu);
        Assert.assertEquals((Object)TRG_1.toText(), (Object)tu.getSource().getFirstContent().toText());
        tu = FilterTestDriver.getTextUnit((IFilter)new HtmlFilter(), (InputDocument)doc, (String)"UTF-8", (LocaleId)this.locFR, (LocaleId)LocaleId.EMPTY, (int)2);
        Assert.assertNotNull((Object)tu);
        Assert.assertEquals((Object)TRG_2.toText(), (Object)tu.getSource().getFirstContent().toText());
    }

    private void createTM() {
        Util.deleteDirectory((String)this.tmDir, (boolean)true);
        Util.createDirectories((String)(this.tmDir + "/"));
        ITmWriter tmWriter = TmWriterFactory.createFileBasedTmWriter((String)this.tmDir, (boolean)true);
        TranslationUnitVariant source = new TranslationUnitVariant(this.locEN, new TextFragment("This is an example of text"));
        TranslationUnitVariant target = new TranslationUnitVariant(this.locEN, TRG_1);
        TranslationUnit tu = new TranslationUnit(source, target);
        tmWriter.indexTranslationUnit(tu);
        source = new TranslationUnitVariant(this.locEN, new TextFragment("This is an example of TEXT"));
        target = new TranslationUnitVariant(this.locEN, TRG_2);
        tu = new TranslationUnit(source, target);
        tmWriter.indexTranslationUnit(tu);
        tmWriter.commit();
    }
}

