/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.leveraging;

import java.io.File;
import java.net.URI;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.observer.IObserver;
import net.sf.okapi.common.pipeline.EventObserver;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.Pipeline;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.leveraging.BatchTmLeveragingStep;
import net.sf.okapi.steps.leveraging.Parameters;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.common.TranslationUnitVariant;
import net.sf.okapi.tm.pensieve.writer.ITmWriter;
import net.sf.okapi.tm.pensieve.writer.TmWriterFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BatchTmLeveragingStepTest {
    private FileLocation root;
    private String tmDir;
    private LocaleId locEN = LocaleId.fromString((String)"en");
    private LocaleId locFR = LocaleId.fromString((String)"fr");
    private static final TextFragment TRG_1 = new TextFragment("FR This is an example of text");
    private static final TextFragment TRG_2 = new TextFragment("FR This is an example of TEXT");

    public BatchTmLeveragingStepTest() {
        this.root = FileLocation.fromClass(this.getClass());
        this.tmDir = Util.ensureSeparator((String)Util.getTempDirectory(), (boolean)true) + "batchlevtestTM";
    }

    @Test
    public void testSimpleStep() {
        File outFile = this.root.out("/test01batch.out.html").asFile();
        this.createTM();
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(HtmlFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        BatchTmLeveragingStep levStep = new BatchTmLeveragingStep();
        Parameters params = (Parameters)levStep.getParameters();
        net.sf.okapi.connectors.pensieve.Parameters tmParams = new net.sf.okapi.connectors.pensieve.Parameters();
        tmParams.fromString(params.getResourceParameters());
        tmParams.setDbDirectory(this.tmDir);
        params.setResourceParameters(tmParams.toString());
        params.setThreshold(80);
        params.setFillTargetThreshold(80);
        pdriver.addStep((IPipelineStep)levStep);
        URI inputURI = this.root.in("/test01.html").asUri();
        URI outputURI = outFile.toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_html", outputURI, "UTF-8", this.locEN, this.locFR));
        Pipeline p = (Pipeline)pdriver.getPipeline();
        EventObserver o = new EventObserver();
        p.addObserver((IObserver)o);
        pdriver.processBatch();
        ITextUnit tu = ((Event)o.getResult().get(8)).getTextUnit();
        Assert.assertNotNull((Object)tu);
        AltTranslationsAnnotation a = (AltTranslationsAnnotation)tu.getTarget(this.locFR).getAnnotation(AltTranslationsAnnotation.class);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)TRG_1.toText(), (Object)a.getFirst().getTarget().toString());
        tu = ((Event)o.getResult().get(11)).getTextUnit();
        Assert.assertNotNull((Object)tu);
        a = (AltTranslationsAnnotation)tu.getTarget(this.locFR).getAnnotation(AltTranslationsAnnotation.class);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)TRG_2.toText(), (Object)a.getFirst().getTarget().toString());
    }

    private void createTM() {
        Util.deleteDirectory((String)this.tmDir, (boolean)true);
        Util.createDirectories((String)(this.tmDir + "/"));
        ITmWriter tmWriter = TmWriterFactory.createFileBasedTmWriter((String)this.tmDir, (boolean)true);
        TranslationUnitVariant source = new TranslationUnitVariant(this.locEN, new TextFragment("This is an example of text"));
        TranslationUnitVariant target = new TranslationUnitVariant(this.locEN, TRG_1);
        TranslationUnit tu = new TranslationUnit(source, target);
        tmWriter.indexTranslationUnit(tu);
        source = new TranslationUnitVariant(this.locEN, new TextFragment("This is an example of TEXT"));
        target = new TranslationUnitVariant(this.locEN, TRG_2);
        tu = new TranslationUnit(source, target);
        tmWriter.indexTranslationUnit(tu);
        tmWriter.commit();
    }
}

