/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.inconsistencycheck;

import java.io.File;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.AbstractPart;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;
import net.sf.okapi.common.uidescription.PathInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String CHECKINCONSISTENCIES = "checkInconststencies";
    private static final String CHECKPERFILE = "checkPerFile";
    private static final String OUTPUTPATH = "outputPath";
    private static final String DISPLAYOPTION = "displayOption";
    private static final String AUTOOPEN = "autoOpen";
    public static final String DISPLAYOPTION_ORIGINAL = "original";
    public static final String DISPLAYOPTION_GENERIC = "generic";
    public static final String DISPLAYOPTION_PLAIN = "plain";

    public boolean getCheckInconststencies() {
        return this.getBoolean(CHECKINCONSISTENCIES);
    }

    public void setCheckInconststencies(boolean checkInconststencies) {
        this.setBoolean(CHECKINCONSISTENCIES, checkInconststencies);
    }

    public boolean getCheckPerFile() {
        return this.getBoolean(CHECKPERFILE);
    }

    public void setCheckPerFile(boolean checkPerFile) {
        this.setBoolean(CHECKPERFILE, checkPerFile);
    }

    public String getOutputPath() {
        return this.getString(OUTPUTPATH);
    }

    public void setOutputPath(String outputPath) {
        this.setString(OUTPUTPATH, outputPath);
    }

    public String getDisplayOption() {
        return this.getString(DISPLAYOPTION);
    }

    public void setDisplayOption(String displayOption) {
        this.setString(DISPLAYOPTION, displayOption);
    }

    public boolean isAutoOpen() {
        return this.getBoolean(AUTOOPEN);
    }

    public void setAutoOpen(boolean autoOpen) {
        this.setBoolean(AUTOOPEN, autoOpen);
    }

    public void reset() {
        super.reset();
        this.setCheckInconststencies(true);
        this.setCheckPerFile(false);
        this.setOutputPath("${rootDir}" + File.separator + "inconsistency-report.xml");
        this.setDisplayOption(DISPLAYOPTION_GENERIC);
        this.setAutoOpen(true);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(CHECKINCONSISTENCIES, "Check inconsistencies", null);
        desc.add(CHECKPERFILE, "Check for inconsistencies on a file-by-file basis", null);
        desc.add(OUTPUTPATH, "Path of the report file:", null);
        desc.add(DISPLAYOPTION, "Representation of the inline codes in the report", null);
        desc.add(AUTOOPEN, "Open the report file after completion", null);
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Inconsistency Check", true, false);
        CheckboxPart master = desc.addCheckboxPart(paramDesc.get(CHECKINCONSISTENCIES));
        CheckboxPart cbp = desc.addCheckboxPart(paramDesc.get(CHECKPERFILE));
        cbp.setMasterPart((AbstractPart)master, true);
        PathInputPart pip = desc.addPathInputPart(paramDesc.get(OUTPUTPATH), "Inconsistency Report File", true);
        pip.setMasterPart((AbstractPart)master, true);
        cbp = desc.addCheckboxPart(paramDesc.get(AUTOOPEN));
        cbp.setMasterPart((AbstractPart)master, true);
        String[] values = new String[]{DISPLAYOPTION_ORIGINAL, DISPLAYOPTION_GENERIC, DISPLAYOPTION_PLAIN};
        String[] labels = new String[]{"Original codes", "Generic markers", "Plain text"};
        ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(DISPLAYOPTION), values);
        lsp.setChoicesLabels(labels);
        lsp.setListType(1);
        lsp.setMasterPart((AbstractPart)master, true);
        return desc;
    }
}

