/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.inconsistencycheck;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.FileCompare;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.inconsistencycheck.InconsistencyCheckStep;
import net.sf.okapi.steps.inconsistencycheck.Parameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class EventTest {
    private FileLocation root;
    private LocaleId locEN = new LocaleId("en", "us");
    private LocaleId locFR = new LocaleId("fr", "fr");
    private InconsistencyCheckStep step;

    @Before
    public void setUp() {
        this.root = FileLocation.fromClass(this.getClass());
        this.step = new InconsistencyCheckStep();
        Parameters params = (Parameters)this.step.getParameters();
        params.setAutoOpen(false);
    }

    @Test
    public void SameSourceTest() throws IOException {
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XLIFFFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)this.step);
        URI inputURI = this.root.in("/SameSource.html.xlf").asUri();
        URI outputURI = new File("/SameSource.html.out.xlf").toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_xliff", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        this.maskDocIdPath("/inconsistency-report.xml");
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(this.root.out("/inconsistency-report.xml").toString(), this.root.in("/Gold_SameSource.xml").toString(), "UTF-8"));
    }

    @Test
    public void SameTargetTest() throws IOException {
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XLIFFFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)this.step);
        URI inputURI = this.root.in("/SameTarget.html.xlf").asUri();
        URI outputURI = new File("/SameTarget.html.out.xlf").toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_xliff", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        this.maskDocIdPath("/inconsistency-report.xml");
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(this.root.out("/inconsistency-report.xml").toString(), this.root.in("/Gold_SameTarget.xml").toString(), "UTF-8"));
    }

    @Test
    public void SameSourceAndTargetTest() throws IOException {
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XLIFFFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)this.step);
        URI inputURI = this.root.in("/SameSourceAndTarget.html.xlf").asUri();
        URI outputURI = new File("/SameSourceAndTarget.html.out.xlf").toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_xliff", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        this.maskDocIdPath("/inconsistency-report.xml");
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(this.root.out("/inconsistency-report.xml").toString(), this.root.in("/Gold_SameSourceAndTarget.xml").toString(), "UTF-8"));
    }

    @Test
    public void SimpleSubDocTest() throws IOException {
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XLIFFFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)this.step);
        URI inputURI = this.root.in("/SimpleSubDocTest.html.xlf").asUri();
        URI outputURI = new File("/SimpleSubDocTest.html.out.xlf").toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_xliff", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        this.maskDocIdPath("/inconsistency-report.xml");
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(this.root.out("/inconsistency-report.xml").toString(), this.root.in("/Gold_SimpleSubDocTest.xml").toString(), "UTF-8"));
    }

    @Test
    public void SameSourceWithCodeTest() throws IOException {
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XLIFFFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)this.step);
        URI inputURI = this.root.in("/SameSourceWithCode.html.xlf").asUri();
        URI outputURI = new File("/SameSourceWithCode.html.out.xlf").toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_xliff", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        this.maskDocIdPath("/inconsistency-report.xml");
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(this.root.out("/inconsistency-report.xml").toString(), this.root.in("/Gold_SameSourceWithCode.xml").toString(), "UTF-8"));
    }

    @Test
    public void OriginalOutputWithCodeTest() throws IOException {
        Parameters params = (Parameters)this.step.getParameters();
        params.setDisplayOption("original");
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XLIFFFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)this.step);
        URI inputURI = this.root.in("/SameSourceWithCode.html.xlf").asUri();
        URI outputURI = new File("/SameSourceWithCode.html.out.xlf").toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_xliff", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        this.maskDocIdPath("/inconsistency-report.xml");
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(this.root.out("/inconsistency-report.xml").toString(), this.root.in("/Gold_OriginalOutputWithCode.xml").toString(), "UTF-8"));
    }

    @Test
    public void PlainOutputWithCodeTest() throws IOException {
        Parameters params = (Parameters)this.step.getParameters();
        params.setDisplayOption("plain");
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XLIFFFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)this.step);
        URI inputURI = this.root.in("/SameSourceWithCode.html.xlf").asUri();
        URI outputURI = new File("/SameSourceWithCode.html.out.xlf").toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_xliff", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        this.maskDocIdPath("/inconsistency-report.xml");
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(this.root.out("/inconsistency-report.xml").toString(), this.root.in("/Gold_PlainOutputWithCode.xml").toString(), "UTF-8"));
    }

    @Test
    public void PerFileWithCodeTest() throws IOException {
        Parameters params = (Parameters)this.step.getParameters();
        params.setDisplayOption("generic");
        params.setCheckPerFile(true);
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XLIFFFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)this.step);
        URI inputURI1 = this.root.in("/SameSourceWithCode.html.xlf").asUri();
        URI outputURI1 = new File("/SameSourceWithCode.html.out.xlf").toURI();
        URI inputURI2 = this.root.in("/SameTargetWithCode.html.xlf").asUri();
        URI outputURI2 = new File("/SameTargetWithCode.html.out.xlf").toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI1, "UTF-8", "okf_xliff", outputURI1, "UTF-8", this.locEN, this.locFR));
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI2, "UTF-8", "okf_xliff", outputURI2, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        this.maskDocIdPath("/inconsistency-report.xml");
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(this.root.out("/inconsistency-report.xml").toString(), this.root.in("/Gold_PerFileWithCode.xml").toString(), "UTF-8"));
    }

    private void maskDocIdPath(String path) throws IOException {
        String str = StreamUtil.streamUtf8AsString((InputStream)this.root.in(path).asInputStream());
        Pattern pattern = Pattern.compile("doc=\"(.*)\"");
        Matcher matcher = pattern.matcher(str);
        StringBuffer buffer = new StringBuffer(str.length());
        while (matcher.find()) {
            String filename = Util.getFilename((String)matcher.group(1), (boolean)true);
            matcher.appendReplacement(buffer, "doc=\"ROOT/" + filename + "\"");
        }
        matcher.appendTail(buffer);
        try (OutputStreamWriter out = new OutputStreamWriter(this.root.out(path).asOutputStream(), "UTF-8");){
            out.write(buffer.toString());
        }
    }
}

