/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.inconsistencycheck;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.FileCompare;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.TestUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.inconsistencycheck.InconsistencyCheckStep;
import net.sf.okapi.steps.inconsistencycheck.Parameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class EventTest {
    private String root;
    private LocaleId locEN = new LocaleId("en", "us");
    private LocaleId locFR = new LocaleId("fr", "fr");
    private InconsistencyCheckStep step;

    @Before
    public void setUp() throws URISyntaxException {
        this.root = TestUtil.getParentDir(this.getClass(), (String)"/SameSource.html.xlf");
        this.step = new InconsistencyCheckStep();
        Parameters params = (Parameters)this.step.getParameters();
        params.setAutoOpen(false);
    }

    @Test
    public void SameSourceTest() throws URISyntaxException, IOException {
        URI inputURI;
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XLIFFFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        pdriver.setRootDirectories(Util.deleteLastChar((String)this.root), Util.deleteLastChar((String)this.root));
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)this.step);
        String inputPath = this.root + "SameSource.html.xlf";
        URI outputURI = inputURI = new File(inputPath).toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_xliff", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        this.maskDocIdPath(this.root + "inconsistency-report.xml");
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(this.root + "inconsistency-report.xml", this.root + "Gold_SameSource.xml", "UTF-8"));
    }

    @Test
    public void SameTargetTest() throws URISyntaxException, IOException {
        URI inputURI;
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XLIFFFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        pdriver.setRootDirectories(Util.deleteLastChar((String)this.root), Util.deleteLastChar((String)this.root));
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)this.step);
        String inputPath = this.root + "SameTarget.html.xlf";
        URI outputURI = inputURI = new File(inputPath).toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_xliff", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        this.maskDocIdPath(this.root + "inconsistency-report.xml");
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(this.root + "inconsistency-report.xml", this.root + "Gold_SameTarget.xml", "UTF-8"));
    }

    @Test
    public void SameSourceAndTargetTest() throws URISyntaxException, IOException {
        URI inputURI;
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XLIFFFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        pdriver.setRootDirectories(Util.deleteLastChar((String)this.root), Util.deleteLastChar((String)this.root));
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)this.step);
        String inputPath = this.root + "SameSourceAndTarget.html.xlf";
        URI outputURI = inputURI = new File(inputPath).toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_xliff", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        this.maskDocIdPath(this.root + "inconsistency-report.xml");
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(this.root + "inconsistency-report.xml", this.root + "Gold_SameSourceAndTarget.xml", "UTF-8"));
    }

    @Test
    public void SimpleSubDocTest() throws URISyntaxException, IOException {
        URI inputURI;
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XLIFFFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        pdriver.setRootDirectories(Util.deleteLastChar((String)this.root), Util.deleteLastChar((String)this.root));
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)this.step);
        String inputPath = this.root + "SimpleSubDocTest.html.xlf";
        URI outputURI = inputURI = new File(inputPath).toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_xliff", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        this.maskDocIdPath(this.root + "inconsistency-report.xml");
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(this.root + "inconsistency-report.xml", this.root + "Gold_SimpleSubDocTest.xml", "UTF-8"));
    }

    @Test
    public void SameSourceWithCodeTest() throws URISyntaxException, IOException {
        URI inputURI;
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XLIFFFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        pdriver.setRootDirectories(Util.deleteLastChar((String)this.root), Util.deleteLastChar((String)this.root));
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)this.step);
        String inputPath = this.root + "SameSourceWithCode.html.xlf";
        URI outputURI = inputURI = new File(inputPath).toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_xliff", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        this.maskDocIdPath(this.root + "inconsistency-report.xml");
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(this.root + "inconsistency-report.xml", this.root + "Gold_SameSourceWithCode.xml", "UTF-8"));
    }

    @Test
    public void OriginalOutputWithCodeTest() throws URISyntaxException, IOException {
        URI inputURI;
        Parameters params = (Parameters)this.step.getParameters();
        params.setDisplayOption("original");
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XLIFFFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        pdriver.setRootDirectories(Util.deleteLastChar((String)this.root), Util.deleteLastChar((String)this.root));
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)this.step);
        String inputPath = this.root + "SameSourceWithCode.html.xlf";
        URI outputURI = inputURI = new File(inputPath).toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_xliff", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        this.maskDocIdPath(this.root + "inconsistency-report.xml");
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(this.root + "inconsistency-report.xml", this.root + "Gold_OriginalOutputWithCode.xml", "UTF-8"));
    }

    @Test
    public void PlainOutputWithCodeTest() throws URISyntaxException, IOException {
        URI inputURI;
        Parameters params = (Parameters)this.step.getParameters();
        params.setDisplayOption("plain");
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XLIFFFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        pdriver.setRootDirectories(Util.deleteLastChar((String)this.root), Util.deleteLastChar((String)this.root));
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)this.step);
        String inputPath = this.root + "SameSourceWithCode.html.xlf";
        URI outputURI = inputURI = new File(inputPath).toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI, "UTF-8", "okf_xliff", outputURI, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        this.maskDocIdPath(this.root + "inconsistency-report.xml");
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(this.root + "inconsistency-report.xml", this.root + "Gold_PlainOutputWithCode.xml", "UTF-8"));
    }

    @Test
    public void PerFileWithCodeTest() throws URISyntaxException, IOException {
        URI inputURI2;
        URI inputURI1;
        Parameters params = (Parameters)this.step.getParameters();
        params.setDisplayOption("generic");
        params.setCheckPerFile(true);
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(XLIFFFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        pdriver.setRootDirectories(Util.deleteLastChar((String)this.root), Util.deleteLastChar((String)this.root));
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)this.step);
        String inputPath = this.root + "SameSourceWithCode.html.xlf";
        URI outputURI1 = inputURI1 = new File(inputPath).toURI();
        inputPath = this.root + "SameTargetWithCode.html.xlf";
        URI outputURI2 = inputURI2 = new File(inputPath).toURI();
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI1, "UTF-8", "okf_xliff", outputURI1, "UTF-8", this.locEN, this.locFR));
        pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(inputURI2, "UTF-8", "okf_xliff", outputURI2, "UTF-8", this.locEN, this.locFR));
        pdriver.processBatch();
        this.maskDocIdPath(this.root + "inconsistency-report.xml");
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(this.root + "inconsistency-report.xml", this.root + "Gold_PerFileWithCode.xml", "UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maskDocIdPath(String path) throws IOException {
        BufferedReader br = null;
        Writer out = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            StringBuilder buf = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                buf.append(line + "\n");
                line = br.readLine();
            }
            br.close();
            br = null;
            Pattern pattern = Pattern.compile("doc=\"(.*)\"");
            Matcher m = pattern.matcher(buf.toString());
            int diff = 0;
            int start = 0;
            while (m.find(start)) {
                String filename = Util.getFilename((String)m.group(1), (boolean)true);
                buf.replace(m.start() - diff, m.end() - diff, "doc=\"ROOT/" + filename + "\"");
                diff += m.group(1).length() - (filename.length() + 5);
                start = m.start() + 5;
            }
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8");
            out.write(buf.toString());
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

