/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.imagemodification;

import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;
import net.sf.okapi.common.uidescription.SpinInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String SCALEWIDTH = "scaleWidth";
    private static final String SCALEHEIGHT = "scaleHeight";
    private static final String FORMAT = "format";
    private static final String MAKEGRAY = "makeGray";

    public int getScaleWidth() {
        return this.getInteger(SCALEWIDTH);
    }

    public void setScaleWidth(int scaleWidth) {
        this.setInteger(SCALEWIDTH, scaleWidth);
    }

    public int getScaleHeight() {
        return this.getInteger(SCALEHEIGHT);
    }

    public void setScaleHeight(int scaleHeight) {
        this.setInteger(SCALEHEIGHT, scaleHeight);
    }

    public String getFormat() {
        return this.getString(FORMAT);
    }

    public void setFormat(String format) {
        this.setString(FORMAT, format);
    }

    public boolean getMakeGray() {
        return this.getBoolean(MAKEGRAY);
    }

    public void setMakeGray(boolean makeGray) {
        this.setBoolean(MAKEGRAY, makeGray);
    }

    public void reset() {
        super.reset();
        this.setScaleHeight(50);
        this.setScaleWidth(50);
        this.setFormat("");
        this.setMakeGray(false);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(SCALEHEIGHT, "Percentage of the original height", "Height percentage (must be greater than 0.");
        desc.add(SCALEWIDTH, "Percentage of the original width", "Width percentage (must be greater than 0.");
        desc.add(MAKEGRAY, "Convert to gray scale", null);
        desc.add(FORMAT, "Output format", "Format of the output files.");
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Image Modification", false, false);
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get(SCALEWIDTH));
        sip.setRange(1, 1000);
        sip = desc.addSpinInputPart(paramsDesc.get(SCALEHEIGHT));
        sip.setRange(1, 1000);
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(MAKEGRAY));
        cbp.setVertical(true);
        ArrayList<String> available = new ArrayList<String>(Arrays.asList(ImageIO.getWriterFileSuffixes()));
        ArrayList<String> suffixes = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        names.add("<Same format as the original>");
        suffixes.add("");
        if (available.contains("png")) {
            names.add("PNG (Portable Network Graphics)");
            suffixes.add("png");
        }
        if (available.contains("jpg")) {
            names.add("JPEG (Joint Photographic Experts Group)");
            suffixes.add("jpg");
        }
        if (available.contains("bmp")) {
            names.add("BMP Bitmap");
            suffixes.add("bmp");
        }
        if (available.contains("gif")) {
            names.add("GIF (Graphics Interchange Format)");
            suffixes.add("gif");
        }
        ListSelectionPart lsp = desc.addListSelectionPart(paramsDesc.get(FORMAT), suffixes.toArray(new String[0]));
        lsp.setChoicesLabels(names.toArray(new String[0]));
        lsp.setVertical(true);
        lsp.setLabelFlushed(false);
        return desc;
    }
}

