/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.idaligner;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.AbstractPart;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.PathInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String GENERATETMX = "generateTMX";
    private static final String TMXOUTPUTPATH = "tmxOutputPath";
    private static final String REPLACEWITHSOURCE = "replaceWithSource";
    private static final String COPYTOTARGET = "copyToTarget";
    private static final String STOREASALTTRANSLATION = "storeAsAltTranslation";
    private static final String SUPPRESSTUSWITHNOTARGET = "suppressTusWithNoTarget";
    private static final String USETEXTUNITIDS = "useTextUnitIds";

    public boolean getGenerateTMX() {
        return this.getBoolean(GENERATETMX);
    }

    public void setGenerateTMX(boolean generateTMX) {
        this.setBoolean(GENERATETMX, generateTMX);
    }

    public String getTmxOutputPath() {
        return this.getString(TMXOUTPUTPATH);
    }

    public void setTmxOutputPath(String tmxOutputPath) {
        this.setString(TMXOUTPUTPATH, tmxOutputPath);
    }

    public boolean getReplaceWithSource() {
        return this.getBoolean(REPLACEWITHSOURCE);
    }

    public void setReplaceWithSource(boolean replaceWithSource) {
        this.setBoolean(REPLACEWITHSOURCE, replaceWithSource);
    }

    public void setCopyToTarget(boolean copyToTarget) {
        this.setBoolean(COPYTOTARGET, copyToTarget);
    }

    public boolean isCopyToTarget() {
        return this.getBoolean(COPYTOTARGET);
    }

    public boolean isStoreAsAltTranslation() {
        return this.getBoolean(STOREASALTTRANSLATION);
    }

    public void setStoreAsAltTranslation(boolean storeAsAltTranslation) {
        this.setBoolean(STOREASALTTRANSLATION, storeAsAltTranslation);
    }

    public boolean isSuppressTusWithNoTarget() {
        return this.getBoolean(SUPPRESSTUSWITHNOTARGET);
    }

    public void setSuppressTusWithNoTarget(boolean suppressTusWithNoTarget) {
        this.setBoolean(SUPPRESSTUSWITHNOTARGET, suppressTusWithNoTarget);
    }

    public boolean isUseTextUnitIds() {
        return this.getBoolean(USETEXTUNITIDS);
    }

    public void setUseTextUnitIds(boolean useTextUnitIds) {
        this.setBoolean(USETEXTUNITIDS, useTextUnitIds);
    }

    public void reset() {
        super.reset();
        this.setTmxOutputPath("aligned.tmx");
        this.setGenerateTMX(false);
        this.setReplaceWithSource(false);
        this.setCopyToTarget(false);
        this.setStoreAsAltTranslation(true);
        this.setSuppressTusWithNoTarget(false);
        this.setUseTextUnitIds(false);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(GENERATETMX, "Generate a TMX file:", "If generateTMX is false generate bilingual TextUnits, otherwise (true) output a TMX file");
        desc.add(TMXOUTPUTPATH, "TMX output path", "Full path of the output TMX file");
        desc.add(REPLACEWITHSOURCE, "Fall back to source text", "If no target text is available, use the source text");
        desc.add(COPYTOTARGET, "Copy to/over the target (WARNING: Copied target will not be segmented)", "Copy to/over the target (an annotation will still be created if requested). WARNING: Copied target will not be segmented and any exisiting target will be lost.");
        desc.add(STOREASALTTRANSLATION, "Create an alternate translation annotation", "Store the matched target as an alternate translation so that subsequent steps can see it.");
        desc.add(SUPPRESSTUSWITHNOTARGET, "Suppress TUs with no target", "Do not pass on any TUs for which no targets could be found.");
        desc.add(USETEXTUNITIDS, "Align based on TextUnit IDs", "Align based on TextUnit IDs, rather than resource names.");
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Id-based Aligner", true, false);
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(GENERATETMX));
        PathInputPart pip = desc.addPathInputPart(paramsDesc.get(TMXOUTPUTPATH), "TMX Document to Generate", true);
        pip.setBrowseFilters("TMX Documents (*.tmx)\tAll Files (*.*)", "*.tmx\t*.*");
        pip.setWithLabel(false);
        pip.setMasterPart((AbstractPart)cbp, true);
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(REPLACEWITHSOURCE));
        desc.addCheckboxPart(paramsDesc.get(COPYTOTARGET));
        desc.addCheckboxPart(paramsDesc.get(STOREASALTTRANSLATION));
        desc.addCheckboxPart(paramsDesc.get(SUPPRESSTUSWITHNOTARGET));
        desc.addCheckboxPart(paramsDesc.get(USETEXTUNITIDS));
        return desc;
    }
}

