/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.idbasedcopy;

import java.net.URI;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.po.POFilter;
import net.sf.okapi.filters.properties.PropertiesFilter;
import net.sf.okapi.steps.common.FilterEventsToRawDocumentStep;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.idbasedcopy.IdBasedCopyStep;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IdBasedCopyStepTest {
    private FileLocation root;
    private LocaleId locEN = LocaleId.fromString((String)"en");
    private LocaleId locFR = LocaleId.fromString((String)"fr");

    @Before
    public void setUp() {
        this.root = FileLocation.fromClass(this.getClass());
    }

    @Test
    public void stub() {
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testCopy() {
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(PropertiesFilter.class.getName());
        fcMapper.addConfigurations(POFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        String rootDir = this.root.in("/").toString();
        pdriver.setRootDirectories(rootDir, rootDir);
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)new IdBasedCopyStep());
        pdriver.addStep((IPipelineStep)new FilterEventsToRawDocumentStep());
        URI input1URI = this.root.in("/destination1.properties").asUri();
        URI input2URI = this.root.in("/reference1.properties").asUri();
        String propOutputPath = "/destination1.out.properties";
        URI output1URI = this.root.out(propOutputPath).asUri();
        BatchItemContext bic1 = new BatchItemContext(input1URI, "UTF-8", "okf_properties", output1URI, "UTF-8", this.locEN, this.locFR);
        RawDocument rd2 = new RawDocument(input2URI, "UTF-8", this.locFR);
        rd2.setFilterConfigId("okf_properties");
        bic1.add(rd2, null, null);
        pdriver.addBatchItem((IBatchItemContext)bic1);
        input1URI = this.root.in("/destination1.po").asUri();
        input2URI = this.root.in("/reference1.po").asUri();
        String poOutputPath = "/destination1.out.po";
        output1URI = this.root.out(poOutputPath).asUri();
        bic1 = new BatchItemContext(input1URI, "UTF-8", "okf_po", output1URI, "UTF-8", this.locEN, this.locFR);
        rd2 = new RawDocument(input2URI, "UTF-8", this.locEN, this.locFR);
        rd2.setFilterConfigId("okf_po");
        bic1.add(rd2, null, null);
        pdriver.addBatchItem((IBatchItemContext)bic1);
        this.root.out(propOutputPath).asFile().delete();
        this.root.out(poOutputPath).asFile().delete();
        pdriver.processBatch();
        Assert.assertTrue((boolean)this.root.out(propOutputPath).asFile().exists());
        Assert.assertTrue((boolean)this.root.out(poOutputPath).asFile().exists());
    }
}

