/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.idbasedcopy;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.TestUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.po.POFilter;
import net.sf.okapi.filters.properties.PropertiesFilter;
import net.sf.okapi.steps.common.FilterEventsToRawDocumentStep;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.idbasedcopy.IdBasedCopyStep;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IdBasedCopyStepTest {
    private String root;
    private LocaleId locEN = LocaleId.fromString((String)"en");
    private LocaleId locFR = LocaleId.fromString((String)"fr");

    @Before
    public void setUp() {
        this.root = TestUtil.getParentDir(this.getClass(), (String)"/destination1.properties");
    }

    @Test
    public void stub() {
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testCopy() throws URISyntaxException {
        PipelineDriver pdriver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(PropertiesFilter.class.getName());
        fcMapper.addConfigurations(POFilter.class.getName());
        pdriver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        pdriver.setRootDirectories(Util.deleteLastChar((String)this.root), Util.deleteLastChar((String)this.root));
        pdriver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        pdriver.addStep((IPipelineStep)new IdBasedCopyStep());
        pdriver.addStep((IPipelineStep)new FilterEventsToRawDocumentStep());
        String input1Path = this.root + "destination1.properties";
        String input2Path = this.root + "reference1.properties";
        String propOutputPath = input1Path.replace("1.", "1.out.");
        URI input1URI = new File(input1Path).toURI();
        URI input2URI = new File(input2Path).toURI();
        URI output1URI = new File(propOutputPath).toURI();
        BatchItemContext bic1 = new BatchItemContext(input1URI, "UTF-8", "okf_properties", output1URI, "UTF-8", this.locEN, this.locFR);
        RawDocument rd2 = new RawDocument(input2URI, "UTF-8", this.locFR);
        rd2.setFilterConfigId("okf_properties");
        bic1.add(rd2, null, null);
        pdriver.addBatchItem((IBatchItemContext)bic1);
        input1Path = this.root + "destination1.po";
        input2Path = this.root + "reference1.po";
        String poOutputPath = input1Path.replace("1.", "1.out.");
        input1URI = new File(input1Path).toURI();
        input2URI = new File(input2Path).toURI();
        output1URI = new File(poOutputPath).toURI();
        bic1 = new BatchItemContext(input1URI, "UTF-8", "okf_po", output1URI, "UTF-8", this.locEN, this.locFR);
        rd2 = new RawDocument(input2URI, "UTF-8", this.locEN, this.locFR);
        rd2.setFilterConfigId("okf_po");
        bic1.add(rd2, null, null);
        pdriver.addBatchItem((IBatchItemContext)bic1);
        File file = new File(propOutputPath);
        file.delete();
        file = new File(poOutputPath);
        file.delete();
        pdriver.processBatch();
        file = new File(propOutputPath);
        Assert.assertTrue((boolean)file.exists());
        file = new File(poOutputPath);
        Assert.assertTrue((boolean)file.exists());
    }
}

