/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.idaligner;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.observer.IObserver;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.Pipeline;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.idaligner.EventObserver;
import net.sf.okapi.steps.idaligner.IdBasedAlignerStep;
import net.sf.okapi.steps.idaligner.Parameters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IdAlignerTest {
    private Pipeline pipeline;
    private IdBasedAlignerStep aligner;
    private EventObserver eventObserver;
    private RawDocumentToFilterEventsStep rawDocumentToFilterStep;

    @Before
    public void setUp() throws Exception {
        this.pipeline = new Pipeline();
        this.rawDocumentToFilterStep = new RawDocumentToFilterEventsStep();
        this.pipeline.addStep((IPipelineStep)this.rawDocumentToFilterStep);
        this.aligner = new IdBasedAlignerStep();
        Parameters p = new Parameters();
        p.setGenerateTMX(false);
        p.setCopyToTarget(true);
        this.aligner.setParameters((IParameters)p);
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations("net.sf.okapi.filters.properties.PropertiesFilter");
        fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
        this.rawDocumentToFilterStep.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        this.aligner.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        this.pipeline.addStep((IPipelineStep)this.aligner);
    }

    @After
    public void tearDown() throws Exception {
        this.pipeline.destroy();
    }

    @Test
    public void testEnglishEnglishAlignWithTuIds() throws URISyntaxException {
        this.aligner.getParameters().setUseTextUnitIds(true);
        this.englishEnglishAlign();
    }

    @Test
    public void IdEnglishEnglishAlign() throws URISyntaxException {
        this.englishEnglishAlign();
    }

    private void englishEnglishAlign() throws URISyntaxException {
        URI uri = IdAlignerTest.class.getResource("/messages_en-brief.properties").toURI();
        RawDocument t = new RawDocument(uri, "UTF-8", LocaleId.ENGLISH);
        t.setFilterConfigId("okf_properties");
        this.aligner.setSecondInput(t);
        this.aligner.setSourceLocale(LocaleId.ENGLISH);
        this.aligner.setTargetLocale(LocaleId.ENGLISH);
        this.rawDocumentToFilterStep.setFilterConfigurationId("okf_properties");
        this.eventObserver = new EventObserver();
        this.pipeline.deleteObservers();
        this.pipeline.addObserver((IObserver)this.eventObserver);
        this.pipeline.startBatch();
        this.pipeline.process(new RawDocument(uri, "UTF-8", LocaleId.ENGLISH));
        this.pipeline.endBatch();
        List<Event> el = this.eventObserver.getResult();
        Assert.assertEquals((Object)EventType.START_BATCH, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.START_BATCH_ITEM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.PIPELINE_PARAMETERS, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.START_DOCUMENT, (Object)el.remove(0).getEventType());
        Event tue = el.remove(0);
        Assert.assertEquals((Object)"Cancel", (Object)tue.getResource().toString());
        Assert.assertEquals((Object)"key.Cancel", (Object)tue.getTextUnit().getName());
        tue = el.remove(0);
        Assert.assertNotNull((Object)tue.getTextUnit().getTarget(LocaleId.ENGLISH).getAnnotation(AltTranslationsAnnotation.class));
        Assert.assertEquals((Object)"Unable to communicate with the <b>server</b>.", (Object)this.getAltTransTarget(tue.getTextUnit(), LocaleId.ENGLISH));
        Assert.assertEquals((Object)"Unable to communicate with the <b>server</b>.", (Object)tue.getResource().toString());
        Assert.assertEquals((Object)"key.server", (Object)tue.getTextUnit().getName());
        Assert.assertEquals((Object)EventType.END_DOCUMENT, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH_ITEM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH, (Object)el.remove(0).getEventType());
    }

    @Test
    public void IdEnglishEnglishHtmlAlign() throws URISyntaxException {
        URL url = IdAlignerTest.class.getResource("/messages_html_en-brief.properties");
        RawDocument t = new RawDocument(url.toURI(), "UTF-8", LocaleId.ENGLISH);
        t.setFilterConfigId("okf_properties-html-subfilter");
        this.aligner.setSecondInput(t);
        this.aligner.setSourceLocale(LocaleId.ENGLISH);
        this.aligner.setTargetLocale(LocaleId.ENGLISH);
        this.eventObserver = new EventObserver();
        this.pipeline.deleteObservers();
        this.pipeline.addObserver((IObserver)this.eventObserver);
        this.pipeline.startBatch();
        RawDocument s = new RawDocument(this.getClass().getResourceAsStream("/messages_html_en-brief.properties"), "UTF-8", LocaleId.ENGLISH);
        this.rawDocumentToFilterStep.setFilterConfigurationId("okf_properties-html-subfilter");
        s.setFilterConfigId("okf_properties-html-subfilter");
        this.pipeline.process(s);
        this.pipeline.endBatch();
        List<Event> el = this.eventObserver.getResult();
        Assert.assertEquals((Object)EventType.START_BATCH, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.START_BATCH_ITEM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.PIPELINE_PARAMETERS, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.START_DOCUMENT, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.START_SUBFILTER, (Object)el.remove(0).getEventType());
        Event tue = el.remove(0);
        Assert.assertEquals((Object)"<b>Cancel</b>", (Object)tue.getResource().toString());
        Assert.assertEquals((Object)"key.Cancel_1", (Object)tue.getTextUnit().getName());
        Assert.assertEquals((Object)EventType.END_SUBFILTER, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.DOCUMENT_PART, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.START_SUBFILTER, (Object)el.remove(0).getEventType());
        tue = el.remove(0);
        Assert.assertEquals((Object)"Unable to communicate", (Object)tue.getResource().toString());
        Assert.assertEquals((Object)"key.server_1", (Object)tue.getTextUnit().getName());
        Assert.assertEquals((Object)EventType.DOCUMENT_PART, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.DOCUMENT_PART, (Object)el.remove(0).getEventType());
        tue = el.remove(0);
        Assert.assertEquals((Object)"server", (Object)tue.getResource().toString());
        Assert.assertEquals((Object)"key.server_4", (Object)tue.getTextUnit().getName());
    }

    @Test
    public void IdSourceTargetAlign() throws URISyntaxException {
        URL url = IdAlignerTest.class.getResource("/messages_de-brief.properties");
        RawDocument t = new RawDocument(url.toURI(), "ASCII", LocaleId.ENGLISH);
        t.setFilterConfigId("okf_properties");
        this.aligner.setSecondInput(t);
        this.aligner.setSourceLocale(LocaleId.ENGLISH);
        this.aligner.setTargetLocale(LocaleId.GERMAN);
        this.rawDocumentToFilterStep.setFilterConfigurationId("okf_properties");
        this.eventObserver = new EventObserver();
        this.pipeline.deleteObservers();
        this.pipeline.addObserver((IObserver)this.eventObserver);
        this.pipeline.startBatch();
        this.pipeline.process(new RawDocument(this.getClass().getResourceAsStream("/messages_de-brief.properties"), "ASCII", LocaleId.GERMAN));
        this.pipeline.endBatch();
        List<Event> el = this.eventObserver.getResult();
        Assert.assertEquals((Object)EventType.START_BATCH, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.START_BATCH_ITEM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.PIPELINE_PARAMETERS, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.START_DOCUMENT, (Object)el.remove(0).getEventType());
        Event tue = el.remove(0);
        Assert.assertNotNull((Object)tue.getTextUnit().getTarget(LocaleId.GERMAN).getAnnotation(AltTranslationsAnnotation.class));
        Assert.assertEquals((Object)"Abbrechen", (Object)this.getAltTransTarget(tue.getTextUnit(), LocaleId.GERMAN));
        AltTranslationsAnnotation ata = (AltTranslationsAnnotation)tue.getTextUnit().getTarget(LocaleId.GERMAN).getAnnotation(AltTranslationsAnnotation.class);
        Assert.assertEquals((Object)MatchType.EXACT_UNIQUE_ID, (Object)ata.getFirst().getType());
        Assert.assertTrue((boolean)tue.getTextUnit().hasTarget(LocaleId.GERMAN));
        Assert.assertEquals((Object)"Abbrechen", (Object)tue.getTextUnit().getTarget(LocaleId.GERMAN).toString());
        tue = el.remove(0);
        Assert.assertNotNull((Object)tue.getTextUnit().getTarget(LocaleId.GERMAN).getAnnotation(AltTranslationsAnnotation.class));
        Assert.assertEquals((Object)"Es konnte keine Verbindung zum <b>Server</b> aufgebaut werden.", (Object)this.getAltTransTarget(tue.getTextUnit(), LocaleId.GERMAN));
        ata = (AltTranslationsAnnotation)tue.getTextUnit().getTarget(LocaleId.GERMAN).getAnnotation(AltTranslationsAnnotation.class);
        Assert.assertEquals((Object)MatchType.EXACT_UNIQUE_ID, (Object)ata.getFirst().getType());
        Assert.assertTrue((boolean)tue.getTextUnit().hasTarget(LocaleId.GERMAN));
        Assert.assertEquals((Object)"Es konnte keine Verbindung zum <b>Server</b> aufgebaut werden.", (Object)tue.getTextUnit().toString());
        Assert.assertEquals((Object)EventType.END_DOCUMENT, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH_ITEM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH, (Object)el.remove(0).getEventType());
    }

    private String getAltTransTarget(ITextUnit tu, LocaleId targetLocale) {
        AltTranslationsAnnotation ata = (AltTranslationsAnnotation)tu.getTarget(targetLocale).getAnnotation(AltTranslationsAnnotation.class);
        return ata.getFirst().getTarget().toString();
    }
}

