/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.fullwidthconversion;

import net.sf.okapi.steps.fullwidthconversion.FullWidthConversionStep;
import net.sf.okapi.steps.fullwidthconversion.Parameters;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FullWidthConversionStepTest {
    @Test
    public void convertToHalfWidthTest() {
        Parameters params = new Parameters();
        params.setToHalfWidth(true);
        String text = "Foo 123 \uff26\uff4f\uff4f\u3000\uff11\uff12\uff13 \uff01\uff1f\uff08\uff09 \u3371 \u2100 \u30ac\u30d1\u30aa \ud55c\uad6d\uc5b4 \u314e\u314f\u3134";
        Assert.assertEquals((Object)"Foo 123 Foo 123 !?() \u3371 \u2100 \u30ac\u30d1\u30aa \ud55c\uad6d\uc5b4 \uffbe\u314f\uffa4", (Object)FullWidthConversionStep.changeWidth((String)text, (Parameters)params));
        params.setIncludeSLA(true);
        Assert.assertEquals((Object)"Foo 123 Foo 123 !?() hPa \u2100 \u30ac\u30d1\u30aa \ud55c\uad6d\uc5b4 \uffbe\u314f\uffa4", (Object)FullWidthConversionStep.changeWidth((String)text, (Parameters)params));
        params.setIncludeLLS(true);
        Assert.assertEquals((Object)"Foo 123 Foo 123 !?() hPa a/c \u30ac\u30d1\u30aa \ud55c\uad6d\uc5b4 \uffbe\u314f\uffa4", (Object)FullWidthConversionStep.changeWidth((String)text, (Parameters)params));
        params.setIncludeKatakana(true);
        Assert.assertEquals((Object)"Foo 123 Foo 123 !?() hPa a/c \uff76\uff9e\uff8a\uff9f\uff75 \ud55c\uad6d\uc5b4 \uffbe\u314f\uffa4", (Object)FullWidthConversionStep.changeWidth((String)text, (Parameters)params));
        params.setNormalizeOutput(false);
        Assert.assertEquals((Object)"Foo 123 Foo 123 !?() hPa a/c \uff76\uff9e\uff8a\uff9f\uff75 \u1112\u1161\u11ab\u1100\u116e\u11a8\u110b\u1165 \uffbe\u314f\uffa4", (Object)FullWidthConversionStep.changeWidth((String)text, (Parameters)params));
        text = "A\u0308";
        params.setNormalizeOutput(true);
        Assert.assertEquals((Object)text, (Object)FullWidthConversionStep.changeWidth((String)text, (Parameters)params));
        params.setNormalizeOutput(false);
        Assert.assertEquals((Object)text, (Object)FullWidthConversionStep.changeWidth((String)text, (Parameters)params));
        text = "\ud55c\uad6d\uc5b4";
        params.setNormalizeOutput(true);
        Assert.assertEquals((Object)text, (Object)FullWidthConversionStep.changeWidth((String)text, (Parameters)params));
        params.setNormalizeOutput(false);
        Assert.assertEquals((Object)text, (Object)FullWidthConversionStep.changeWidth((String)text, (Parameters)params));
    }

    @Test
    public void convertToFullWidthTest() {
        Parameters params = new Parameters();
        params.setToHalfWidth(false);
        String text = "\uff26\uff4f\uff4f\u3000\uff11\uff12\uff13 Foo 123 !?() \uff76\uff9e\uff8a\uff9f\uff75 \uffbe\uffc2\uffa4";
        Assert.assertEquals((Object)"\uff26\uff4f\uff4f\u3000\uff11\uff12\uff13\u3000\uff26\uff4f\uff4f\u3000\uff11\uff12\uff13\u3000\uff01\uff1f\uff08\uff09\u3000\u30ac\u30d1\u30aa\u3000\u314e\uffc2\u3134", (Object)FullWidthConversionStep.changeWidth((String)text, (Parameters)params));
        params.setAsciiOnly(true);
        Assert.assertEquals((Object)"\uff26\uff4f\uff4f\u3000\uff11\uff12\uff13\u3000\uff26\uff4f\uff4f\u3000\uff11\uff12\uff13\u3000\uff01\uff1f\uff08\uff09\u3000\uff76\uff9e\uff8a\uff9f\uff75\u3000\uffbe\uffc2\uffa4", (Object)FullWidthConversionStep.changeWidth((String)text, (Parameters)params));
        params.setKatakanaOnly(true);
        Assert.assertEquals((Object)"\uff26\uff4f\uff4f\u3000\uff11\uff12\uff13 Foo 123 !?() \u30ac\u30d1\u30aa \uffbe\uffc2\uffa4", (Object)FullWidthConversionStep.changeWidth((String)text, (Parameters)params));
        params.setKatakanaOnly(false);
        params.setNormalizeOutput(false);
        Assert.assertEquals((Object)"\uff26\uff4f\uff4f\u3000\uff11\uff12\uff13\u3000\uff26\uff4f\uff4f\u3000\uff11\uff12\uff13\u3000\uff01\uff1f\uff08\uff09\u3000\u30ab\u3099\u30cf\u309a\u30aa\u3000\u314e\uffc2\u3134", (Object)FullWidthConversionStep.changeWidth((String)text, (Parameters)params));
        params.setKatakanaOnly(true);
        text = "A\u0308";
        params.setNormalizeOutput(true);
        Assert.assertEquals((Object)text, (Object)FullWidthConversionStep.changeWidth((String)text, (Parameters)params));
        params.setNormalizeOutput(false);
        Assert.assertEquals((Object)text, (Object)FullWidthConversionStep.changeWidth((String)text, (Parameters)params));
    }
}

