/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.formatconversion;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.filterwriter.TMXContent;
import net.sf.okapi.common.filterwriter.XLIFFContent;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.steps.formatconversion.TableFilterWriterParameters;

public class TableFilterWriter
implements IFilterWriter {
    private static final int INLINE_ORIGINAL = 0;
    private static final int INLINE_GENERIC = 1;
    private static final int INLINE_TMX = 2;
    private static final int INLINE_XLIFF = 3;
    private static final int INLINE_XLIFF_GX = 4;
    private TableFilterWriterParameters params;
    private OutputStreamWriter writer;
    private OutputStream outputStream;
    private String outputPath;
    private LocaleId trgLoc;
    private String encoding;
    private File tempFile;
    private final String linebreak = System.getProperty("line.separator");
    private int inlineType;
    private TMXContent tmxFmt;
    private XLIFFContent xliffFmt;
    private GenericContent genericFmt;
    private boolean useDQ;
    private boolean escapeTab;

    public TableFilterWriter() {
        this.params = new TableFilterWriterParameters();
    }

    public void cancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.writer == null) {
            return;
        }
        IOException err = null;
        InputStream orig = null;
        OutputStream dest = null;
        try {
            this.writer.close();
            this.writer = null;
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
            if (this.tempFile != null) {
                int len;
                dest = new FileOutputStream(this.outputPath);
                orig = new FileInputStream(this.tempFile);
                byte[] buffer = new byte[2048];
                while ((len = orig.read(buffer)) > 0) {
                    dest.write(buffer, 0, len);
                }
            }
        }
        catch (IOException e) {
            err = e;
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException e) {
                    err = e;
                }
                dest = null;
            }
            if (orig != null) {
                try {
                    orig.close();
                }
                catch (IOException e) {
                    err = e;
                }
                orig = null;
                if (err != null) {
                    throw new OkapiException((Throwable)err);
                }
                if (this.tempFile != null) {
                    this.tempFile.delete();
                    this.tempFile = null;
                }
            }
        }
    }

    public String getName() {
        return "TableFilterWriter";
    }

    public EncoderManager getEncoderManager() {
        return null;
    }

    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    public TableFilterWriterParameters getParameters() {
        return this.params;
    }

    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                this.initialize();
                break;
            }
            case START_DOCUMENT: {
                this.handleStartDocument(event);
                break;
            }
            case TEXT_UNIT: {
                this.handleTextUnit(event);
                break;
            }
            case END_DOCUMENT: {
                this.close();
                break;
            }
        }
        return event;
    }

    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.trgLoc = locale;
        this.encoding = defaultEncoding;
    }

    public void setOutput(String path) {
        this.outputPath = path;
    }

    public void setOutput(OutputStream output) {
        this.outputStream = output;
    }

    public void setParameters(IParameters params) {
        this.params = (TableFilterWriterParameters)params;
    }

    private void initialize() {
        this.useDQ = this.params.getUseDoubleQuotes();
        this.escapeTab = this.params.getSeparator().indexOf(9) > -1;
        switch (this.params.getInlineFormat()) {
            case "generic": {
                this.inlineType = 1;
                this.genericFmt = new GenericContent();
                break;
            }
            case "tmx": {
                this.inlineType = 2;
                this.tmxFmt = new TMXContent();
                break;
            }
            case "xliff": {
                this.inlineType = 3;
                this.xliffFmt = new XLIFFContent();
                break;
            }
            case "xliffgx": {
                this.inlineType = 4;
                this.xliffFmt = new XLIFFContent();
                break;
            }
            default: {
                this.inlineType = 0;
            }
        }
    }

    private void handleStartDocument(Event event) {
        try {
            String originalEnc;
            StartDocument sd = (StartDocument)event.getResource();
            this.tempFile = null;
            if (this.outputStream == null) {
                boolean useTemp = false;
                File f = new File(this.outputPath);
                if (f.exists()) {
                    boolean bl = useTemp = !f.delete();
                }
                if (useTemp) {
                    this.tempFile = File.createTempFile("~okapi-43_gfwTmp_", null);
                    this.outputStream = new BufferedOutputStream(new FileOutputStream(this.tempFile.getAbsolutePath()));
                } else {
                    Util.createDirectories((String)this.outputPath);
                    this.outputStream = new BufferedOutputStream(new FileOutputStream(this.outputPath));
                }
            }
            if ((originalEnc = sd.getEncoding()) == null) {
                originalEnc = Charset.defaultCharset().name();
            }
            if (this.encoding == null) {
                this.encoding = originalEnc;
            }
            this.writer = new OutputStreamWriter(this.outputStream, this.encoding);
            boolean useUTF8BOM = false;
            if ("utf-8".equalsIgnoreCase(this.encoding) && "utf-8".equalsIgnoreCase(originalEnc)) {
                useUTF8BOM = sd.hasUTF8BOM();
            }
            Util.writeBOMIfNeeded((Writer)this.writer, (boolean)useUTF8BOM, (String)this.encoding);
        }
        catch (IOException e) {
            throw new OkapiException((Throwable)e);
        }
    }

    private void handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = tu.getTarget(this.trgLoc);
        if (trgCont == null) {
            trgCont = new TextContainer();
        }
        if (!srcCont.contentIsOneSegment()) {
            this.writeRow(srcCont.getFirstContent(), trgCont.getFirstContent());
            return;
        }
        if (trgCont.getSegments().count() != srcCont.getSegments().count()) {
            this.writeRow(srcCont.getUnSegmentedContentCopy(), trgCont.getUnSegmentedContentCopy());
            return;
        }
        ISegments trgSegs = trgCont.getSegments();
        for (Segment srcSeg : srcCont.getSegments()) {
            Segment trgSeg = trgSegs.get(srcSeg.id);
            if (trgSeg == null) {
                this.writeRow(srcSeg.text, null);
                continue;
            }
            this.writeRow(srcSeg.text, trgSeg.text);
        }
    }

    private void writeRow(TextFragment srcFrag, TextFragment trgFrag) {
        try {
            if (this.useDQ) {
                this.writer.write("\"");
            }
            this.writer.write(this.format(srcFrag));
            if (this.useDQ) {
                this.writer.write("\"" + this.params.getSeparator() + "\"");
            } else {
                this.writer.write(this.params.getSeparator());
            }
            if (trgFrag != null) {
                this.writer.write(this.format(trgFrag));
            }
            if (this.useDQ) {
                this.writer.write("\"");
            }
            this.writer.write(this.linebreak);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing row.", (Throwable)e);
        }
    }

    private String format(TextFragment frag) {
        String tmp;
        switch (this.inlineType) {
            case 1: {
                tmp = this.genericFmt.setContent(frag).toString();
                break;
            }
            case 2: {
                tmp = this.tmxFmt.setContent(frag).toString();
                break;
            }
            case 3: {
                tmp = this.xliffFmt.setContent(frag).toString();
                break;
            }
            case 4: {
                tmp = this.xliffFmt.setContent(frag).toString(true);
                break;
            }
            default: {
                tmp = frag.toText();
            }
        }
        if (this.useDQ) {
            tmp = tmp.replace("\\", "\\\\");
            tmp = tmp.replace("\"", "\\\"");
        }
        if (this.escapeTab) {
            return tmp.replace("\t", "\\t");
        }
        return tmp;
    }
}

