/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.formatconversion;

import java.io.File;
import java.net.URI;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.ExecutionContext;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.IUserPrompt;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.filterwriter.TMXFilterWriter;
import net.sf.okapi.common.filterwriter.XLIFFWriter;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.filters.pensieve.PensieveFilterWriter;
import net.sf.okapi.filters.po.POWriter;
import net.sf.okapi.steps.formatconversion.CorpusFilterWriter;
import net.sf.okapi.steps.formatconversion.Parameters;
import net.sf.okapi.steps.formatconversion.TableFilterWriter;
import net.sf.okapi.steps.formatconversion.TableFilterWriterParameters;
import net.sf.okapi.steps.formatconversion.WordTableFilterWriter;

@UsingParameters(value=Parameters.class)
public class FormatConversionStep
extends BasePipelineStep {
    private static final int PO_OUTPUT = 0;
    private static final int TMX_OUTPUT = 1;
    private static final int TABLE_OUTPUT = 2;
    private static final int PENSIEVE_OUTPUT = 3;
    private static final int CORPUS_OUTPUT = 4;
    private static final int WORDTABLE_OUTPUT = 5;
    private static final int XLIFF_OUTPUT = 6;
    private Parameters params = new Parameters();
    private IFilterWriter writer;
    private boolean firstOutputCreated;
    private int outputType;
    private URI inputURI;
    private URI outputURI;
    private LocaleId targetLocale;
    private String rootDir;
    private ExecutionContext context;

    @StepParameterMapping(parameterType=StepParameterType.INPUT_URI)
    public void setInputURI(URI inputURI) {
        this.inputURI = inputURI;
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.EXECUTION_CONTEXT)
    public void setExecutionContext(ExecutionContext context) {
        this.context = context;
    }

    public String getDescription() {
        return "Converts the output of a filter into a specified file format. Expects: filter events. Sends back: filter events.";
    }

    public String getName() {
        return "Format Conversion";
    }

    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    public Parameters getParameters() {
        return this.params;
    }

    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                this.firstOutputCreated = false;
                switch (this.params.getOutputFormat()) {
                    case "po": {
                        this.outputType = 0;
                        this.createPOWriter();
                        break;
                    }
                    case "tmx": {
                        this.outputType = 1;
                        this.createTMXWriter();
                        break;
                    }
                    case "pensieve": {
                        this.outputType = 3;
                        this.createPensieveWriter();
                        break;
                    }
                    case "table": {
                        this.outputType = 2;
                        this.createTableWriter();
                        break;
                    }
                    case "corpus": {
                        this.outputType = 4;
                        this.createCorpusWriter();
                        break;
                    }
                    case "wordtable": {
                        this.outputType = 5;
                        this.createWordTableWriter();
                        break;
                    }
                    case "xliff": {
                        this.outputType = 6;
                        this.createXliffWriter();
                    }
                }
                this.writer.handleEvent(event);
                break;
            }
            case END_BATCH: {
                if (!this.params.getSingleOutput()) break;
                Ending ending = new Ending("end");
                this.writer.handleEvent(new Event(EventType.END_DOCUMENT, (IResource)ending));
                this.writer.close();
                break;
            }
            case START_DOCUMENT: {
                if (!this.firstOutputCreated) {
                    this.writer.setOptions(this.targetLocale, "UTF-8");
                }
                if (this.firstOutputCreated && this.params.getSingleOutput()) break;
                switch (this.outputType) {
                    case 0: {
                        this.startPOOutput();
                        break;
                    }
                    case 1: {
                        this.startTMXOutput();
                        break;
                    }
                    case 2: {
                        this.startTableOutput();
                        break;
                    }
                    case 3: {
                        this.startPensieveOutput();
                        break;
                    }
                    case 4: {
                        this.startCorpusOutput();
                        break;
                    }
                    case 5: {
                        this.startWordTableOutput();
                        break;
                    }
                    case 6: {
                        this.startXliffOutput();
                    }
                }
                this.writer.handleEvent(event);
                break;
            }
            case END_DOCUMENT: {
                if (this.params.getSingleOutput()) break;
                this.writer.handleEvent(event);
                this.writer.close();
                break;
            }
            case START_SUBDOCUMENT: 
            case END_SUBDOCUMENT: 
            case START_GROUP: 
            case END_GROUP: 
            case START_SUBFILTER: 
            case END_SUBFILTER: {
                this.writer.handleEvent(event);
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event);
                break;
            }
        }
        return event;
    }

    protected void processTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (this.params.getSkipEntriesWithoutText() && !tu.getSource().hasText(true, false)) {
            return;
        }
        if (this.params.getApprovedEntriesOnly()) {
            boolean approved = false;
            if (tu.hasTargetProperty(this.targetLocale, "approved")) {
                approved = tu.getTargetProperty(this.targetLocale, "approved").getBoolean();
            }
            if (!approved) {
                return;
            }
        }
        switch (this.params.getTargetStyle()) {
            case 2: {
                tu.createTarget(this.targetLocale, true, 0);
                break;
            }
            case 1: {
                tu.createTarget(this.targetLocale, true, 7);
            }
        }
        this.writer.setOptions(this.targetLocale, "UTF-8");
        this.writer.handleEvent(event);
    }

    private void createPOWriter() {
        this.writer = this.params.getWriter() == null ? new POWriter() : this.params.getWriter();
        net.sf.okapi.filters.po.Parameters outParams = (net.sf.okapi.filters.po.Parameters)this.writer.getParameters();
        outParams.setOutputGeneric(this.params.getUseGenericCodes());
    }

    private void startPOOutput() {
        File outFile = this.params.getSingleOutput() ? new File(Util.fillRootDirectoryVariable((String)this.params.getOutputPath(), (String)this.rootDir)) : (this.params.getAutoExtensions() ? new File(this.inputURI.getPath() + ".po") : new File(this.outputURI.getPath()));
        if (outFile.exists()) {
            this.promptShouldOverwrite();
        }
        this.writer.setOutput(outFile.getPath());
        this.writer.setOptions(this.targetLocale, "UTF-8");
        this.firstOutputCreated = true;
    }

    private void createTMXWriter() {
        this.writer = this.params.getWriter() == null ? new TMXFilterWriter() : this.params.getWriter();
    }

    private void startTMXOutput() {
        File outFile = this.params.getSingleOutput() ? new File(Util.fillRootDirectoryVariable((String)this.params.getOutputPath(), (String)this.rootDir)) : (this.params.getAutoExtensions() ? new File(this.inputURI.getPath() + ".tmx") : new File(this.outputURI));
        if (outFile.exists()) {
            this.promptShouldOverwrite();
        }
        this.writer.setOutput(outFile.getPath());
        this.writer.setOptions(this.targetLocale, "UTF-8");
        this.firstOutputCreated = true;
    }

    private void createCorpusWriter() {
        this.writer = this.params.getWriter() == null ? new CorpusFilterWriter() : this.params.getWriter();
    }

    private void startCorpusOutput() {
        File outFile = this.params.getSingleOutput() ? new File(Util.fillRootDirectoryVariable((String)this.params.getOutputPath(), (String)this.rootDir)) : (this.params.getAutoExtensions() ? new File(this.inputURI.getPath() + ".txt") : new File(this.outputURI));
        if (outFile.exists()) {
            this.promptShouldOverwrite();
        }
        this.writer.setOutput(outFile.getPath());
        this.writer.setOptions(this.targetLocale, "UTF-8");
        this.firstOutputCreated = true;
    }

    private void createTableWriter() {
        this.writer = this.params.getWriter() == null ? new TableFilterWriter() : this.params.getWriter();
        this.writer.setOptions(this.targetLocale, "UTF-8");
        TableFilterWriterParameters options = (TableFilterWriterParameters)this.writer.getParameters();
        options.fromString(this.params.getFormatOptions());
        if (this.params.getUseGenericCodes()) {
            options.setInlineFormat("generic");
        }
    }

    private void startTableOutput() {
        File outFile = this.params.getSingleOutput() ? new File(Util.fillRootDirectoryVariable((String)this.params.getOutputPath(), (String)this.rootDir)) : (this.params.getAutoExtensions() ? new File(this.inputURI.getPath() + ".txt") : new File(this.outputURI));
        if (outFile.exists()) {
            this.promptShouldOverwrite();
        }
        this.writer.setOutput(outFile.getPath());
        this.writer.setOptions(this.targetLocale, "UTF-8");
        this.firstOutputCreated = true;
    }

    private void createWordTableWriter() {
        this.writer = this.params.getWriter() == null ? new WordTableFilterWriter() : this.params.getWriter();
    }

    private void startWordTableOutput() {
        File outFile = this.params.getSingleOutput() ? new File(Util.fillRootDirectoryVariable((String)this.params.getOutputPath(), (String)this.rootDir)) : (this.params.getAutoExtensions() ? new File(this.inputURI.getPath() + ".rtf") : new File(this.outputURI));
        if (outFile.exists()) {
            this.promptShouldOverwrite();
        }
        this.writer.setOutput(outFile.getPath());
        this.writer.setOptions(this.targetLocale, "windows-1252");
        this.firstOutputCreated = true;
    }

    private void createPensieveWriter() {
        this.writer = this.params.getWriter() == null ? new PensieveFilterWriter() : this.params.getWriter();
        ((PensieveFilterWriter)this.writer).setOverwriteSameSource(this.params.getOverwriteSameSource());
    }

    private void startPensieveOutput() {
        File outFile = this.params.getSingleOutput() ? new File(Util.fillRootDirectoryVariable((String)this.params.getOutputPath(), (String)this.rootDir)) : (this.params.getAutoExtensions() ? new File(this.inputURI.getPath() + ".pentm") : new File(this.outputURI.getPath()));
        if (outFile.exists()) {
            this.promptShouldOverwrite();
        }
        this.writer.setOutput(outFile.getPath());
        this.writer.setOptions(this.targetLocale, "UTF-8");
        this.firstOutputCreated = true;
    }

    private void createXliffWriter() {
        this.writer = this.params.getWriter() == null ? new XLIFFWriter() : this.params.getWriter();
    }

    private void startXliffOutput() {
        File outFile = this.params.getSingleOutput() ? new File(Util.fillRootDirectoryVariable((String)this.params.getOutputPath(), (String)this.rootDir)) : (this.params.getAutoExtensions() ? new File(this.inputURI.getPath() + ".xlf") : new File(this.outputURI));
        if (outFile.exists()) {
            this.promptShouldOverwrite();
        }
        this.writer.setOutput(outFile.getPath());
        this.writer.setOptions(this.targetLocale, "UTF-8");
        this.firstOutputCreated = true;
    }

    private void promptShouldOverwrite() {
        IUserPrompt p;
        if (this.context == null || this.context.getIsNoPrompt()) {
            return;
        }
        String promptClass = this.context.getIsGui() ? "net.sf.okapi.common.ui.UserPrompt" : "net.sf.okapi.common.UserPrompt";
        try {
            p = (IUserPrompt)Class.forName(promptClass).newInstance();
            p.initialize(this.context.getUiParent(), this.context.getApplicationName());
        }
        catch (Throwable e) {
            throw new InstantiationError("Could not instantiate user prompt.");
        }
        p.promptOKCancel("A file already exists in the target location.\nSelect \"OK\" to overwrite it.");
    }
}

