/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.formatconversion;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public class CorpusFilterWriter
implements IFilterWriter {
    private OutputStreamWriter srcWriter;
    private OutputStream srcOutputStream;
    private String srcOutputPath;
    private File srcTempFile;
    private OutputStreamWriter trgWriter;
    private OutputStream trgOutputStream;
    private String trgOutputPath;
    private File trgTempFile;
    private String baseOutputPath;
    private LocaleId trgLoc;
    private String linebreak = System.getProperty("line.separator");

    public void cancel() {
    }

    public void close() {
        if (this.srcWriter == null) {
            return;
        }
        try {
            this.srcWriter.close();
            this.srcWriter = null;
            if (this.srcOutputStream != null) {
                this.srcOutputStream.close();
                this.srcOutputStream = null;
            }
            if (this.srcTempFile != null) {
                StreamUtil.copy((InputStream)new FileInputStream(this.srcTempFile), (String)this.srcOutputPath);
            }
            this.trgWriter.close();
            this.trgWriter = null;
            if (this.trgOutputStream != null) {
                this.trgOutputStream.close();
                this.trgOutputStream = null;
            }
            if (this.trgTempFile != null) {
                StreamUtil.copy((InputStream)new FileInputStream(this.trgTempFile), (String)this.trgOutputPath);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error closing the output files.", (Throwable)e);
        }
    }

    public String getName() {
        return "CorpusFilterWriter";
    }

    public EncoderManager getEncoderManager() {
        return null;
    }

    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    public IParameters getParameters() {
        return null;
    }

    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.handleStartDocument(event);
                break;
            }
            case TEXT_UNIT: {
                this.handleTextUnit(event);
                break;
            }
            case END_DOCUMENT: {
                this.close();
                break;
            }
        }
        return event;
    }

    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.trgLoc = locale;
    }

    public void setOutput(String path) {
        this.baseOutputPath = path;
    }

    public void setOutput(OutputStream output) {
        throw new OkapiNotImplementedException("The method setOutput(OutputStream) is not supported for this filter-writer.");
    }

    public void setParameters(IParameters params) {
    }

    private void handleStartDocument(Event event) {
        try {
            this.srcTempFile = null;
            this.trgTempFile = null;
            StartDocument sd = (StartDocument)event.getResource();
            this.srcOutputPath = this.baseOutputPath + "." + sd.getLocale().toBCP47().toLowerCase();
            this.trgOutputPath = this.baseOutputPath + "." + this.trgLoc.toBCP47().toLowerCase();
            boolean useTemp = false;
            File f = new File(this.srcOutputPath);
            if (f.exists()) {
                boolean bl = useTemp = !f.delete();
            }
            if (useTemp) {
                this.srcTempFile = File.createTempFile("~okapi-41_gfwTmp_", null);
                this.srcOutputStream = new BufferedOutputStream(new FileOutputStream(this.srcTempFile.getAbsolutePath()));
            } else {
                Util.createDirectories((String)this.srcOutputPath);
                this.srcOutputStream = new BufferedOutputStream(new FileOutputStream(this.srcOutputPath));
            }
            this.srcWriter = new OutputStreamWriter(this.srcOutputStream, StandardCharsets.UTF_8);
            useTemp = false;
            f = new File(this.trgOutputPath);
            if (f.exists()) {
                boolean bl = useTemp = !f.delete();
            }
            if (useTemp) {
                this.trgTempFile = File.createTempFile("~okapi-42_gfwTmp_", null);
                this.trgOutputStream = new BufferedOutputStream(new FileOutputStream(this.trgTempFile.getAbsolutePath()));
            } else {
                Util.createDirectories((String)this.trgOutputPath);
                this.trgOutputStream = new BufferedOutputStream(new FileOutputStream(this.trgOutputPath));
            }
            this.trgWriter = new OutputStreamWriter(this.trgOutputStream, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new OkapiException((Throwable)e);
        }
    }

    private void handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return;
        }
        TextContainer srcCont = tu.getSource();
        TextContainer trgCont = tu.getTarget(this.trgLoc);
        if (trgCont == null) {
            trgCont = new TextContainer("");
        }
        if (!srcCont.contentIsOneSegment()) {
            this.writeLine(srcCont.getFirstContent(), trgCont.getFirstContent());
            return;
        }
        ISegments trgSegs = trgCont.getSegments();
        for (Segment srcSeg : srcCont.getSegments()) {
            Segment trgSeg = trgSegs.get(srcSeg.id);
            if (trgSeg == null) {
                trgSeg = new Segment();
            }
            this.writeLine(srcSeg.text, trgSeg.text);
        }
    }

    private void writeLine(TextFragment srcFrag, TextFragment trgFrag) {
        try {
            this.srcWriter.write(this.format(srcFrag));
            this.srcWriter.write(this.linebreak);
            this.trgWriter.write(this.format(trgFrag));
            this.trgWriter.write(this.linebreak);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing line.", (Throwable)e);
        }
    }

    private String format(TextFragment frag) {
        return TextUnitUtil.getText((TextFragment)frag);
    }
}

