/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.formatconversion;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.uidescription.AbstractPart;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;
import net.sf.okapi.common.uidescription.PathInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    public static final String FORMAT_TMX = "tmx";
    public static final String FORMAT_PO = "po";
    public static final String FORMAT_TABLE = "table";
    public static final String FORMAT_PENSIEVE = "pensieve";
    public static final String FORMAT_CORPUS = "corpus";
    public static final String FORMAT_WORDTABLE = "wordtable";
    public static final int TRG_TARGETOREMPTY = 0;
    public static final int TRG_FORCESOURCE = 1;
    public static final int TRG_FORCEEMPTY = 2;
    private static final String SINGLEOUTPUT = "singleOutput";
    private static final String AUTOEXTENSIONS = "autoExtensions";
    private static final String OUTPUTPATH = "outputPath";
    private static final String TARGETSTYLE = "targetStyle";
    private static final String OUTPUTFORMAT = "outputFormat";
    private static final String FORMATOPTIONS = "formatOptions";
    private static final String USEGENERICCODES = "useGenericCodes";
    private static final String SKIPENTRIESWITHOUTTEXT = "skipEntriesWithoutText";
    private static final String APPROVEDENTRIESONLY = "approvedEntriesOnly";
    private static final String OVERWRITESAMESOURCE = "overwriteSameSource";
    private IFilterWriter writer;

    public int getTargetStyle() {
        return this.getInteger(TARGETSTYLE);
    }

    public void setTargetStyle(int targetStyle) {
        this.setInteger(TARGETSTYLE, targetStyle);
    }

    public boolean getSingleOutput() {
        return this.getBoolean(SINGLEOUTPUT);
    }

    public void setSingleOutput(boolean singleOutput) {
        this.setBoolean(SINGLEOUTPUT, singleOutput);
    }

    public boolean getAutoExtensions() {
        return this.getBoolean(AUTOEXTENSIONS);
    }

    public void setAutoExtensions(boolean autoExtensions) {
        this.setBoolean(AUTOEXTENSIONS, autoExtensions);
    }

    public String getOutputPath() {
        return this.getString(OUTPUTPATH);
    }

    public void setOutputPath(String outputPath) {
        this.setString(OUTPUTPATH, outputPath);
    }

    public String getOutputFormat() {
        return this.getString(OUTPUTFORMAT);
    }

    public void setOutputFormat(String outputFormat) {
        this.setString(OUTPUTFORMAT, outputFormat);
    }

    public boolean getUseGenericCodes() {
        return this.getBoolean(USEGENERICCODES);
    }

    public void setUseGenericCodes(boolean useGenericCodes) {
        this.setBoolean(USEGENERICCODES, useGenericCodes);
    }

    public String getFormatOptions() {
        return this.getGroup(FORMATOPTIONS);
    }

    public void setFormatOptions(String formatOptions) {
        this.setGroup(FORMATOPTIONS, formatOptions);
    }

    public boolean getSkipEntriesWithoutText() {
        return this.getBoolean(SKIPENTRIESWITHOUTTEXT);
    }

    public void setSkipEntriesWithoutText(boolean skipEntriesWithoutText) {
        this.setBoolean(SKIPENTRIESWITHOUTTEXT, skipEntriesWithoutText);
    }

    public boolean getApprovedEntriesOnly() {
        return this.getBoolean(APPROVEDENTRIESONLY);
    }

    public void setApprovedEntriesOnly(boolean approvedEntriesOnly) {
        this.setBoolean(APPROVEDENTRIESONLY, approvedEntriesOnly);
    }

    public boolean getOverwriteSameSource() {
        return this.getBoolean(OVERWRITESAMESOURCE);
    }

    public void setOverwriteSameSource(boolean overwriteSameSource) {
        this.setBoolean(OVERWRITESAMESOURCE, overwriteSameSource);
    }

    public IFilterWriter getWriter() {
        return this.writer;
    }

    public void setWriter(IFilterWriter writer) {
        this.writer = writer;
    }

    public void reset() {
        super.reset();
        this.setSingleOutput(true);
        this.setAutoExtensions(false);
        this.setTargetStyle(0);
        this.setOutputPath("");
        this.setOutputFormat(FORMAT_TMX);
        this.setFormatOptions(null);
        this.setUseGenericCodes(false);
        this.setSkipEntriesWithoutText(true);
        this.setApprovedEntriesOnly(false);
        this.setOverwriteSameSource(false);
        this.writer = null;
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(SINGLEOUTPUT, "Create a single output document", null);
        desc.add(AUTOEXTENSIONS, "Output paths are the input paths plus the new format extension", null);
        desc.add(OUTPUTPATH, "Output path", "Full path of the single output document to generate");
        desc.add(OUTPUTFORMAT, "Output format", "Format to generate in output");
        desc.add(USEGENERICCODES, "Output generic inline codes", null);
        desc.add(TARGETSTYLE, "Target content", "Type of content to put in the target");
        desc.add(SKIPENTRIESWITHOUTTEXT, "Do not output entries without text", null);
        desc.add(APPROVEDENTRIESONLY, "Output only approved entries", null);
        desc.add(OVERWRITESAMESOURCE, "Overwrite if source is the same (for Pensieve TM)", null);
        desc.add(FORMATOPTIONS, "Format options", null);
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Format Conversion", true, false);
        String[] choices = new String[]{FORMAT_PO, FORMAT_TMX, FORMAT_TABLE, FORMAT_PENSIEVE, FORMAT_CORPUS, FORMAT_WORDTABLE};
        String[] choicesLabels = new String[]{"PO File", "TMX Document", "Tab-Delimited Table", "Pensieve TM", "Parallel Corpus Files", "Word Table"};
        ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(OUTPUTFORMAT), choices);
        lsp.setChoicesLabels(choicesLabels);
        desc.addCheckboxPart(paramDesc.get(APPROVEDENTRIESONLY));
        desc.addCheckboxPart(paramDesc.get(USEGENERICCODES));
        desc.addCheckboxPart(paramDesc.get(OVERWRITESAMESOURCE));
        desc.addCheckboxPart(paramDesc.get(SKIPENTRIESWITHOUTTEXT));
        CheckboxPart cbp1 = desc.addCheckboxPart(paramDesc.get(SINGLEOUTPUT));
        PathInputPart pip = desc.addPathInputPart(paramDesc.get(OUTPUTPATH), "Output File", true);
        pip.setMasterPart((AbstractPart)cbp1, true);
        CheckboxPart cbp2 = desc.addCheckboxPart(paramDesc.get(AUTOEXTENSIONS));
        cbp2.setMasterPart((AbstractPart)cbp1, false);
        return desc;
    }
}

