/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.enrycher;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SpinInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String BASEURL = "baseUrl";
    private static final String MAXEVENTS = "maxEvents";

    public void reset() {
        super.reset();
        this.setBaseUrl("http://aidemo.ijs.si/mlw");
        this.setMaxEvents(20);
    }

    public String getBaseUrl() {
        return this.getString(BASEURL);
    }

    public void setBaseUrl(String baseUrl) {
        this.setString(BASEURL, Util.ensureSeparator((String)baseUrl, (boolean)true));
    }

    public int getMaxEvents() {
        return this.getInteger(MAXEVENTS);
    }

    public void setMaxEvents(int maxEvents) {
        this.setInteger(MAXEVENTS, maxEvents);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(BASEURL, "URL of the Enrycher Web service", null);
        desc.add(MAXEVENTS, "Events buffer", "Number of events to store before sending a query");
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Enrycher", true, false);
        desc.addTextInputPart(paramsDesc.get(BASEURL));
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get(MAXEVENTS));
        sip.setRange(1, 999);
        return desc;
    }
}

