/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.enrycher;

import java.util.LinkedList;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.enrycher.EnrycherClient;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class EnrycherClientTest {
    private GenericContent fmt = new GenericContent();

    @Test
    public void parametersTest() {
        EnrycherClient ec = new EnrycherClient();
        Assert.assertNotNull((Object)ec.getParameters());
    }

    @Test
    public void testList() {
        LinkedList<TextUnit> list = new LinkedList<TextUnit>();
        list.add(new TextUnit("1", "The Lake Bled. "));
        TextUnit tu = new TextUnit("2");
        TextContainer tc = tu.getSource();
        tc.append((TextPart)new Segment("s1", new TextFragment("The lake Bled.")));
        tc.append((TextPart)new Segment("s2", new TextFragment("The lake bled.")));
        list.add(tu);
        tu = new TextUnit("3");
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("Lake Bled");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br>");
        tu.setSourceContent(tf);
        list.add(tu);
        EnrycherClient ec = new EnrycherClient();
        ec.setLocale(LocaleId.ENGLISH);
        String fromEc = "<div\nits-annotators-ref=\"text-analysis|http://enrycher.ijs.si/mlw/toolinfo.xml#enrycher\">\n<p\nid='1_0'>The\n\n    <span\nits-ta-ident-ref=\"http://dbpedia.org/resource/Lake_Bled\"\nits-ta-class-ref=\"http://schema.org/Place\">Lake Bled</span>.</p>\n<p\nid='2_0'>The <span\nits-ta-ident-ref=\"http://dbpedia.org/resource/Lake_Bled\"\nits-ta-class-ref=\"http://schema.org/Place\">lake Bled</span>.</p>\n<p\nid='2_1'>The lake bled.</p>\n<p\nid='3_0'><u\nid='1'><span\nits-ta-ident-ref=\"http://dbpedia.org/resource/Lake_Bled\"\nits-ta-class-ref=\"http://schema.org/Place\">Lake Bled</span></u><br\nid='2'>\n</p>\n</div>\n";
        ec.parseHTML(fromEc, list);
        tf = ((ITextUnit)list.get(0)).getSource().getFirstContent();
        Code code = tf.getCode(0);
        Assert.assertEquals((Object)"REF:http://dbpedia.org/resource/Lake_Bled", (Object)code.getGenericAnnotationString("its-ta", "taIdent"));
        Assert.assertEquals((Object)"REF:http://schema.org/Place", (Object)code.getGenericAnnotationString("its-ta", "taClass"));
        Assert.assertEquals((Object)"The <1>Lake Bled</1>.", (Object)this.fmt.setContent(tf).toString());
        tf = ((ITextUnit)list.get(1)).getSource().getSegments().get(0).getContent();
        code = tf.getCode(0);
        Assert.assertEquals((Object)"REF:http://dbpedia.org/resource/Lake_Bled", (Object)code.getGenericAnnotationString("its-ta", "taIdent"));
        Assert.assertEquals((Object)"REF:http://schema.org/Place", (Object)code.getGenericAnnotationString("its-ta", "taClass"));
        Assert.assertEquals((Object)"The <1>lake Bled</1>.", (Object)this.fmt.setContent(tf).toString());
        tf = ((ITextUnit)list.get(1)).getSource().getSegments().get(1).getContent();
        Assert.assertFalse((boolean)tf.hasCode());
        tf = ((ITextUnit)list.get(2)).getSource().getFirstContent();
        Assert.assertEquals((long)3L, (long)tf.getCodes().size());
        code = tf.getCode(0);
        Assert.assertEquals((Object)"<b>", (Object)code.getData());
        Assert.assertEquals((Object)"REF:http://dbpedia.org/resource/Lake_Bled", (Object)code.getGenericAnnotationString("its-ta", "taIdent"));
        Assert.assertEquals((Object)"REF:http://schema.org/Place", (Object)code.getGenericAnnotationString("its-ta", "taClass"));
        Assert.assertEquals((Object)"<1>Lake Bled</1><2/>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testNestedSpans() {
        LinkedList<TextUnit> list = new LinkedList<TextUnit>();
        list.add(new TextUnit("1", "aaa bbb ccc ddd"));
        EnrycherClient ec = new EnrycherClient();
        ec.setLocale(LocaleId.ENGLISH);
        String fromEc = "<div>\n<p\nid='1_0'>\n<span\nits-ta-ident-ref=\"ident1\"\nits-ta-class-ref=\"class1\">aaa <span\nits-ta-ident-ref=\"ident2\"\nits-ta-class-ref=\"class2\">bbb</span> <span its-ta-ident-ref='ident3' its-ta-class-ref='class3'>ccc</span></span> <span\nits-ta-ident-ref=\"ident4\"\nits-ta-class-ref=\"class4\">ddd</span> </p>\n</div>\n";
        ec.parseHTML(fromEc, list);
        TextFragment tf = ((ITextUnit)list.get(0)).getSource().getFirstContent();
        Assert.assertEquals((Object)"<3>aaa <1>bbb</1> <2>ccc</2></3> <4>ddd</4>", (Object)this.fmt.setContent(tf).toString());
        Code code = tf.getCode(0);
        Assert.assertEquals((Object)"REF:ident2", (Object)code.getGenericAnnotationString("its-ta", "taIdent"));
        Assert.assertEquals((Object)"REF:class2", (Object)code.getGenericAnnotationString("its-ta", "taClass"));
        code = tf.getCode(2);
        Assert.assertEquals((Object)"REF:ident3", (Object)code.getGenericAnnotationString("its-ta", "taIdent"));
        Assert.assertEquals((Object)"REF:class3", (Object)code.getGenericAnnotationString("its-ta", "taClass"));
        code = tf.getCode(4);
        Assert.assertEquals((Object)"REF:ident1", (Object)code.getGenericAnnotationString("its-ta", "taIdent"));
        Assert.assertEquals((Object)"REF:class1", (Object)code.getGenericAnnotationString("its-ta", "taClass"));
        code = tf.getCode(6);
        Assert.assertEquals((Object)"REF:ident4", (Object)code.getGenericAnnotationString("its-ta", "taIdent"));
        Assert.assertEquals((Object)"REF:class4", (Object)code.getGenericAnnotationString("its-ta", "taClass"));
    }
}

