/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.copyormove;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String COPYOPTION = "copyOption";
    private static final String MOVE = "move";
    public static final String COPYOPTION_OVERWRITE = "overwrite";
    public static final String COPYOPTION_BACKUP = "backup";
    public static final String COPYOPTION_SKIP = "skip";

    public void reset() {
        super.reset();
        this.setCopyOption(COPYOPTION_OVERWRITE);
        this.setMove(false);
    }

    public boolean isMove() {
        return this.getBoolean(MOVE);
    }

    public void setMove(boolean move) {
        this.setBoolean(MOVE, move);
    }

    public String getCopyOption() {
        return this.getString(COPYOPTION);
    }

    public void setCopyOption(String copyOption) {
        this.setString(COPYOPTION, copyOption);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(COPYOPTION, "Choose copy protection method:", null);
        desc.add(MOVE, "Move files?", null);
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Copy Or Move", true, false);
        String[] values = new String[]{COPYOPTION_OVERWRITE, COPYOPTION_BACKUP, COPYOPTION_SKIP};
        String[] labels = new String[]{"Overwrite existing files", "Backup existing files", "Skip copy/move"};
        ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(COPYOPTION), values);
        lsp.setChoicesLabels(labels);
        lsp.setListType(1);
        desc.addCheckboxPart(paramDesc.get(MOVE));
        return desc;
    }
}

