/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.copyormove;

import java.io.InputStream;
import java.io.OutputStream;
import net.sf.okapi.common.FileCompare;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.IPipelineDriver;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.copyormove.CopyOrMoveStep;
import net.sf.okapi.steps.copyormove.Parameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CopyOrMoveTest {
    private FileLocation root;
    private String ROOT_PREFIX = "/test_folder";
    private CopyOrMoveStep step;
    private IPipelineDriver pdriver;
    private Parameters params;

    @Before
    public void setUp() {
        this.root = FileLocation.fromClass(this.getClass());
        this.step = new CopyOrMoveStep();
        this.resetFiles();
        Util.deleteDirectory((String)this.root.in(this.ROOT_PREFIX + "/to_empty/").toString(), (boolean)true);
        this.params = this.step.getParameters();
        this.pdriver = new PipelineDriver();
        String rootFolder = this.root.in(this.ROOT_PREFIX).toString();
        this.pdriver.setRootDirectories(rootFolder, rootFolder);
        this.pdriver.addStep((IPipelineStep)this.step);
    }

    @Test
    public void testBasicCopy() {
        this.params.setCopyOption("overwrite");
        this.params.setMove(false);
        this.addFiles(this.pdriver, "/to_empty", true);
        this.pdriver.processBatch();
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test00.txt", "/to_empty/test00.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test01.txt", "/to_empty/test01.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test02.txt", "/to_empty/test02.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test03.txt", "/to_empty/test03.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test04.txt", "/to_empty/test04.txt"));
    }

    @Test
    public void testBasicMove() {
        this.params.setCopyOption("overwrite");
        this.params.setMove(true);
        this.addFiles(this.pdriver, "/to_empty", false);
        this.pdriver.processBatch();
        this.resetFiles();
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test00.txt", "/to_empty/test00.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test01.txt", "/to_empty/test01.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test02.txt", "/to_empty/test02.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test03.txt", "/to_empty/test03.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test04.txt", "/to_empty/test04.txt"));
    }

    @Test
    public void testStructuredCopy() {
        this.params.setCopyOption("overwrite");
        this.params.setMove(false);
        this.addFiles(this.pdriver, "/to_empty", false);
        this.pdriver.processBatch();
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/test00.txt", "/to_empty/test00.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir01/subdir11/test01.txt", "/to_empty/subdir01/subdir11/test01.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir01/test02.txt", "/to_empty/subdir01/test02.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir02/test03.txt", "/to_empty/subdir02/test03.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir02/test04.txt", "/to_empty/subdir02/test04.txt"));
    }

    @Test
    public void testStructuredMove() {
        this.params.setCopyOption("overwrite");
        this.params.setMove(true);
        this.addFiles(this.pdriver, "/to_empty", false);
        this.pdriver.processBatch();
        this.resetFiles();
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/test00.txt", "/to_empty/test00.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir01/subdir11/test01.txt", "/to_empty/subdir01/subdir11/test01.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir01/test02.txt", "/to_empty/subdir01/test02.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir02/test03.txt", "/to_empty/subdir02/test03.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir02/test04.txt", "/to_empty/subdir02/test04.txt"));
    }

    @Test
    public void testOverwrite() {
        this.params.setCopyOption("overwrite");
        this.params.setMove(false);
        this.addFiles(this.pdriver, "/to_empty", true);
        this.resetTargetFiles(true);
        this.pdriver.processBatch();
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test00.txt", "/to_empty/test00.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test01.txt", "/to_empty/test01.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test02.txt", "/to_empty/test02.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test03.txt", "/to_empty/test03.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test04.txt", "/to_empty/test04.txt"));
        Assert.assertFalse((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test05.txt", "/to_empty/test05.txt"));
        Assert.assertFalse((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test06.txt", "/to_empty/test06.txt"));
    }

    @Test
    public void testBackup() {
        this.params.setCopyOption("backup");
        this.params.setMove(false);
        this.addFiles(this.pdriver, "/to_empty", true);
        this.resetTargetFiles(true);
        this.pdriver.processBatch();
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test00.txt", "/to_empty/test00.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test01.txt", "/to_empty/test01.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test02.txt", "/to_empty/test02.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test03.txt", "/to_empty/test03.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test04.txt", "/to_empty/test04.txt"));
        Assert.assertFalse((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test05.txt", "/to_empty/test05.txt"));
        Assert.assertFalse((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test06.txt", "/to_empty/test06.txt"));
    }

    @Test
    public void testSkip() {
        this.params.setCopyOption("skip");
        this.params.setMove(false);
        this.addFiles(this.pdriver, "/to_empty", true);
        this.resetTargetFiles(true);
        this.pdriver.processBatch();
        FileCompare fc = new FileCompare();
        Assert.assertFalse((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test00.txt", "/to_empty/test00.txt"));
        Assert.assertFalse((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test01.txt", "/to_empty/test01.txt"));
        Assert.assertFalse((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test02.txt", "/to_empty/test02.txt"));
        Assert.assertFalse((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test03.txt", "/to_empty/test03.txt"));
        Assert.assertFalse((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test04.txt", "/to_empty/test04.txt"));
        Assert.assertFalse((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test05.txt", "/to_empty/test05.txt"));
        Assert.assertFalse((boolean)this.filesAreIdenticalPerLines(fc, "/gold_flat/test06.txt", "/to_empty/test06.txt"));
    }

    @Test
    public void testStructuredOverwrite() {
        this.params.setCopyOption("overwrite");
        this.params.setMove(false);
        this.addFiles(this.pdriver, "/to_empty", false);
        this.resetTargetFiles(false);
        this.pdriver.processBatch();
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/test00.txt", "/to_empty/test00.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir01/subdir11/test01.txt", "/to_empty/subdir01/subdir11/test01.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir01/test02.txt", "/to_empty/subdir01/test02.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir02/test03.txt", "/to_empty/subdir02/test03.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir02/test04.txt", "/to_empty/subdir02/test04.txt"));
    }

    @Test
    public void testStructuredBackup() {
        this.params.setCopyOption("backup");
        this.params.setMove(false);
        this.addFiles(this.pdriver, "/to_empty", false);
        this.resetTargetFiles(false);
        this.pdriver.processBatch();
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/test00.txt", "/to_empty/test00.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir01/subdir11/test01.txt", "/to_empty/subdir01/subdir11/test01.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir01/test02.txt", "/to_empty/subdir01/test02.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir02/test03.txt", "/to_empty/subdir02/test03.txt"));
        Assert.assertTrue((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir02/test04.txt", "/to_empty/subdir02/test04.txt"));
    }

    boolean filesAreIdenticalPerLines(FileCompare fc, String gold, String actual) {
        return fc.compareFilesPerLines(this.root.out(this.ROOT_PREFIX + actual).toString(), this.root.in(this.ROOT_PREFIX + gold).toString(), "UTF-8");
    }

    @Test
    public void testStructuredSkip() {
        this.params.setCopyOption("skip");
        this.params.setMove(false);
        this.addFiles(this.pdriver, "/to_empty", false);
        this.resetTargetFiles(false);
        this.pdriver.processBatch();
        FileCompare fc = new FileCompare();
        Assert.assertFalse((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/test00.txt", "/to_empty/test00.txt"));
        Assert.assertFalse((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir01/subdir11/test01.txt", "/to_empty/subdir01/subdir11/test01.txt"));
        Assert.assertFalse((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir01/test02.txt", "/to_empty/subdir01/test02.txt"));
        Assert.assertFalse((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir02/test03.txt", "/to_empty/subdir02/test03.txt"));
        Assert.assertFalse((boolean)this.filesAreIdenticalPerLines(fc, "/gold_complex/subdir02/test04.txt", "/to_empty/subdir02/test04.txt"));
    }

    private void addFiles(IPipelineDriver pdriver, String outputPrefix, boolean isFlat) {
        if (isFlat) {
            pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(new RawDocument(this.root.out(this.ROOT_PREFIX + "/from_flat/test00.txt").asUri(), "UTF-8", LocaleId.ENGLISH), this.root.out(this.ROOT_PREFIX + outputPrefix + "/test00.txt").asUri(), null));
            pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(new RawDocument(this.root.out(this.ROOT_PREFIX + "/from_flat/test01.txt").asUri(), "UTF-8", LocaleId.ENGLISH), this.root.out(this.ROOT_PREFIX + outputPrefix + "/test01.txt").asUri(), null));
            pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(new RawDocument(this.root.out(this.ROOT_PREFIX + "/from_flat/test02.txt").asUri(), "UTF-8", LocaleId.ENGLISH), this.root.out(this.ROOT_PREFIX + outputPrefix + "/test02.txt").asUri(), null));
            pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(new RawDocument(this.root.out(this.ROOT_PREFIX + "/from_flat/test03.txt").asUri(), "UTF-8", LocaleId.ENGLISH), this.root.out(this.ROOT_PREFIX + outputPrefix + "/test03.txt").asUri(), null));
            pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(new RawDocument(this.root.out(this.ROOT_PREFIX + "/from_flat/test04.txt").asUri(), "UTF-8", LocaleId.ENGLISH), this.root.out(this.ROOT_PREFIX + outputPrefix + "/test04.txt").asUri(), null));
        } else {
            pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(new RawDocument(this.root.out(this.ROOT_PREFIX + "/from_complex/test00.txt").asUri(), "UTF-8", LocaleId.ENGLISH), this.root.out(this.ROOT_PREFIX + outputPrefix + "/test00.txt").asUri(), null));
            pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(new RawDocument(this.root.out(this.ROOT_PREFIX + "/from_complex/subdir01/subdir11/test01.txt").asUri(), "UTF-8", LocaleId.ENGLISH), this.root.out(this.ROOT_PREFIX + outputPrefix + "/subdir01/subdir11/test01.txt").asUri(), null));
            pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(new RawDocument(this.root.out(this.ROOT_PREFIX + "/from_complex/subdir01/test02.txt").asUri(), "UTF-8", LocaleId.ENGLISH), this.root.out(this.ROOT_PREFIX + outputPrefix + "/subdir01/test02.txt").asUri(), null));
            pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(new RawDocument(this.root.out(this.ROOT_PREFIX + "/from_complex/subdir02/test03.txt").asUri(), "UTF-8", LocaleId.ENGLISH), this.root.out(this.ROOT_PREFIX + outputPrefix + "/subdir02/test03.txt").asUri(), null));
            pdriver.addBatchItem((IBatchItemContext)new BatchItemContext(new RawDocument(this.root.out(this.ROOT_PREFIX + "/from_complex/subdir02/test04.txt").asUri(), "UTF-8", LocaleId.ENGLISH), this.root.out(this.ROOT_PREFIX + outputPrefix + "/subdir02/test04.txt").asUri(), null));
        }
    }

    private void resetFiles() {
        Util.deleteDirectory((String)this.root.out(this.ROOT_PREFIX + "/from_flat/").toString(), (boolean)true);
        StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_flat/test00.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/from_flat/test00.txt").asOutputStream());
        StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_flat/test01.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/from_flat/test01.txt").asOutputStream());
        StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_flat/test02.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/from_flat/test02.txt").asOutputStream());
        StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_flat/test03.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/from_flat/test03.txt").asOutputStream());
        StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_flat/test04.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/from_flat/test04.txt").asOutputStream());
        Util.deleteDirectory((String)this.root.out(this.ROOT_PREFIX + "/from_complex/").toString(), (boolean)true);
        StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_complex/test00.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/from_complex/test00.txt").asOutputStream());
        StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_complex/subdir01/subdir11/test01.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/from_complex/subdir01/subdir11/test01.txt").asOutputStream());
        StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_complex/subdir01/test02.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/from_complex/subdir01/test02.txt").asOutputStream());
        StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_complex/subdir02/test03.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/from_complex/subdir02/test03.txt").asOutputStream());
        StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_complex/subdir02/test04.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/from_complex/subdir02/test04.txt").asOutputStream());
    }

    private void resetTargetFiles(boolean isFlat) {
        if (isFlat) {
            Util.deleteDirectory((String)(this.root + "to_empty/"), (boolean)true);
            StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_for_options_flat/test00.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/to_empty/test00.txt").asOutputStream());
            StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_for_options_flat/test01.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/to_empty/test01.txt").asOutputStream());
            StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_for_options_flat/test02.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/to_empty/test02.txt").asOutputStream());
            StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_for_options_flat/test03.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/to_empty/test03.txt").asOutputStream());
            StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_for_options_flat/test04.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/to_empty/test04.txt").asOutputStream());
            StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_for_options_flat/test05.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/to_empty/test05.txt").asOutputStream());
            StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_for_options_flat/test06.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/to_empty/test06.txt").asOutputStream());
        } else {
            Util.deleteDirectory((String)(this.root + "to_empty/"), (boolean)true);
            StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_for_options_complex/test00.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/to_empty/test00.txt").asOutputStream());
            StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_for_options_complex/subdir01/subdir11/test01.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/to_empty/subdir01/subdir11/test01.txt").asOutputStream());
            StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_for_options_complex/subdir01/test02.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/to_empty/subdir01/test02.txt").asOutputStream());
            StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_for_options_complex/subdir02/test03.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/to_empty/subdir02/test03.txt").asOutputStream());
            StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_for_options_complex/subdir02/test04.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/to_empty/subdir02/test04.txt").asOutputStream());
            StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_for_options_complex/subdir02/test04.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/to_empty/subdir02/test04.txt").asOutputStream());
            StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_for_options_complex/subdir01/subdir11/test05.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/to_empty/subdir01/subdir11/test05.txt").asOutputStream());
            StreamUtil.copy((InputStream)this.root.in(this.ROOT_PREFIX + "/gold_for_options_complex/test06.txt").asInputStream(), (OutputStream)this.root.out(this.ROOT_PREFIX + "/to_empty/test06.txt").asOutputStream());
        }
    }
}

