/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common.createtarget;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.steps.common.createtarget.Parameters;

@UsingParameters(value=Parameters.class)
public class CreateTargetStep
extends BasePipelineStep {
    private Parameters params = new Parameters();
    private LocaleId targetLocale;

    public String getDescription() {
        return "Create target segment container. Optionally copy source content to the target. Expects: filter events. Sends back: filter events.";
    }

    public String getName() {
        return "Create Target";
    }

    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    public LocaleId getTargetLocale() {
        return this.targetLocale;
    }

    public Parameters getParameters() {
        return this.params;
    }

    public Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (tu.isTranslatable() || this.params.isCreateOnNonTranslatable()) {
            int copyOptions = 0;
            if (this.params.isCopyContent()) {
                copyOptions |= 5;
            }
            if (this.params.isCopyProperties()) {
                copyOptions |= 2;
            }
            tu.createTarget(this.targetLocale, this.params.isOverwriteExisting(), copyOptions);
        }
        return event;
    }
}

