/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.annotations.ConfigurationParameter;
import net.sf.okapi.common.pipeline.annotations.StepIntrospector;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.pipelinebuilder.XPipelineStep;
import net.sf.okapi.common.resource.MultiEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompoundStep
extends BasePipelineStep {
    protected LinkedList<IPipelineStep> steps = new LinkedList();
    private final LinkedList<List<ConfigurationParameter>> paramList;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected abstract void addStepsToList(List<IPipelineStep> var1);

    public AbstractCompoundStep() {
        this.paramList = new LinkedList();
        this.addStepsToList(this.steps);
        for (IPipelineStep step : this.steps) {
            if (step == null) {
                this.logger.error("Attempt to add null for an internal step.");
                continue;
            }
            step.setTargetLocale(this.getTargetLocale());
            step.setSourceLocale(this.getSourceLocale());
            List pList = null;
            pList = step instanceof XPipelineStep ? StepIntrospector.getStepParameters((IPipelineStep)((XPipelineStep)step).getStep()) : StepIntrospector.getStepParameters((IPipelineStep)step);
            this.paramList.add(pList);
        }
    }

    private Event expandEvent(Event event, IPipelineStep currentStep) {
        if (event.getEventType() == EventType.MULTI_EVENT && !((MultiEvent)event.getResource()).isPropagateAsSingleEvent()) {
            List remainingSteps = this.steps.subList(this.steps.indexOf(currentStep) + 1, this.steps.size());
            if (remainingSteps.size() == 0) {
                return event;
            }
            for (Event e : (MultiEvent)event.getResource()) {
                for (IPipelineStep remainingStep : remainingSteps) {
                    e = remainingStep.handleEvent(e);
                    e = this.expandEvent(e, remainingStep);
                }
            }
        }
        return event;
    }

    public Event handleEvent(Event event) {
        for (IPipelineStep step : this.steps) {
            event = super.handleEvent(event);
            step.setTargetLocale(this.getTargetLocale());
            step.setSourceLocale(this.getSourceLocale());
            event = step.handleEvent(event);
            event = this.expandEvent(event, step);
        }
        return event;
    }

    private void invokeParameterMethods(StepParameterType type, Object value) {
        for (List list : this.paramList) {
            for (ConfigurationParameter p : list) {
                Method method = p.getMethod();
                if (method == null || p.getParameterType() != type) continue;
                try {
                    method.invoke((Object)p.getStep(), value);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new OkapiException("Error when assigning runtime parameters.", (Throwable)e);
                }
            }
        }
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_ENCODING)
    public void setOutputEncoding(String outputEncoding) {
        this.invokeParameterMethods(StepParameterType.OUTPUT_ENCODING, outputEncoding);
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_URI)
    public void setInputUri(URI inputURI) {
        this.invokeParameterMethods(StepParameterType.INPUT_URI, inputURI);
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputUri(URI outputURI) {
        this.invokeParameterMethods(StepParameterType.OUTPUT_URI, outputURI);
    }
}

