/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common.tufiltering;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.common.tufiltering.MyTuFilter;
import net.sf.okapi.steps.common.tufiltering.Parameters;
import net.sf.okapi.steps.common.tufiltering.TuFilteringStep;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestTuFilteringStep {
    private TextUnit tu1;
    private TextUnit tu2;
    private TextUnit tu3;
    private Event tue1;
    private Event tue2;
    private Event tue3;
    private Event sbe;

    @Before
    public void startUp() {
        this.tu1 = new TextUnit("tu1");
        this.tu2 = new TextUnit("tu2");
        this.tu3 = new TextUnit("tu3");
        this.tue1 = new Event(EventType.TEXT_UNIT, (IResource)this.tu1);
        this.tue2 = new Event(EventType.TEXT_UNIT, (IResource)this.tu2);
        this.tue3 = new Event(EventType.TEXT_UNIT, (IResource)this.tu3);
        this.sbe = new Event(EventType.START_BATCH);
    }

    @Test
    public void testEmptyParameters() {
        TuFilteringStep tfs = new TuFilteringStep();
        try {
            tfs.handleEvent(this.sbe);
            tfs.handleEvent(this.tue1);
            tfs.handleEvent(this.tue2);
            tfs.handleEvent(this.tue3);
        }
        catch (Exception e) {
            return;
        }
        Assert.fail((String)"Exception should have been thrown");
    }

    @Test
    public void testNullParameters() {
        TuFilteringStep tfs = new TuFilteringStep();
        tfs.setParameters(null);
        try {
            tfs.handleEvent(this.sbe);
            tfs.handleEvent(this.tue1);
            tfs.handleEvent(this.tue2);
            tfs.handleEvent(this.tue3);
        }
        catch (Exception e) {
            return;
        }
        Assert.fail((String)"Exception should have been thrown");
    }

    @Test
    public void testDefaultFiltering() {
        TuFilteringStep tfs = new TuFilteringStep(tu -> false);
        Assert.assertTrue((boolean)this.tu1.isTranslatable());
        Assert.assertTrue((boolean)this.tu2.isTranslatable());
        Assert.assertTrue((boolean)this.tu3.isTranslatable());
        tfs.handleEvent(this.sbe);
        tfs.handleEvent(this.tue1);
        tfs.handleEvent(this.tue2);
        tfs.handleEvent(this.tue3);
        Assert.assertTrue((boolean)this.tu1.isTranslatable());
        Assert.assertTrue((boolean)this.tu2.isTranslatable());
        Assert.assertTrue((boolean)this.tu3.isTranslatable());
    }

    @Test
    public void testCustomFiltering() {
        TuFilteringStep tfs = new TuFilteringStep(tu -> "tu1".equals(tu.getId()) || "tu3".equals(tu.getId()));
        tfs.handleEvent(this.sbe);
        tfs.handleEvent(this.tue1);
        tfs.handleEvent(this.tue2);
        tfs.handleEvent(this.tue3);
        Assert.assertFalse((boolean)this.tu1.isTranslatable());
        Assert.assertTrue((boolean)this.tu2.isTranslatable());
        Assert.assertFalse((boolean)this.tu3.isTranslatable());
    }

    @Test
    public void testCustomFiltering_with_params() {
        TuFilteringStep tfs = new TuFilteringStep();
        Parameters params = tfs.getParameters();
        params.setTuFilterClassName(MyTuFilter.class.getName());
        tfs.handleEvent(this.sbe);
        tfs.handleEvent(this.tue1);
        tfs.handleEvent(this.tue2);
        tfs.handleEvent(this.tue3);
        Assert.assertTrue((boolean)this.tu1.isTranslatable());
        Assert.assertFalse((boolean)this.tu2.isTranslatable());
        Assert.assertTrue((boolean)this.tu3.isTranslatable());
    }
}

