/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common.removetarget;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.common.removetarget.Parameters;
import net.sf.okapi.steps.common.removetarget.RemoveTargetStep;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestRemoveTargetStep {
    @Test
    public void testRemoveInAll() {
        RemoveTargetStep rts = new RemoveTargetStep();
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSourceContent(new TextFragment("Source"));
        tu1.setTargetContent(LocaleId.GERMAN, new TextFragment("target de-de"));
        tu1.setTargetContent(LocaleId.FRENCH, new TextFragment("target fr-fr"));
        tu1.setTargetContent(LocaleId.ITALIAN, new TextFragment("target it-it"));
        Event sbe = new Event(EventType.START_BATCH);
        Event tue = new Event(EventType.TEXT_UNIT, (IResource)tu1);
        Assert.assertNotNull((Object)tu1.getTarget(LocaleId.GERMAN));
        Assert.assertFalse((boolean)tu1.getTarget(LocaleId.GERMAN).isEmpty());
        Assert.assertNotNull((Object)tu1.getTarget(LocaleId.FRENCH));
        Assert.assertFalse((boolean)tu1.getTarget(LocaleId.FRENCH).isEmpty());
        Assert.assertNotNull((Object)tu1.getTarget(LocaleId.ITALIAN));
        Assert.assertFalse((boolean)tu1.getTarget(LocaleId.ITALIAN).isEmpty());
        rts.handleEvent(sbe);
        rts.handleEvent(tue);
        Assert.assertTrue((tu1.getTarget(LocaleId.GERMAN) == null ? 1 : 0) != 0);
        Assert.assertTrue((tu1.getTarget(LocaleId.FRENCH) == null ? 1 : 0) != 0);
        Assert.assertTrue((tu1.getTarget(LocaleId.ITALIAN) == null ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveInSelected() {
        RemoveTargetStep rts = new RemoveTargetStep();
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSourceContent(new TextFragment("Source"));
        tu1.setTargetContent(LocaleId.GERMAN, new TextFragment("target de-de"));
        tu1.setTargetContent(LocaleId.FRENCH, new TextFragment("target fr-fr"));
        tu1.setTargetContent(LocaleId.ITALIAN, new TextFragment("target it-it"));
        TextUnit tu2 = new TextUnit("tu2");
        tu2.setSourceContent(new TextFragment("Source"));
        tu2.setTargetContent(LocaleId.GERMAN, new TextFragment("target de-de"));
        tu2.setTargetContent(LocaleId.FRENCH, new TextFragment("target fr-fr"));
        tu2.setTargetContent(LocaleId.ITALIAN, new TextFragment("target it-it"));
        TextUnit tu3 = new TextUnit("tu3");
        tu3.setSourceContent(new TextFragment("Source"));
        tu3.setTargetContent(LocaleId.GERMAN, new TextFragment("target de-de"));
        tu3.setTargetContent(LocaleId.FRENCH, new TextFragment("target fr-fr"));
        tu3.setTargetContent(LocaleId.ITALIAN, new TextFragment("target it-it"));
        Event sbe = new Event(EventType.START_BATCH);
        Parameters params = rts.getParameters();
        params.setTusForTargetRemoval("tu1, tu3");
        Event tue1 = new Event(EventType.TEXT_UNIT, (IResource)tu1);
        Event tue2 = new Event(EventType.TEXT_UNIT, (IResource)tu2);
        Event tue3 = new Event(EventType.TEXT_UNIT, (IResource)tu3);
        Assert.assertNotNull((Object)tu1.getTarget(LocaleId.GERMAN));
        Assert.assertFalse((boolean)tu1.getTarget(LocaleId.GERMAN).isEmpty());
        Assert.assertNotNull((Object)tu1.getTarget(LocaleId.FRENCH));
        Assert.assertFalse((boolean)tu1.getTarget(LocaleId.FRENCH).isEmpty());
        Assert.assertNotNull((Object)tu1.getTarget(LocaleId.ITALIAN));
        Assert.assertFalse((boolean)tu1.getTarget(LocaleId.ITALIAN).isEmpty());
        rts.handleEvent(sbe);
        rts.handleEvent(tue1);
        rts.handleEvent(tue2);
        rts.handleEvent(tue3);
        Assert.assertTrue((tu1.getTarget(LocaleId.GERMAN) == null ? 1 : 0) != 0);
        Assert.assertTrue((tu1.getTarget(LocaleId.FRENCH) == null ? 1 : 0) != 0);
        Assert.assertTrue((tu1.getTarget(LocaleId.ITALIAN) == null ? 1 : 0) != 0);
        Assert.assertNotNull((Object)tu2.getTarget(LocaleId.GERMAN));
        Assert.assertFalse((boolean)tu2.getTarget(LocaleId.GERMAN).isEmpty());
        Assert.assertNotNull((Object)tu2.getTarget(LocaleId.FRENCH));
        Assert.assertFalse((boolean)tu2.getTarget(LocaleId.FRENCH).isEmpty());
        Assert.assertNotNull((Object)tu2.getTarget(LocaleId.ITALIAN));
        Assert.assertFalse((boolean)tu2.getTarget(LocaleId.ITALIAN).isEmpty());
        Assert.assertTrue((tu3.getTarget(LocaleId.GERMAN) == null ? 1 : 0) != 0);
        Assert.assertTrue((tu3.getTarget(LocaleId.FRENCH) == null ? 1 : 0) != 0);
        Assert.assertTrue((tu3.getTarget(LocaleId.ITALIAN) == null ? 1 : 0) != 0);
    }
}

