/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common.codesimplifier;

import java.util.ArrayList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.lib.segmentation.LanguageMap;
import net.sf.okapi.lib.segmentation.Rule;
import net.sf.okapi.lib.segmentation.SRXDocument;
import net.sf.okapi.steps.common.codesimplifier.Parameters;
import net.sf.okapi.steps.common.codesimplifier.PostSegmentationCodeSimplifierStep;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestPostSegmentationCodeSimplifierStep {
    private GenericContent fmt;
    private PostSegmentationCodeSimplifierStep css;
    private static final LocaleId EN = new LocaleId("en", "us");
    private ISegmenter segmenter;

    @Before
    public void setup() {
        this.css = new PostSegmentationCodeSimplifierStep();
        this.fmt = new GenericContent();
        this.segmenter = this.createSegmenterWithRules(EN);
    }

    @Test
    public void testDefaults() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x4/>");
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T2");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x5/>");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x6", "<x6/>");
        Assert.assertEquals((Object)"<1/>   <2/>T1<3/><4/><5>T2   </5>   <e8/><6/>   <7/>", (Object)this.fmt.setContent(tf).toString());
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSourceContent(tf);
        tu1.createSourceSegmentation(this.segmenter);
        ISkeleton skel = tu1.getSkeleton();
        Assert.assertNull((Object)skel);
        Event tue1 = new Event(EventType.TEXT_UNIT, (IResource)tu1);
        this.css.handleEvent(tue1);
        tf = tu1.getSource().getUnSegmentedContentCopy();
        Assert.assertEquals((Object)"<1/>   <2/>T1<5>T2   </5>   <e8/><6/>   <7/>", (Object)this.fmt.setContent(tf).toString());
        skel = tu1.getSkeleton();
        Assert.assertNull((Object)skel);
    }

    @Test
    public void testDefaults2() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x4/>");
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T2");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x5/>");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x6", "<x6/>");
        Assert.assertEquals((Object)"<1/>   <2/>T1<3/><4/><5>T2   </5>   <e8/><6/>   <7/>", (Object)this.fmt.setContent(tf).toString());
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSourceContent(tf);
        tu1.createSourceSegmentation(this.segmenter);
        GenericSkeleton skel = new GenericSkeleton();
        Assert.assertNotNull((Object)skel);
        tu1.setSkeleton((ISkeleton)skel);
        Assert.assertNotNull((Object)tu1.getSkeleton());
        Event tue1 = new Event(EventType.TEXT_UNIT, (IResource)tu1);
        this.css.handleEvent(tue1);
        tf = tu1.getSource().getSegments().getFirstContent();
        Assert.assertEquals((Object)"T1<5>T2   </5>", (Object)this.fmt.setContent(tf).toString());
        skel = tu1.getSkeleton();
        Assert.assertTrue((boolean)skel.toString().isEmpty());
    }

    @Test
    public void testNoRemoval() {
        Parameters params = this.css.getParameters();
        params.setRemoveLeadingTrailingCodes(false);
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x4/>");
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T2");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x5/>");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x6", "<x6/>");
        Assert.assertEquals((Object)"<1/>   <2/>T1<3/><4/><5>T2   </5>   <e8/><6/>   <7/>", (Object)this.fmt.setContent(tf).toString());
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSourceContent(tf);
        tu1.createSourceSegmentation(this.segmenter);
        ISkeleton skel = tu1.getSkeleton();
        Assert.assertNull((Object)skel);
        Event tue1 = new Event(EventType.TEXT_UNIT, (IResource)tu1);
        this.css.handleEvent(tue1);
        tf = tu1.getSource().getUnSegmentedContentCopy();
        Assert.assertEquals((Object)"<1/>   <2/>T1<5>T2   </5>   <e8/>   <7/>", (Object)this.fmt.setContent(tf).toString());
        skel = tu1.getSkeleton();
        Assert.assertNull((Object)skel);
    }

    private ISegmenter createSegmenterWithRules(LocaleId locId) {
        SRXDocument doc = new SRXDocument();
        LanguageMap langMap = new LanguageMap(".*", "default");
        doc.addLanguageMap(langMap);
        ArrayList<Rule> langRules = new ArrayList<Rule>();
        langRules.add(new Rule("\\.", "\\s", true));
        doc.addLanguageRule("default", langRules);
        return doc.compileLanguageRules(locId, null);
    }
}

