/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.Pipeline;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.common.ExtractionVerificationStep;
import net.sf.okapi.steps.common.ExtractionVerificationStepParameters;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ExtractionVerificationStepTest {
    private Pipeline pipeline;
    private ExtractionVerificationStep verifier;
    private final FileLocation pathBase = FileLocation.fromClass(this.getClass());

    @Before
    public void setUp() throws Exception {
        this.pipeline = new Pipeline();
        this.verifier = new ExtractionVerificationStep();
        this.pipeline.addStep((IPipelineStep)this.verifier);
    }

    public void setUpFilter(boolean compareSkeleton, String configurationId) {
        ExtractionVerificationStepParameters p = new ExtractionVerificationStepParameters();
        p.setCompareSkeleton(compareSkeleton);
        this.verifier.setParameters((IParameters)p);
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
        fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        fcMapper.addConfigurations("net.sf.okapi.filters.tmx.TmxFilter");
        this.verifier.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        this.verifier.setFilterConfigurationId(configurationId);
    }

    @After
    public void tearDown() throws Exception {
        this.pipeline.destroy();
    }

    @Test
    public void testExtractionVerificationTmx() {
        this.setUpFilter(true, "okf_tmx");
        this.pipeline.startBatch();
        this.pipeline.process(new RawDocument(this.pathBase.in("html_test.tmx").asUri(), "UTF-8", LocaleId.fromBCP47((String)"en-US"), LocaleId.fromBCP47((String)"fr-FR")));
        this.pipeline.process(new RawDocument(this.pathBase.in("ImportTest2A.tmx").asUri(), "UTF-8", LocaleId.fromBCP47((String)"en-US"), LocaleId.fromBCP47((String)"fr-CA")));
        this.pipeline.process(new RawDocument(this.pathBase.in("ImportTest2B.tmx").asUri(), "UTF-8", LocaleId.fromBCP47((String)"en-US"), LocaleId.fromBCP47((String)"fr-CA")));
        this.pipeline.process(new RawDocument(this.pathBase.in("ImportTest2C.tmx").asUri(), "UTF-8", LocaleId.fromBCP47((String)"en-US"), LocaleId.fromBCP47((String)"fr-FR")));
        this.pipeline.endBatch();
    }

    @Test
    public void testExtractionVerificationHtml() {
        this.setUpFilter(true, "okf_html");
        this.pipeline.startBatch();
        this.pipeline.process(new RawDocument(this.pathBase.in("aa324.html").asUri(), "UTF-8", LocaleId.ENGLISH));
        this.pipeline.process(new RawDocument(this.pathBase.in("form.html").asUri(), "UTF-8", LocaleId.ENGLISH));
        this.pipeline.process(new RawDocument(this.pathBase.in("W3CHTMHLTest1.html").asUri(), "UTF-8", LocaleId.ENGLISH));
        this.pipeline.endBatch();
    }

    @Test
    public void testExtractionVerificationXlf() {
        this.setUpFilter(false, "okf_xliff");
        this.pipeline.startBatch();
        this.pipeline.process(new RawDocument(this.pathBase.in("test1_es.xlf").asUri(), "UTF-8", LocaleId.ENGLISH, LocaleId.SPANISH));
        this.pipeline.process(new RawDocument(this.pathBase.in("test2_es.xlf").asUri(), "UTF-8", LocaleId.fromBCP47((String)"en-US"), LocaleId.fromBCP47((String)"es-ES")));
        this.pipeline.process(new RawDocument(this.pathBase.in("RB-11-Test01.xlf").asUri(), "UTF-8", LocaleId.ENGLISH, LocaleId.SPANISH));
        this.pipeline.process(new RawDocument(this.pathBase.in("SF-12-Test01.xlf").asUri(), "UTF-8", LocaleId.ENGLISH, LocaleId.FRENCH));
        this.pipeline.process(new RawDocument(this.pathBase.in("SF-12-Test02.xlf").asUri(), "UTF-8", LocaleId.ENGLISH, LocaleId.FRENCH));
        this.pipeline.process(new RawDocument(this.pathBase.in("SF-12-Test03.xlf").asUri(), "UTF-8", LocaleId.ENGLISH, LocaleId.SPANISH));
        this.pipeline.process(new RawDocument(this.pathBase.in("BinUnitTest01.xlf").asUri(), "UTF-8", LocaleId.ENGLISH, LocaleId.SPANISH));
        this.pipeline.process(new RawDocument(this.pathBase.in("JMP-11-Test01.xlf").asUri(), "UTF-8", LocaleId.ENGLISH, LocaleId.SPANISH));
        this.pipeline.process(new RawDocument(this.pathBase.in("Manual-12-AltTrans.xlf").asUri(), "UTF-8", LocaleId.ENGLISH, LocaleId.SPANISH));
        this.pipeline.endBatch();
    }
}

