/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tests;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.tests.CaptureStep;

public class StepTestDriver {
    private PipelineDriver driver;
    private RawDocumentToFilterEventsStep filterStep;
    private CaptureStep captureStep;
    private FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
    private RawDocument rawDoc;

    public StepTestDriver() {
        this.fcMapper.addConfigurations("net.sf.okapi.common.filters.DummyFilter");
        this.driver = new PipelineDriver();
        this.driver.setFilterConfigurationMapper((IFilterConfigurationMapper)this.fcMapper);
        this.captureStep = new CaptureStep();
        this.filterStep = new RawDocumentToFilterEventsStep();
    }

    public void prepareFilterEventsStep(String srcText, String trgText, LocaleId srcLoc, LocaleId trgLoc) {
        StringBuilder sb = new StringBuilder();
        sb.append(srcText);
        if (trgText != null) {
            sb.append("\n");
            sb.append(trgText);
        }
        this.rawDoc = new RawDocument((CharSequence)sb.toString(), srcLoc, trgLoc);
        this.rawDoc.setFilterConfigId("okf_dummy");
    }

    public ITextUnit getResult() {
        return this.captureStep.getLastTextUnit();
    }

    public void testFilterEventsStep(IPipelineStep step) {
        this.driver.clearItems();
        this.driver.getPipeline().getSteps().clear();
        this.driver.addStep((IPipelineStep)this.filterStep);
        this.driver.addStep(step);
        this.captureStep.reset();
        this.driver.addStep((IPipelineStep)this.captureStep);
        this.driver.addBatchItem(this.rawDoc, null, null);
        this.driver.processBatch();
    }
}

