/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.BaseNameable;
import net.sf.okapi.common.resource.BaseReferenceable;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.IMultilingual;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.IReferenceable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.InlineAnnotation;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.steps.common.ExtractionVerificationUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ExtractionVerificationUtilTest {
    ExtractionVerificationUtil util;

    @Before
    public void setUp() throws Exception {
        this.util = new ExtractionVerificationUtil();
    }

    @Test
    public void testBaseReferenceable() {
        DocumentPart dp1 = null;
        DocumentPart dp2 = null;
        Assert.assertTrue((boolean)this.util.compareBaseReferenceable(dp1, dp2));
        dp1 = new DocumentPart("dp1", false);
        Assert.assertFalse((boolean)this.util.compareBaseReferenceable((BaseReferenceable)dp1, dp2));
        dp2 = new DocumentPart("dp1", false);
        Assert.assertTrue((boolean)this.util.compareBaseReferenceable((BaseReferenceable)dp1, (BaseReferenceable)dp2));
        dp1.setParentId("p1");
        Assert.assertFalse((boolean)this.util.compareBaseReferenceable((BaseReferenceable)dp1, (BaseReferenceable)dp2));
        dp2.setParentId("p2");
        Assert.assertFalse((boolean)this.util.compareBaseReferenceable((BaseReferenceable)dp1, (BaseReferenceable)dp2));
        dp2.setParentId("p1");
        Assert.assertTrue((boolean)this.util.compareBaseReferenceable((BaseReferenceable)dp1, (BaseReferenceable)dp2));
    }

    @Test
    public void testTextUnits() {
        TextUnit tu1 = null;
        TextUnit tu2 = null;
        Assert.assertTrue((boolean)this.util.compareTextUnits(tu1, tu2));
        tu1 = new TextUnit("tu1");
        Assert.assertFalse((boolean)this.util.compareTextUnits((ITextUnit)tu1, tu2));
        tu2 = new TextUnit("tu1");
        Assert.assertTrue((boolean)this.util.compareTextUnits((ITextUnit)tu1, (ITextUnit)tu2));
        tu1.setName("tu name 1");
        Assert.assertFalse((boolean)this.util.compareTextUnits((ITextUnit)tu1, (ITextUnit)tu2));
        tu2.setName("tu name 2");
        Assert.assertFalse((boolean)this.util.compareTextUnits((ITextUnit)tu1, (ITextUnit)tu2));
        tu2.setName("tu name 1");
        Assert.assertTrue((boolean)this.util.compareTextUnits((ITextUnit)tu1, (ITextUnit)tu2));
        tu2.setId("tu 1b");
        Assert.assertFalse((boolean)this.util.compareTextUnits((ITextUnit)tu1, (ITextUnit)tu2));
        tu1 = new TextUnit("tu1", "src 1");
        tu2 = new TextUnit("tu1");
        Assert.assertFalse((boolean)this.util.compareTextUnits((ITextUnit)tu1, (ITextUnit)tu2));
        tu2 = new TextUnit("tu1", "src 2");
        Assert.assertFalse((boolean)this.util.compareTextUnits((ITextUnit)tu1, (ITextUnit)tu2));
        tu1 = new TextUnit("tu", "src");
        tu2 = new TextUnit("tu", "src");
        tu1.createTarget(LocaleId.FRENCH, true, 7);
        Assert.assertFalse((boolean)this.util.compareTextUnits((ITextUnit)tu1, (ITextUnit)tu2));
        tu2.createTarget(LocaleId.FRENCH, true, 7);
        Assert.assertTrue((boolean)this.util.compareTextUnits((ITextUnit)tu1, (ITextUnit)tu2));
    }

    @Test
    public void testTextContainers() {
        TextContainer tc1 = null;
        TextContainer tc2 = null;
        Assert.assertTrue((boolean)this.util.compareTextContainers(tc1, tc2));
        tc1 = new TextContainer();
        Assert.assertFalse((boolean)this.util.compareTextContainers(tc1, tc2));
        tc2 = new TextContainer();
        Assert.assertTrue((boolean)this.util.compareTextContainers(tc1, tc2));
        tc1.setHasBeenSegmentedFlag(true);
        tc2.setHasBeenSegmentedFlag(false);
        Assert.assertFalse((boolean)this.util.compareTextContainers(tc1, tc2));
        tc2.setHasBeenSegmentedFlag(true);
        tc1.setProperty(new Property("name", "value1"));
        Assert.assertFalse((boolean)this.util.compareTextContainers(tc1, tc2));
        tc2.setProperty(new Property("name", "value2"));
        Assert.assertFalse((boolean)this.util.compareTextContainers(tc1, tc2));
        tc2.setProperty(new Property("name", "value1"));
        Assert.assertTrue((boolean)this.util.compareTextContainers(tc1, tc2));
        tc1.append((TextPart)new Segment("seg1", new TextFragment("Hello")));
        tc1.append((TextPart)new Segment("seg2", new TextFragment(" world")));
        Assert.assertFalse((boolean)this.util.compareTextContainers(tc1, tc2));
        tc2.append((TextPart)new Segment("seg1", new TextFragment("Hello 2")));
        tc2.append((TextPart)new Segment("seg2", new TextFragment(" world 2")));
        Assert.assertFalse((boolean)this.util.compareTextContainers(tc1, tc2));
    }

    @Test
    public void testCompareSegments() {
        Segment seg1 = null;
        Segment seg2 = null;
        Assert.assertTrue((boolean)this.util.compareSegments(seg1, seg2));
        seg1 = new Segment();
        Assert.assertFalse((boolean)this.util.compareSegments(seg1, seg2));
        seg2 = new Segment();
        Assert.assertTrue((boolean)this.util.compareSegments(seg1, seg2));
        seg1 = new Segment("id1");
        Assert.assertFalse((boolean)this.util.compareSegments(seg1, seg2));
        seg2 = new Segment("id2");
        Assert.assertFalse((boolean)this.util.compareSegments(seg1, seg2));
        seg2 = new Segment("id1");
        Assert.assertTrue((boolean)this.util.compareSegments(seg1, seg2));
        seg1 = new Segment("id1", new TextFragment("Text 1"));
        Assert.assertFalse((boolean)this.util.compareSegments(seg1, seg2));
        seg2 = new Segment("id1", new TextFragment("Text 2"));
        Assert.assertFalse((boolean)this.util.compareSegments(seg1, seg2));
    }

    @Test
    public void testCompareTextParts() {
        TextPart tp1 = null;
        TextPart tp2 = null;
        Assert.assertTrue((boolean)this.util.compareTextParts(tp1, tp2));
        tp1 = new TextPart();
        Assert.assertFalse((boolean)this.util.compareTextParts(tp1, tp2));
        tp2 = new TextPart();
        Assert.assertTrue((boolean)this.util.compareTextParts(tp1, tp2));
    }

    @Test
    public void testCompareTextFragments() {
        TextFragment tf1 = null;
        TextFragment tf2 = null;
        Assert.assertTrue((boolean)this.util.compareTextFragments(tf1, tf2));
        tf1 = new TextFragment();
        Assert.assertFalse((boolean)this.util.compareTextFragments(tf1, tf2));
        tf2 = new TextFragment();
        Assert.assertTrue((boolean)this.util.compareTextFragments(tf1, tf2));
        tf1.append("text");
        Assert.assertFalse((boolean)this.util.compareTextFragments(tf1, tf2));
        tf2.append("text");
        Assert.assertTrue((boolean)this.util.compareTextFragments(tf1, tf2));
        Code code1 = new Code(TextFragment.TagType.PLACEHOLDER, "br", "data");
        Code code2 = new Code(TextFragment.TagType.PLACEHOLDER, "br", "data");
        tf1.append(code1);
        Assert.assertFalse((boolean)this.util.compareTextFragments(tf1, tf2));
        tf2.append(code2);
        Assert.assertTrue((boolean)this.util.compareTextFragments(tf1, tf2));
        code1.setId(2);
        Assert.assertFalse((boolean)this.util.compareTextFragments(tf1, tf2));
        code2.setId(2);
        Assert.assertTrue((boolean)this.util.compareTextFragments(tf1, tf2));
        code1.setData("data2");
        Assert.assertFalse((boolean)this.util.compareTextFragments(tf1, tf2));
        code2.setData("data2");
        Assert.assertTrue((boolean)this.util.compareTextFragments(tf1, tf2));
        code1.setOuterData("outdata2");
        Assert.assertFalse((boolean)this.util.compareTextFragments(tf1, tf2));
        code2.setOuterData("outdata2");
        Assert.assertTrue((boolean)this.util.compareTextFragments(tf1, tf2));
        code1.setType("it");
        Assert.assertFalse((boolean)this.util.compareTextFragments(tf1, tf2));
        code2.setType("it");
        Assert.assertTrue((boolean)this.util.compareTextFragments(tf1, tf2));
        code1.setTagType(TextFragment.TagType.OPENING);
        Assert.assertFalse((boolean)this.util.compareTextFragments(tf1, tf2));
        code2.setTagType(TextFragment.TagType.OPENING);
        Assert.assertTrue((boolean)this.util.compareTextFragments(tf1, tf2));
        code1.setReferenceFlag(true);
        code2.setReferenceFlag(false);
        Assert.assertFalse((boolean)this.util.compareTextFragments(tf1, tf2));
        code2.setReferenceFlag(true);
        Assert.assertTrue((boolean)this.util.compareTextFragments(tf1, tf2));
        code1.setCloneable(true);
        code2.setCloneable(false);
        Assert.assertFalse((boolean)this.util.compareTextFragments(tf1, tf2));
        code2.setCloneable(true);
        Assert.assertTrue((boolean)this.util.compareTextFragments(tf1, tf2));
        code1.setDeleteable(true);
        code2.setDeleteable(false);
        Assert.assertFalse((boolean)this.util.compareTextFragments(tf1, tf2));
        code2.setDeleteable(true);
        Assert.assertTrue((boolean)this.util.compareTextFragments(tf1, tf2));
        code1.setAnnotation("annotation", new InlineAnnotation("inlineAnnotation"));
        Assert.assertFalse((boolean)this.util.compareTextFragments(tf1, tf2));
        code2.setAnnotation("annotation", new InlineAnnotation("inlineAnnotation two"));
        Assert.assertFalse((boolean)this.util.compareTextFragments(tf1, tf2));
    }

    @Test
    public void testCompareINameables() {
        BaseNameable bn1 = null;
        BaseNameable bn2 = null;
        Assert.assertTrue((boolean)this.util.compareINameables(bn1, bn2));
        bn1 = new BaseNameable();
        Assert.assertFalse((boolean)this.util.compareINameables((INameable)bn1, bn2));
        bn2 = new BaseNameable();
        Assert.assertTrue((boolean)this.util.compareINameables((INameable)bn1, (INameable)bn2));
        bn1.setName("name");
        Assert.assertFalse((boolean)this.util.compareINameables((INameable)bn1, (INameable)bn2));
        bn2.setName("name");
        Assert.assertTrue((boolean)this.util.compareINameables((INameable)bn1, (INameable)bn2));
        bn2.setType("type");
        Assert.assertFalse((boolean)this.util.compareINameables((INameable)bn1, (INameable)bn2));
        bn1.setType("type");
        Assert.assertTrue((boolean)this.util.compareINameables((INameable)bn1, (INameable)bn2));
        bn1.setMimeType("mimetype");
        Assert.assertFalse((boolean)this.util.compareINameables((INameable)bn1, (INameable)bn2));
        bn2.setMimeType("mimetype");
        Assert.assertTrue((boolean)this.util.compareINameables((INameable)bn1, (INameable)bn2));
        bn2.setIsTranslatable(false);
        Assert.assertFalse((boolean)this.util.compareINameables((INameable)bn1, (INameable)bn2));
        bn1.setIsTranslatable(false);
        Assert.assertTrue((boolean)this.util.compareINameables((INameable)bn1, (INameable)bn2));
        bn2.setPreserveWhitespaces(true);
        Assert.assertFalse((boolean)this.util.compareINameables((INameable)bn1, (INameable)bn2));
        bn1.setPreserveWhitespaces(true);
        Assert.assertTrue((boolean)this.util.compareINameables((INameable)bn1, (INameable)bn2));
        bn1.setProperty(new Property("name1", "value1"));
        Assert.assertFalse((boolean)this.util.compareINameables((INameable)bn1, (INameable)bn2));
        bn2.setProperty(new Property("name1", "value1"));
        Assert.assertTrue((boolean)this.util.compareINameables((INameable)bn1, (INameable)bn2));
        bn1.setProperty(new Property("name2", "value2"));
        bn2.setProperty(new Property("name3", "value3"));
        Assert.assertFalse((boolean)this.util.compareINameables((INameable)bn1, (INameable)bn2));
        bn2.setProperty(new Property("name2", "value2"));
        bn1.setProperty(new Property("name3", "value3"));
        bn2.setProperty(new Property("name4", "value4a"));
        bn1.setProperty(new Property("name4", "value4b"));
        Assert.assertFalse((boolean)this.util.compareINameables((INameable)bn1, (INameable)bn2));
        bn1.setProperty(new Property("name4", "value4a"));
        Assert.assertTrue((boolean)this.util.compareINameables((INameable)bn1, (INameable)bn2));
    }

    @Test
    public void testCompareIMultilingualResource() {
        TextUnit bn1 = new TextUnit();
        TextUnit bn2 = new TextUnit();
        bn2.setSourceProperty(new Property("name1", "value1"));
        Assert.assertFalse((boolean)this.util.compareIMultilingual((IMultilingual)bn1, (IMultilingual)bn2));
        bn1.setSourceProperty(new Property("name1", "value1"));
        Assert.assertTrue((boolean)this.util.compareIMultilingual((IMultilingual)bn1, (IMultilingual)bn2));
        bn2.setSourceProperty(new Property("name2", "value2"));
        bn1.setSourceProperty(new Property("name3", "value3"));
        Assert.assertFalse((boolean)this.util.compareIMultilingual((IMultilingual)bn1, (IMultilingual)bn2));
        bn1.setSourceProperty(new Property("name2", "value2"));
        bn2.setSourceProperty(new Property("name3", "value3"));
        bn1.setSourceProperty(new Property("name4", "value4a"));
        bn2.setSourceProperty(new Property("name4", "value4b"));
        Assert.assertFalse((boolean)this.util.compareIMultilingual((IMultilingual)bn1, (IMultilingual)bn2));
        bn2.setSourceProperty(new Property("name4", "value4a"));
        Assert.assertTrue((boolean)this.util.compareIMultilingual((IMultilingual)bn1, (IMultilingual)bn2));
        bn1.createTargetProperty(LocaleId.FRENCH, "name", true, 0);
        Assert.assertFalse((boolean)this.util.compareIMultilingual((IMultilingual)bn1, (IMultilingual)bn2));
        bn2.createTargetProperty(LocaleId.FRENCH, "name", true, 0);
        Assert.assertTrue((boolean)this.util.compareIMultilingual((IMultilingual)bn1, (IMultilingual)bn2));
        bn1.createTargetProperty(LocaleId.GERMAN, "name", true, 0);
        Assert.assertFalse((boolean)this.util.compareIMultilingual((IMultilingual)bn1, (IMultilingual)bn2));
        bn2.createTargetProperty(LocaleId.GERMAN, "name", true, 0);
        Assert.assertTrue((boolean)this.util.compareIMultilingual((IMultilingual)bn1, (IMultilingual)bn2));
        bn1.setTargetProperty(LocaleId.FRENCH, new Property("name1", "value1"));
        Assert.assertFalse((boolean)this.util.compareIMultilingual((IMultilingual)bn1, (IMultilingual)bn2));
        bn2.setTargetProperty(LocaleId.FRENCH, new Property("name1", "value1"));
        Assert.assertTrue((boolean)this.util.compareIMultilingual((IMultilingual)bn1, (IMultilingual)bn2));
        bn2.setTargetProperty(LocaleId.FRENCH, new Property("name2", "value2"));
        bn1.setTargetProperty(LocaleId.FRENCH, new Property("name3", "value3"));
        Assert.assertFalse((boolean)this.util.compareIMultilingual((IMultilingual)bn1, (IMultilingual)bn2));
        bn1.setTargetProperty(LocaleId.FRENCH, new Property("name2", "value2"));
        bn2.setTargetProperty(LocaleId.FRENCH, new Property("name3", "value3"));
        bn1.setTargetProperty(LocaleId.FRENCH, new Property("name4", "value4a"));
        bn2.setTargetProperty(LocaleId.FRENCH, new Property("name4", "value4b"));
        Assert.assertFalse((boolean)this.util.compareIMultilingual((IMultilingual)bn1, (IMultilingual)bn2));
        bn2.setTargetProperty(LocaleId.FRENCH, new Property("name4", "value4a"));
        Assert.assertTrue((boolean)this.util.compareIMultilingual((IMultilingual)bn1, (IMultilingual)bn2));
    }

    @Test
    public void testCompareIResources() {
        BaseNameable bn1 = null;
        BaseNameable bn2 = null;
        GenericSkeleton gs1 = new GenericSkeleton();
        GenericSkeleton gs2 = new GenericSkeleton();
        Assert.assertTrue((boolean)this.util.compareIResources(bn1, bn2));
        bn1 = new BaseNameable();
        Assert.assertFalse((boolean)this.util.compareIResources((IResource)bn1, bn2));
        bn2 = new BaseNameable();
        Assert.assertTrue((boolean)this.util.compareIResources((IResource)bn1, (IResource)bn2));
        bn1.setId("bn");
        Assert.assertFalse((boolean)this.util.compareIResources((IResource)bn1, (IResource)bn2));
        bn2.setId("bn");
        Assert.assertTrue((boolean)this.util.compareIResources((IResource)bn1, (IResource)bn2));
        bn1.setSkeleton((ISkeleton)gs1);
        Assert.assertFalse((boolean)this.util.compareIResources((IResource)bn1, (IResource)bn2));
        bn2.setSkeleton((ISkeleton)gs2);
        Assert.assertTrue((boolean)this.util.compareIResources((IResource)bn1, (IResource)bn2));
        gs1.add("gs");
        Assert.assertFalse((boolean)this.util.compareIResources((IResource)bn1, (IResource)bn2));
        gs2.add("gs different");
        Assert.assertFalse((boolean)this.util.compareIResources((IResource)bn1, (IResource)bn2));
        gs1.add(" different");
        Assert.assertTrue((boolean)this.util.compareIResources((IResource)bn1, (IResource)bn2));
    }

    @Test
    public void testCompareIReferenceables() {
        BaseReferenceable br1 = null;
        BaseReferenceable br2 = null;
        Assert.assertTrue((boolean)this.util.compareIReferenceables(br1, br2));
        br1 = new BaseReferenceable();
        Assert.assertFalse((boolean)this.util.compareIReferenceables((IReferenceable)br1, br2));
        br1.setIsReferent(true);
        br2 = new BaseReferenceable();
        br2.setIsReferent(false);
        Assert.assertFalse((boolean)this.util.compareIReferenceables((IReferenceable)br1, (IReferenceable)br2));
        br2.setIsReferent(true);
        Assert.assertTrue((boolean)this.util.compareIReferenceables((IReferenceable)br1, (IReferenceable)br2));
        br1.setReferenceCount(2);
        Assert.assertFalse((boolean)this.util.compareIReferenceables((IReferenceable)br1, (IReferenceable)br2));
        br2.setReferenceCount(2);
        Assert.assertTrue((boolean)this.util.compareIReferenceables((IReferenceable)br1, (IReferenceable)br2));
    }

    @Test
    public void testCompareProperties() {
        Property p1 = null;
        Property p2 = null;
        Assert.assertTrue((boolean)this.util.compareProperties(p1, p2));
        p1 = new Property(null, null);
        Assert.assertFalse((boolean)this.util.compareProperties(p1, p2));
        p2 = new Property(null, null);
        Assert.assertTrue((boolean)this.util.compareProperties(p1, p2));
        p2 = new Property("name", null);
        Assert.assertFalse((boolean)this.util.compareProperties(p1, p2));
        p1 = new Property("name", null);
        Assert.assertTrue((boolean)this.util.compareProperties(p1, p2));
        p1 = new Property("name", "value");
        Assert.assertFalse((boolean)this.util.compareProperties(p1, p2));
        p2 = new Property("name", "value");
        Assert.assertTrue((boolean)this.util.compareProperties(p1, p2));
        p1 = new Property("name", "value", false);
        Assert.assertFalse((boolean)this.util.compareProperties(p1, p2));
        p2 = new Property("name", "value", false);
        Assert.assertTrue((boolean)this.util.compareProperties(p1, p2));
    }

    @Test
    public void testBothNull() {
        Object obj1 = null;
        Object obj2 = null;
        String obj3 = new String();
        String obj4 = new String();
        Assert.assertTrue((boolean)this.util.bothAreNull(obj1, obj2));
        Assert.assertFalse((boolean)this.util.bothAreNull(obj1, (Object)obj3));
        Assert.assertFalse((boolean)this.util.bothAreNull((Object)obj3, (Object)obj4));
    }

    @Test
    public void testNullDifference() {
        Object obj1 = null;
        Object obj2 = null;
        String obj3 = new String();
        String obj4 = new String();
        Assert.assertFalse((boolean)this.util.oneIsNulll(obj1, obj2, "Function", "Type"));
        Assert.assertFalse((boolean)this.util.oneIsNulll((Object)obj3, (Object)obj4, "Function", "Type"));
        Assert.assertTrue((boolean)this.util.oneIsNulll(obj2, (Object)obj3, "Function", "Type"));
    }
}

