/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;

@UsingParameters
public class RawDocumentToFilterEventsStep
extends BasePipelineStep {
    private IFilter filter;
    private boolean filterfromSetFilter;
    private boolean isDone;
    private IFilterConfigurationMapper fcMapper;
    private String filterConfigId;
    private boolean multiDocuments;

    public RawDocumentToFilterEventsStep() {
    }

    public RawDocumentToFilterEventsStep(IFilter filter) {
        this.setFilter(filter);
    }

    public void setFilter(IFilter filter) {
        this.filterfromSetFilter = true;
        this.filter = filter;
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_ID)
    public void setFilterConfigurationId(String filterConfigId) {
        this.filterConfigId = filterConfigId;
    }

    public String getName() {
        return "Raw Document to Filter Events";
    }

    public String getDescription() {
        return "Convert a raw document into filter events. Expects: raw document. Sends back: filter events.";
    }

    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                this.isDone = true;
                break;
            }
            case START_BATCH_ITEM: {
                this.isDone = false;
                return event;
            }
            case RAW_DOCUMENT: {
                this.multiDocuments = false;
                if (!this.filterfromSetFilter) {
                    if (Util.isEmpty((String)this.filterConfigId)) {
                        this.isDone = true;
                        return event;
                    }
                    this.filter = this.fcMapper.createFilter(this.filterConfigId, this.filter);
                    if (this.filter == null) {
                        throw new OkapiException(String.format("Unsupported filter type '%s'.", this.filterConfigId));
                    }
                }
                this.multiDocuments = "okf_rainbowkit;okf_transifex;".contains(this.filter.getName());
                this.isDone = false;
                this.filter.open(event.getRawDocument());
                if (this.filter.hasNext()) {
                    return this.filter.next();
                }
                throw new OkapiIOException(String.format("No events available from '%s'.", this.filter.getDisplayName()));
            }
            case END_BATCH_ITEM: {
                if (this.filter != null) {
                    this.filter.close();
                }
                return event;
            }
        }
        if (this.isDone) {
            return event;
        }
        Event e = event;
        if (this.filter != null) {
            if (this.multiDocuments) {
                if (this.filter.hasNext()) {
                    e = this.filter.next();
                } else {
                    e = Event.createNoopEvent();
                    this.isDone = true;
                }
            } else {
                e = this.filter.next();
                if (e.getEventType() == EventType.END_DOCUMENT) {
                    this.isDone = true;
                }
            }
        }
        return e;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public void destroy() {
        if (this.filter != null) {
            this.filter.close();
        }
    }

    public void cancel() {
        if (this.filter != null) {
            this.filter.cancel();
        }
    }
}

