/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common.codesimplifier;

import java.util.ArrayList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.InputDocument;
import net.sf.okapi.common.filters.RoundTripComparison;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.filters.idml.IDMLFilter;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatch;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatchItem;
import net.sf.okapi.lib.extra.pipelinebuilder.XPipeline;
import net.sf.okapi.lib.extra.steps.DocumentPartLogger;
import net.sf.okapi.lib.extra.steps.EventListBuilderStep;
import net.sf.okapi.lib.extra.steps.EventLogger;
import net.sf.okapi.lib.extra.steps.TextUnitLogger;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.common.codesimplifier.CodeSimplifierStep;
import net.sf.okapi.steps.common.codesimplifier.Parameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class TestCodeSimplifierStep {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private GenericContent fmt;
    private CodeSimplifierStep css;
    private static final LocaleId EN = new LocaleId("en", "us");
    private static final LocaleId ESES = new LocaleId("es", "es");
    private FileLocation pathBase;

    @Before
    public void setup() {
        this.css = new CodeSimplifierStep();
        this.fmt = new GenericContent();
        this.pathBase = FileLocation.fromClass(this.getClass());
    }

    @Test
    public void testDefaults() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x4/>");
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T2");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x5/>");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x6", "<x6/>");
        Assert.assertEquals((Object)"<1/>   <2/>T1<3/><4/><5>T2   </5>   <e8/><6/>   <7/>", (Object)this.fmt.setContent(tf).toString());
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSourceContent(tf);
        ISkeleton skel = tu1.getSkeleton();
        Assert.assertNull((Object)skel);
        Event tue1 = new Event(EventType.TEXT_UNIT, (IResource)tu1);
        this.css.handleEvent(tue1);
        tf = tu1.getSource().getUnSegmentedContentCopy();
        Assert.assertEquals((Object)"<1/>   <2/>T1<5>T2   </5>   <e8/>   <7/>", (Object)this.fmt.setContent(tf).toString());
        skel = tu1.getSkeleton();
        Assert.assertNull((Object)skel);
    }

    @Test
    public void testDefaults2() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x4/>");
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T2");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x5/>");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x6", "<x6/>");
        Assert.assertEquals((Object)"<1/>   <2/>T1<3/><4/><5>T2   </5>   <e8/><6/>   <7/>", (Object)this.fmt.setContent(tf).toString());
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSourceContent(tf);
        GenericSkeleton skel = new GenericSkeleton();
        Assert.assertNotNull((Object)skel);
        tu1.setSkeleton((ISkeleton)skel);
        Assert.assertNotNull((Object)tu1.getSkeleton());
        Event tue1 = new Event(EventType.TEXT_UNIT, (IResource)tu1);
        this.css.handleEvent(tue1);
        tf = tu1.getSource().getUnSegmentedContentCopy();
        Assert.assertEquals((Object)"T1<5>T2   </5>", (Object)this.fmt.setContent(tf).toString());
        skel = tu1.getSkeleton();
        Assert.assertEquals((Object)"<x1/>   <x2/>[#$$self$]   </b><x5/>   <x6/>", (Object)skel.toString());
    }

    @Test
    public void testNoRemoval() {
        Parameters params = this.css.getParameters();
        params.setRemoveLeadingTrailingCodes(false);
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x4/>");
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T2");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x5/>");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x6", "<x6/>");
        Assert.assertEquals((Object)"<1/>   <2/>T1<3/><4/><5>T2   </5>   <e8/><6/>   <7/>", (Object)this.fmt.setContent(tf).toString());
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSourceContent(tf);
        ISkeleton skel = tu1.getSkeleton();
        Assert.assertNull((Object)skel);
        Event tue1 = new Event(EventType.TEXT_UNIT, (IResource)tu1);
        this.css.handleEvent(tue1);
        tf = tu1.getSource().getUnSegmentedContentCopy();
        Assert.assertEquals((Object)"<1/>   <2/>T1<5>T2   </5>   <e8/>   <7/>", (Object)this.fmt.setContent(tf).toString());
        skel = tu1.getSkeleton();
        Assert.assertNull((Object)skel);
    }

    @Test
    public void testDoubleExtraction() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase.in("test1.html").toString(), null));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new HtmlFilter(), list, "UTF-8", EN, ESES, "out", new IPipelineStep[]{new CodeSimplifierStep()}));
    }

    @Test
    public void testDoubleExtraction2() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase.in("aa324.html").toString(), null));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new HtmlFilter(), list, "UTF-8", EN, ESES, "out", new IPipelineStep[]{new CodeSimplifierStep()}));
    }

    @Test
    public void testEvents() {
        EventListBuilderStep elbs2 = new EventListBuilderStep();
        this.logger.debug(this.pathBase.in("").toString());
        new XPipeline("Test pipeline for CodeSimplifierStep", new XBatch(new XBatchItem[]{new XBatchItem(this.pathBase.in("aa324.html").asUri(), "UTF-8", EN)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), new EventLogger(), elbs2}).execute();
        for (Event event : elbs2.getList()) {
            if (event.isTextUnit()) {
                this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)event.getTextUnit(), (LocaleId)EN));
                continue;
            }
            if (!event.isDocumentPart()) continue;
            this.logger.debug(DocumentPartLogger.getDpInfo((DocumentPart)event.getDocumentPart(), (LocaleId)EN));
        }
    }

    @Test
    public void testEvents2() {
        EventListBuilderStep elbs2 = new EventListBuilderStep();
        new XPipeline("Test pipeline for CodeSimplifierStep", new XBatch(new XBatchItem[]{new XBatchItem(this.pathBase.in("out/aa324.html").asUri(), "UTF-8", EN)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), new EventLogger(), elbs2}).execute();
        for (Event event : elbs2.getList()) {
            if (event.isTextUnit()) {
                this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)event.getTextUnit(), (LocaleId)EN));
                continue;
            }
            if (!event.isDocumentPart()) continue;
            this.logger.debug(DocumentPartLogger.getDpInfo((DocumentPart)event.getDocumentPart(), (LocaleId)EN));
        }
    }

    @Test
    public void testEvents3() {
        new XPipeline("Test pipeline for CodeSimplifierStep", new XBatch(new XBatchItem[]{new XBatchItem(this.pathBase.in("aa324.html").asUri(), "UTF-8", EN)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), new TextUnitLogger()}).execute();
    }

    @Test
    public void testEvents4() {
        new XPipeline("Test pipeline for CodeSimplifierStep", new XBatch(new XBatchItem[]{new XBatchItem(this.pathBase.in("out/aa324.html").asUri(), "UTF-8", EN)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), new TextUnitLogger()}).execute();
    }

    @Test
    public void testEvents5() {
        new XPipeline("Test pipeline for CodeSimplifierStep", new XBatch(new XBatchItem[]{new XBatchItem(this.pathBase.in("idmltest.idml").asUri(), "UTF-8", EN)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new IDMLFilter()), new TextUnitLogger()}).execute();
    }

    @Test
    public void testDoubleExtraction3() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase.in("form.html").toString(), null));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new HtmlFilter(), list, "UTF-8", EN, ESES, "out", new IPipelineStep[]{new CodeSimplifierStep()}));
    }

    @Test
    public void testDoubleExtraction4() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase.in("BinUnitTest01.xlf").toString(), null));
        list.add(new InputDocument(this.pathBase.in("JMP-11-Test01.xlf").toString(), null));
        list.add(new InputDocument(this.pathBase.in("Manual-12-AltTrans.xlf").toString(), null));
        list.add(new InputDocument(this.pathBase.in("test1.xlf").toString(), null));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new XLIFFFilter(), list, "UTF-8", EN, ESES, "out", new IPipelineStep[]{new CodeSimplifierStep()}));
    }

    @Test
    public void testDoubleExtraction5() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase.in("idmltest.idml").toString(), null));
        RoundTripComparison rtc = new RoundTripComparison(false);
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new IDMLFilter(), list, "UTF-8", EN, EN, "out", new IPipelineStep[]{new CodeSimplifierStep()}));
    }
}

