/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.AbstractPart;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=ExtractionVerificationStepParameters.class)
public class ExtractionVerificationStepParameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String COMPARESKELETON = "compareSkeleton";
    private static final String STEPENABLED = "stepEnabled";
    private static final String ALLEVENTS = "allEvents";
    private static final String LIMIT = "limit";
    private static final String INTERRUPT = "interrupt";
    public boolean monolingual = false;

    public void reset() {
        super.reset();
        this.setCompareSkeleton(true);
        this.setStepEnabled(true);
        this.setAllEvents(true);
        this.setLimit(10);
        this.setInterrupt(false);
    }

    public boolean getStepEnabled() {
        return this.getBoolean(STEPENABLED);
    }

    public void setStepEnabled(boolean stepEnabled) {
        this.setBoolean(STEPENABLED, stepEnabled);
    }

    public boolean getCompareSkeleton() {
        return this.getBoolean(COMPARESKELETON);
    }

    public void setCompareSkeleton(boolean compareSkeleton) {
        this.setBoolean(COMPARESKELETON, compareSkeleton);
    }

    public boolean getAllEvents() {
        return this.getBoolean(ALLEVENTS);
    }

    public void setAllEvents(boolean allEvents) {
        this.setBoolean(ALLEVENTS, allEvents);
    }

    public int getLimit() {
        return this.getInteger(LIMIT);
    }

    public void setLimit(int limit) {
        this.setInteger(LIMIT, limit);
    }

    public boolean getInterrupt() {
        return this.getBoolean(INTERRUPT);
    }

    public void setInterrupt(boolean interrupt) {
        this.setBoolean(INTERRUPT, interrupt);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(STEPENABLED, "Perform the extraction verification", null);
        desc.add(COMPARESKELETON, "Compare skeleton", null);
        desc.add(ALLEVENTS, "Verify all events (otherwise only text units are verified)", null);
        desc.add(LIMIT, "Maximum number of warnings per document", null);
        desc.add(INTERRUPT, "Interrupt after reaching the maximum number of warnings", null);
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Extraction Verification", true, false);
        CheckboxPart cbp = desc.addCheckboxPart(paramsDesc.get(STEPENABLED));
        desc.addSeparatorPart();
        CheckboxPart cbp2 = desc.addCheckboxPart(paramsDesc.get(ALLEVENTS));
        cbp2.setMasterPart((AbstractPart)cbp, true);
        cbp2 = desc.addCheckboxPart(paramsDesc.get(COMPARESKELETON));
        cbp2.setMasterPart((AbstractPart)cbp, true);
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(LIMIT));
        tip.setMasterPart((AbstractPart)cbp, true);
        cbp2 = desc.addCheckboxPart(paramsDesc.get(INTERRUPT));
        cbp2.setMasterPart((AbstractPart)cbp, true);
        return desc;
    }
}

