/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;

@UsingParameters
public class RawDocumentWriterStep
extends BasePipelineStep {
    private URI outputURI;

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    public String getDescription() {
        return "Write a RawDocument to an output file.";
    }

    public String getName() {
        return "RawDocument Writer";
    }

    public Event handleRawDocument(Event event) {
        try (RawDocument rawDoc = (RawDocument)event.getResource();){
            File outFile = new File(this.outputURI);
            Util.createDirectories((String)outFile.getAbsolutePath());
            StreamUtil.copy((InputStream)rawDoc.getStream(), (File)outFile);
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error writing or copying a RawDocument.", e);
        }
        return Event.NOOP_EVENT;
    }
}

