/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import java.util.ArrayList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.InputDocument;
import net.sf.okapi.common.filters.RoundTripComparison;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatch;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatchItem;
import net.sf.okapi.lib.extra.pipelinebuilder.XPipeline;
import net.sf.okapi.lib.extra.steps.DocumentPartLogger;
import net.sf.okapi.lib.extra.steps.EventListBuilderStep;
import net.sf.okapi.lib.extra.steps.EventLogger;
import net.sf.okapi.lib.extra.steps.TextUnitLogger;
import net.sf.okapi.lib.extra.steps.TuDpSsfLogger;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.common.ResourceSimplifierStep;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class ResourceSimplifierStepTest {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final LocaleId ENUS = new LocaleId("en", "us");
    private final FileLocation pathBase = FileLocation.fromClass(this.getClass());

    @Test
    public void testDoubleExtraction() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase.in("aa324.html").toString(), null));
        list.add(new InputDocument(this.pathBase.in("form.html").toString(), null));
        list.add(new InputDocument(this.pathBase.in("W3CHTMHLTest1.html").toString(), null));
        list.add(new InputDocument(this.pathBase.in("msg00058.html").toString(), null));
        list.add(new InputDocument(this.pathBase.in("ugly_big.htm").toString(), null));
        RoundTripComparison rtc = new RoundTripComparison();
        ResourceSimplifierStep rss = new ResourceSimplifierStep();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new HtmlFilter(), list, "UTF-8", ENUS, ENUS, "skeleton", new IPipelineStep[]{rss}));
    }

    @Test
    public void testEvents() {
        EventListBuilderStep elbs1 = new EventListBuilderStep();
        EventListBuilderStep elbs2 = new EventListBuilderStep();
        new XPipeline("Test pipeline for ResourceSimplifierStepTest", new XBatch(new XBatchItem[]{new XBatchItem(this.pathBase.in("aa324.html").asUrl(), "UTF-8", ENUS)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), elbs1, new ResourceSimplifierStep(), new DocumentPartLogger(), elbs2}).execute();
    }

    @Test
    public void testEvents2() {
        EventListBuilderStep elbs1 = new EventListBuilderStep();
        EventListBuilderStep elbs2 = new EventListBuilderStep();
        new XPipeline("Test pipeline for ResourceSimplifierStepTest", new XBatch(new XBatchItem[]{new XBatchItem(this.pathBase.in("msg00058.html").asUrl(), "UTF-8", ENUS)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), new EventLogger(), elbs2}).execute();
        for (Event event : elbs2.getList()) {
            if (event.isTextUnit()) {
                this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)event.getTextUnit(), (LocaleId)ENUS));
                continue;
            }
            if (!event.isDocumentPart()) continue;
            this.logger.debug(DocumentPartLogger.getDpInfo((DocumentPart)event.getDocumentPart(), (LocaleId)ENUS));
        }
    }

    @Test
    public void testEvents3() {
        EventListBuilderStep elbs1 = new EventListBuilderStep();
        EventListBuilderStep elbs2 = new EventListBuilderStep();
        new XPipeline("Test pipeline for ResourceSimplifierStepTest", new XBatch(new XBatchItem[]{new XBatchItem(this.pathBase.in("form.html").asUrl(), "UTF-8", ENUS)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), elbs1, new ResourceSimplifierStep(), new DocumentPartLogger(), elbs2}).execute();
    }

    @Test
    public void testTuDpSsfEvents() {
        new XPipeline(null, new XBatch(new XBatchItem[]{new XBatchItem(this.pathBase.in("form.html").asUri(), "UTF-8", ENUS)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), new TuDpSsfLogger()}).execute();
    }

    @Test
    public void testTuDpSsfEvents_simplified() {
        new XPipeline(null, new XBatch(new XBatchItem[]{new XBatchItem(this.pathBase.in("form.html").asUri(), "UTF-8", ENUS)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), new ResourceSimplifierStep(), new TuDpSsfLogger()}).execute();
    }

    @Test
    public void testTuDpSsfEvents2() {
        new XPipeline(null, new XBatch(new XBatchItem[]{new XBatchItem(this.pathBase.in("aa324.html").asUri(), "UTF-8", ENUS)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), new TuDpSsfLogger()}).execute();
    }

    @Test
    public void testTuDpSsfEvents2_simplified() {
        new XPipeline(null, new XBatch(new XBatchItem[]{new XBatchItem(this.pathBase.in("aa324.html").asUri(), "UTF-8", ENUS)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), new ResourceSimplifierStep(), new TuDpSsfLogger()}).execute();
    }

    @Test
    public void testTuDpSsfEvents3() {
        new XPipeline(null, new XBatch(new XBatchItem[]{new XBatchItem(this.pathBase.in("aa324_out.html").asUri(), "UTF-8", ENUS)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), new TuDpSsfLogger()}).execute();
    }

    @Test
    public void testTuDpSsfEvents3_simplified() {
        new XPipeline(null, new XBatch(new XBatchItem[]{new XBatchItem(this.pathBase.in("aa324_out.html").asUri(), "UTF-8", ENUS)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new HtmlFilter()), new ResourceSimplifierStep(), new TuDpSsfLogger()}).execute();
    }
}

