/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common.createtarget;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String COPYCONTENT = "copyContent";
    private static final String COPYPROPERTIES = "copyProperties";
    private static final String OVERWRITEEXISTING = "overwriteExisting";
    private static final String CREATEONNONTRANSLATABLE = "createOnNonTranslatable";

    public void reset() {
        super.reset();
        this.setBoolean(COPYPROPERTIES, true);
        this.setBoolean(COPYCONTENT, true);
        this.setBoolean(OVERWRITEEXISTING, false);
        this.setBoolean(CREATEONNONTRANSLATABLE, true);
    }

    public boolean isCopyProperties() {
        return this.getBoolean(COPYPROPERTIES);
    }

    public void setCopyProperties(boolean copyProperties) {
        this.setBoolean(COPYPROPERTIES, copyProperties);
    }

    public boolean isCopyContent() {
        return this.getBoolean(COPYCONTENT);
    }

    public void setCopyContent(boolean copyContent) {
        this.setBoolean(COPYCONTENT, copyContent);
    }

    public boolean isOverwriteExisting() {
        return this.getBoolean(OVERWRITEEXISTING);
    }

    public void setOverwriteExisting(boolean overwriteExisting) {
        this.setBoolean(OVERWRITEEXISTING, overwriteExisting);
    }

    public boolean isCreateOnNonTranslatable() {
        return this.getBoolean(CREATEONNONTRANSLATABLE);
    }

    public void setCreateOnNonTranslatable(boolean createOnNonTranslatable) {
        this.setBoolean(CREATEONNONTRANSLATABLE, createOnNonTranslatable);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(COPYCONTENT, "Copy the source content to the target", null);
        desc.add(COPYPROPERTIES, "Copy the source properties to the target", null);
        desc.add(OVERWRITEEXISTING, "Overwrite the current target content", null);
        desc.add(CREATEONNONTRANSLATABLE, "Creates target for non-translatable text units", null);
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Create Target", true, false);
        desc.addCheckboxPart(paramsDesc.get(COPYCONTENT));
        desc.addCheckboxPart(paramsDesc.get(COPYPROPERTIES));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(OVERWRITEEXISTING));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(CREATEONNONTRANSLATABLE));
        return desc;
    }
}

