/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common.removetarget;

import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.steps.common.removetarget.Parameters;

@UsingParameters(value=Parameters.class)
public class RemoveTargetStep
extends BasePipelineStep {
    private List<String> tuIds;
    private List<LocaleId> targetLocales;
    private Parameters params = new Parameters();

    public String getDescription() {
        return "Remove targets in all or a given set of text units. Expects: filter events. Sends back: filter events.";
    }

    public String getName() {
        return "Remove Target";
    }

    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    public Parameters getParameters() {
        return this.params;
    }

    protected Event handleStartBatch(Event event) {
        this.tuIds = ListUtil.stringAsList((String)this.params.getTusForTargetRemoval());
        this.targetLocales = ListUtil.stringAsLanguageList((String)this.params.getTargetLocalesToKeep());
        return super.handleStartBatch(event);
    }

    protected Event handleTextUnit(Event event) {
        String id = event.getResource().getId();
        if (this.params.isFilterBasedOnIds()) {
            if (Util.isEmpty(this.tuIds) || this.tuIds.contains(id)) {
                ITextUnit tu = event.getTextUnit();
                for (LocaleId locId : tu.getTargetLocales()) {
                    tu.removeTarget(locId);
                }
            }
        } else if (!Util.isEmpty(this.targetLocales)) {
            ITextUnit tu = event.getTextUnit();
            for (LocaleId locId : tu.getTargetLocales()) {
                if (this.targetLocales.contains(locId)) continue;
                tu.removeTarget(locId);
            }
        }
        if (this.params.isRemoveTUIfNoTarget() && event.getTextUnit().getTargetLocales().isEmpty()) {
            return Event.NOOP_EVENT;
        }
        return event;
    }
}

