/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import java.io.InputStream;
import java.io.OutputStream;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.RawDocument;

@UsingParameters
public class RawDocumentToOutputStreamStep
extends BasePipelineStep {
    private OutputStream outStream;

    public void setOutputStream(OutputStream outStream) {
        this.outStream = outStream;
    }

    public String getDescription() {
        return "Write a RawDocument to an output stream.";
    }

    public String getName() {
        return "RawDocument To OutputStream";
    }

    public Event handleRawDocument(Event event) {
        try (RawDocument rawDoc = (RawDocument)event.getResource();){
            StreamUtil.copy((InputStream)rawDoc.getStream(), (OutputStream)this.outStream);
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error copying a RawDocument to output stream.", e);
        }
        return Event.NOOP_EVENT;
    }
}

