/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import java.io.File;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadStepInputException;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.BaseReferenceable;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.steps.common.ExtractionVerificationStepParameters;
import net.sf.okapi.steps.common.ExtractionVerificationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=ExtractionVerificationStepParameters.class)
public class ExtractionVerificationStep
extends BasePipelineStep {
    private final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IFilter filter1;
    private IFilter filter2;
    private IFilterWriter writer;
    private IFilterConfigurationMapper fcMapper;
    private String filterConfigId;
    private ExtractionVerificationStepParameters params = new ExtractionVerificationStepParameters();
    ExtractionVerificationUtil verificationUtil = new ExtractionVerificationUtil();
    LocaleId localeId;

    public void setParameters(IParameters params) {
        this.params = (ExtractionVerificationStepParameters)params;
    }

    public ExtractionVerificationStepParameters getParameters() {
        return this.params;
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_ID)
    public void setFilterConfigurationId(String filterConfigId) {
        this.filterConfigId = filterConfigId;
    }

    public String getName() {
        return "Extraction Verification";
    }

    public String getDescription() {
        return "Verifies a raw document can be extracted, merged, then extracted again and produces the same set of events during both extractions. Expects: raw document. Sends back: unmodified raw document.";
    }

    protected Event handleRawDocument(Event event) {
        if (!this.params.getStepEnabled()) {
            this.LOGGER.info("ExtractionVerificationStep is disabled");
            return event;
        }
        this.verificationUtil.setCompareSkeleton(this.params.getCompareSkeleton());
        this.verificationUtil.setTargetLocaleOverriden(false);
        Event event1 = null;
        Event event2 = null;
        int count1 = 0;
        int count2 = 0;
        int errorCount = 0;
        int limit = this.params.getLimit();
        boolean interrupt = this.params.getInterrupt();
        boolean reachedMax = false;
        RawDocument tmpDoc = null;
        try (RawDocument initialDoc = event.getRawDocument();){
            if (Util.isEmpty((String)this.filterConfigId)) {
                Event event3 = event;
                return event3;
            }
            this.filter1 = this.fcMapper.createFilter(this.filterConfigId);
            this.filter2 = this.fcMapper.createFilter(this.filterConfigId);
            if (this.filter1 == null) {
                throw new OkapiException("Unsupported filter type.");
            }
            this.verificationUtil.setTargetLocale(initialDoc.getTargetLocale());
            this.filter1.open(initialDoc);
            this.writer = this.filter1.createFilterWriter();
            File outFile = File.createTempFile("~okapi-38_okp-vx_", ".tmp");
            this.writer.setOutput(outFile.getAbsolutePath());
            this.writer.setOptions(initialDoc.getSourceLocale(), initialDoc.getEncoding());
            while (this.filter1.hasNext()) {
                event1 = this.filter1.next();
                this.writer.handleEvent(event1);
            }
            this.writer.close();
            this.filter1.close();
            tmpDoc = new RawDocument(outFile.toURI(), initialDoc.getEncoding(), initialDoc.getSourceLocale(), initialDoc.getTargetLocale());
            this.filter1 = this.fcMapper.createFilter(this.filterConfigId);
            this.filter1.open(initialDoc);
            this.filter2.open(tmpDoc);
            boolean hasNext1 = this.filter1.hasNext();
            boolean hasNext2 = this.filter2.hasNext();
            while (hasNext1 || hasNext2) {
                if (hasNext1) {
                    ++count1;
                    event1 = this.filter1.next();
                }
                if (hasNext2) {
                    ++count2;
                    event2 = this.filter2.next();
                }
                if (hasNext1 && hasNext2 && !reachedMax && !this.identicalEvent(event1, event2)) {
                    this.LOGGER.warn("different events");
                    if (++errorCount >= limit && limit > 0) {
                        reachedMax = true;
                    }
                    if (!reachedMax || !interrupt) break;
                    throw new OkapiBadStepInputException("Reached maximum verification errors");
                }
                hasNext1 = this.filter1.hasNext();
                hasNext2 = this.filter2.hasNext();
            }
            if (count1 > count2) {
                this.LOGGER.warn("ExtractionVerification: Additional events found in the first run");
            } else if (count2 > count1) {
                this.LOGGER.warn("ExtractionVerification: Additional events found in the second run");
            }
            if (errorCount > 0) {
                this.LOGGER.warn("ExtractionVerification: {} or more events fail.", (Object)errorCount);
            } else {
                this.LOGGER.info("ExtractionVerification: All events pass.");
            }
        }
        catch (Throwable e) {
            throw new OkapiException("ExtractionVerification failed.\n" + e.getMessage(), e);
        }
        finally {
            if (tmpDoc != null) {
                tmpDoc.close();
            }
            this.closeFilterAndWriter();
        }
        return event;
    }

    private void closeFilterAndWriter() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.filter1 != null) {
            this.filter1.close();
            this.filter1 = null;
        }
        if (this.filter2 != null) {
            this.filter2.close();
            this.filter2 = null;
        }
    }

    public void destroy() {
        this.closeFilterAndWriter();
    }

    public void cancel() {
        if (this.filter1 != null) {
            this.filter1.cancel();
        }
        if (this.filter2 != null) {
            this.filter2.cancel();
        }
    }

    private boolean identicalEvent(Event event1, Event event2) {
        if (event1 == null && event2 != null) {
            this.LOGGER.warn("Event from first run is null");
            return false;
        }
        if (event1 != null && event2 == null) {
            this.LOGGER.warn("Event from second run is null");
            return false;
        }
        if (event1 == null && event2 == null) {
            return true;
        }
        if (event1.getEventType() != event2.getEventType()) {
            this.LOGGER.warn("Event Types are different");
            return false;
        }
        if (event1.getEventType() == EventType.TEXT_UNIT) {
            return this.verificationUtil.compareTextUnits(event1.getTextUnit(), event2.getTextUnit());
        }
        if (this.params.getAllEvents()) {
            switch (event1.getEventType()) {
                case START_DOCUMENT: {
                    StartDocument sd = event1.getStartDocument();
                    this.verificationUtil.setMultilingual(sd.isMultilingual());
                    break;
                }
                case START_SUBDOCUMENT: {
                    return this.verificationUtil.compareStartSubDocument((StartSubDocument)event1.getResource(), (StartSubDocument)event2.getResource());
                }
                case START_GROUP: {
                    return this.verificationUtil.compareBaseReferenceable((BaseReferenceable)event1.getStartGroup(), (BaseReferenceable)event2.getStartGroup());
                }
                case START_SUBFILTER: {
                    return this.verificationUtil.compareBaseReferenceable((BaseReferenceable)event1.getStartSubfilter(), (BaseReferenceable)event2.getStartSubfilter());
                }
                case END_DOCUMENT: 
                case END_SUBDOCUMENT: 
                case END_GROUP: 
                case END_SUBFILTER: {
                    return this.verificationUtil.compareIResources((IResource)event1.getEnding(), (IResource)event2.getEnding());
                }
                case DOCUMENT_PART: {
                    return this.verificationUtil.compareBaseReferenceable((BaseReferenceable)event1.getDocumentPart(), (BaseReferenceable)event2.getDocumentPart());
                }
            }
        }
        return true;
    }
}

