/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.AlignmentStatus;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.common.ConvertSegmentsToTextUnitsStep;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConvertSegmentsToTextUnitTest {
    private ConvertSegmentsToTextUnitsStep converter;
    private ITextUnit segmentedTu;
    private ITextUnit sourceOnlySegmentedTu;
    private ITextUnit segmentedTuWithCodes;
    private ITextUnit nonSegmentedTu;

    @Before
    public void setUp() {
        Segment srcSeg;
        int j;
        this.converter = new ConvertSegmentsToTextUnitsStep();
        this.segmentedTu = new TextUnit("segmentedTU");
        this.segmentedTu.createTarget(LocaleId.SPANISH, true, 0);
        for (j = 0; j < 3; ++j) {
            srcSeg = new Segment(Integer.toString(j), new TextFragment("a segment. "));
            Segment trgSeg = new Segment(Integer.toString(j), new TextFragment("A SEGMENT. "));
            this.segmentedTu.getSource().append((TextPart)srcSeg);
            this.segmentedTu.getTarget(LocaleId.SPANISH).append((TextPart)trgSeg);
        }
        this.segmentedTu.getTarget(LocaleId.SPANISH).getSegments().setAlignmentStatus(AlignmentStatus.ALIGNED);
        this.sourceOnlySegmentedTu = new TextUnit("sourceOnlysegmentedTU");
        for (j = 0; j < 3; ++j) {
            srcSeg = new Segment(Integer.toString(j), new TextFragment("a segment. "));
            this.sourceOnlySegmentedTu.getSource().append((TextPart)srcSeg);
        }
        this.segmentedTuWithCodes = new TextUnit("segmentedTUWithCodes");
        this.segmentedTuWithCodes.createTarget(LocaleId.SPANISH, true, 0);
        for (j = 0; j < 3; ++j) {
            TextFragment stf = new TextFragment("a segment. ");
            Code sc = new Code(TextFragment.TagType.PLACEHOLDER, "type", "data");
            sc.setId(15);
            stf.append(sc);
            Segment srcSeg2 = new Segment(Integer.toString(j), stf);
            TextFragment ttf = new TextFragment("A SEGMENT. ");
            Code tc = new Code(TextFragment.TagType.PLACEHOLDER, "type", "data");
            tc.setId(15);
            ttf.append(tc);
            Segment trgSeg = new Segment(Integer.toString(j), ttf);
            this.segmentedTuWithCodes.getSource().append((TextPart)srcSeg2);
            this.segmentedTuWithCodes.getTarget(LocaleId.SPANISH).append((TextPart)trgSeg);
        }
        this.segmentedTuWithCodes.getTarget(LocaleId.SPANISH).getSegments().setAlignmentStatus(AlignmentStatus.ALIGNED);
        this.nonSegmentedTu = new TextUnit("NON-SEGMENTED");
        this.nonSegmentedTu.setSourceContent(new TextFragment("a segment. "));
        this.nonSegmentedTu.setTargetContent(LocaleId.SPANISH, new TextFragment("A SEGMENT. "));
    }

    @Test
    public void convertSegmentedTuToMultiple() {
        Event event = this.converter.handleTextUnit(new Event(EventType.TEXT_UNIT, (IResource)this.segmentedTu));
        int count = 0;
        for (Event e : event.getMultiEvent()) {
            ++count;
            ITextUnit tu = e.getTextUnit();
            Assert.assertEquals((Object)"a segment. ", (Object)tu.getSource().toString());
            Assert.assertEquals((Object)"A SEGMENT. ", (Object)tu.getTarget(LocaleId.SPANISH).toString());
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void convertSourceOnlySegmentedTuToMultiple() {
        Event event = this.converter.handleTextUnit(new Event(EventType.TEXT_UNIT, (IResource)this.sourceOnlySegmentedTu));
        int count = 0;
        for (Event e : event.getMultiEvent()) {
            ++count;
            ITextUnit tu = e.getTextUnit();
            Assert.assertEquals((Object)"a segment. ", (Object)tu.getSource().toString());
            Assert.assertEquals((Object)false, (Object)tu.hasTarget(LocaleId.SPANISH));
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void convertSegmentedTuToMultipleWithCodes() {
        Event event = this.converter.handleTextUnit(new Event(EventType.TEXT_UNIT, (IResource)this.segmentedTuWithCodes));
        int count = 0;
        for (Event e : event.getMultiEvent()) {
            ++count;
            ITextUnit tu = e.getTextUnit();
            Code sc = tu.getSource().getFirstContent().getCode(0);
            Assert.assertEquals((long)15L, (long)sc.getId());
            Assert.assertEquals((Object)"a segment. data", (Object)tu.getSource().toString());
            Code tc = tu.getSource().getFirstContent().getCode(0);
            Assert.assertEquals((long)15L, (long)tc.getId());
            Assert.assertEquals((Object)"A SEGMENT. data", (Object)tu.getTarget(LocaleId.SPANISH).toString());
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void convertNonSegmentedTuToMultiple() {
        Event event = this.converter.handleTextUnit(new Event(EventType.TEXT_UNIT, (IResource)this.nonSegmentedTu));
        int count = 0;
        for (Event e : event.getMultiEvent()) {
            ++count;
            ITextUnit tu = e.getTextUnit();
            Assert.assertEquals((Object)"a segment. ", (Object)tu.getSource().toString());
            Assert.assertEquals((Object)"A SEGMENT. ", (Object)tu.getTarget(LocaleId.SPANISH).toString());
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void convertNull() {
        Event event = this.converter.handleTextUnit(new Event(EventType.TEXT_UNIT, null));
        Assert.assertNull((Object)event.getTextUnit());
    }

    @Test
    public void convertEmptyNonNull() {
        Event event = this.converter.handleTextUnit(new Event(EventType.TEXT_UNIT, (IResource)new TextUnit("NON-NULL")));
        Assert.assertNotNull((Object)event.getTextUnit());
    }
}

