/*
 * Decompiled with CFR 0.152.
 */
package net.okapi.steps.codesremoval;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.codesremoval.CodesRemover;
import net.sf.okapi.steps.codesremoval.Parameters;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CodesRemoverTest {
    private CodesRemover remover;
    private Parameters params;
    private GenericContent fmt = new GenericContent();

    @Test
    public void testSimple() {
        this.params = new Parameters();
        this.remover = new CodesRemover(this.params, LocaleId.SPANISH);
        TextUnit tu = new TextUnit("id");
        tu.setSourceContent(this.createSimpleFragment());
        tu.setTargetContent(LocaleId.SPANISH, this.createSimpleFragment());
        this.remover.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((Object)"t1t2t3", (Object)tu.toString());
        Assert.assertEquals((Object)"t1t2t3", (Object)tu.getTarget(LocaleId.SPANISH).toString());
    }

    @Test
    public void testSkipNonTranslatable() {
        this.params = new Parameters();
        this.remover = new CodesRemover(this.params, LocaleId.SPANISH);
        TextUnit tu = new TextUnit("id");
        tu.setSourceContent(this.createSimpleFragment());
        tu.setTargetContent(LocaleId.SPANISH, this.createSimpleFragment());
        this.params.setIncludeNonTranslatable(false);
        tu.setIsTranslatable(false);
        this.remover.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((Object)"t1<br/>t2<b>t3</b>", (Object)tu.toString());
        Assert.assertEquals((long)3L, (long)tu.getSource().getFirstContent().getCodes().size());
        Assert.assertEquals((Object)"t1<br/>t2<b>t3</b>", (Object)tu.getTarget(LocaleId.SPANISH).toString());
        Assert.assertEquals((long)3L, (long)tu.getTarget(LocaleId.SPANISH).getFirstContent().getCodes().size());
    }

    @Test
    public void testDontStripSource() {
        this.params = new Parameters();
        this.params.setStripSource(false);
        this.remover = new CodesRemover(this.params, LocaleId.SPANISH);
        TextUnit tu = new TextUnit("id");
        tu.setSourceContent(this.createSimpleFragment());
        tu.setTargetContent(LocaleId.SPANISH, this.createSimpleFragment());
        this.remover.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((Object)"t1<br/>t2<b>t3</b>", (Object)tu.toString());
        Assert.assertEquals((long)3L, (long)tu.getSource().getFirstContent().getCodes().size());
        Assert.assertEquals((Object)"t1t2t3", (Object)tu.getTarget(LocaleId.SPANISH).toString());
    }

    @Test
    public void testDontStripTarget() {
        this.params = new Parameters();
        this.params.setStripTarget(false);
        this.remover = new CodesRemover(this.params, LocaleId.SPANISH);
        TextUnit tu = new TextUnit("id");
        tu.setSourceContent(this.createSimpleFragment());
        tu.setTargetContent(LocaleId.SPANISH, this.createSimpleFragment());
        this.remover.processTextUnit((ITextUnit)tu);
        Assert.assertEquals((Object)"t1t2t3", (Object)tu.toString());
        Assert.assertEquals((Object)"t1<br/>t2<b>t3</b>", (Object)tu.getTarget(LocaleId.SPANISH).toString());
        Assert.assertEquals((long)3L, (long)tu.getTarget(LocaleId.SPANISH).getFirstContent().getCodes().size());
    }

    @Test
    public void testDontStripSegments() {
        this.params = new Parameters();
        this.remover = new CodesRemover(this.params, LocaleId.SPANISH);
        TextContainer tc = new TextContainer();
        ISegments segments = tc.getSegments();
        tc.append("C1");
        segments.append(this.createSimpleFragment());
        tc.append("C2");
        segments.append(this.createSimpleFragment());
        this.remover.processContainer(tc);
        Assert.assertEquals((Object)"[C1][t1t2t3]C2[t1t2t3]", (Object)this.fmt.printSegmentedContent(tc, true));
        Assert.assertEquals((Object)"t1t2t3", (Object)segments.get((int)1).text.toText());
        Assert.assertEquals((Object)"t1t2t3", (Object)segments.get((int)2).text.toText());
        segments.joinAll();
        Assert.assertEquals((Object)"C1t1t2t3C2t1t2t3", (Object)tc.toString());
    }

    @Test
    public void testKeepCodeRemoveContent() {
        this.params = new Parameters();
        this.params.setMode(1);
        this.remover = new CodesRemover(this.params, LocaleId.SPANISH);
        TextFragment tf = this.createSimpleFragment();
        this.remover.processFragment(tf);
        Assert.assertEquals((Object)"t1t2t3", (Object)tf.toText());
        Assert.assertEquals((long)3L, (long)tf.getCodes().size());
    }

    @Test
    public void testRemoveCodeKeepContent() {
        this.params = new Parameters();
        this.params.setMode(0);
        this.remover = new CodesRemover(this.params, LocaleId.SPANISH);
        TextFragment tf = this.createSimpleFragment();
        this.remover.processFragment(tf);
        Assert.assertEquals((Object)"t1<br/>t2<b>t3</b>", (Object)tf.toText());
        Assert.assertEquals((long)0L, (long)tf.getCodes().size());
    }

    @Test
    public void testRemoveCodeRemoveContent() {
        this.params = new Parameters();
        this.params.setMode(2);
        this.remover = new CodesRemover(this.params, LocaleId.SPANISH);
        TextFragment tf = this.createSimpleFragment();
        this.remover.processFragment(tf);
        Assert.assertEquals((Object)"t1t2t3", (Object)tf.toText());
        Assert.assertEquals((long)0L, (long)tf.getCodes().size());
    }

    @Test
    public void testRemoveCodeRemoveContentWithSpace() {
        this.params = new Parameters();
        this.params.setMode(2);
        this.params.setReplaceWithSpace(true);
        this.remover = new CodesRemover(this.params, LocaleId.SPANISH);
        TextFragment tf = this.createSimpleFragmentWithSpaces();
        this.remover.processFragment(tf);
        Assert.assertEquals((Object)"t1 t2t3t4 t5 t6 t7 t8 t9 t10 t11 ", (Object)tf.toText());
        Assert.assertEquals((long)0L, (long)tf.getCodes().size());
    }

    TextFragment createSimpleFragment() {
        TextFragment tf = new TextFragment("t1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        tf.append("t2");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("t3");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        return tf;
    }

    TextFragment createSimpleFragmentWithSpaces() {
        TextFragment tf = new TextFragment("t1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        tf.append("t2");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("t3");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("t4");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br>");
        tf.append("t5");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br />");
        tf.append("t6");
        tf.append(TextFragment.TagType.PLACEHOLDER, "lb", "unspecified");
        tf.append("t7");
        tf.append(TextFragment.TagType.PLACEHOLDER, "unspecified", "\n");
        tf.append("t8");
        tf.append(TextFragment.TagType.PLACEHOLDER, "unspecified", "\r");
        tf.append("t9");
        tf.append(TextFragment.TagType.PLACEHOLDER, "unspecified", "before\u0085after");
        tf.append("t10");
        tf.append(TextFragment.TagType.PLACEHOLDER, "unspecified", "before\u2028after");
        tf.append("t11");
        tf.append(TextFragment.TagType.PLACEHOLDER, "unspecified", "before\u2029after");
        return tf;
    }
}

