/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.cleanup;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String NORMALIZEQUOTES = "normalizeQuotes";
    private static final String CHECKCHARACTERS = "checkCharacters";
    private static final String MATCHREGEXEXPRESSIONS = "matchRegexExpressions";
    private static final String MATCHUSERREGEX = "matchUserRegex";
    private static final String USERREGEX = "userRegex";
    private static final String PRUNETEXTUNIT = "pruneTextUnit";
    private static final String NORMALIZEPUNCTUATIONS = "normalizePunctuations";
    private static final String KEEPCRNLINTACT = "keepCrNlIntact";

    public void reset() {
        super.reset();
        this.setNormalizeQuotes(true);
        this.setCheckCharacters(true);
        this.setMatchRegexExpressions(true);
        this.setMatchUserRegex(true);
        this.setUserRegex(null);
        this.setPruneTextUnit(true);
        this.setNormalizePunctuations(false);
        this.setKeepCrNlIntact(false);
    }

    public boolean getNormalizeQuotes() {
        return this.getBoolean(NORMALIZEQUOTES);
    }

    public void setNormalizeQuotes(boolean normalizeQuotes) {
        this.setBoolean(NORMALIZEQUOTES, normalizeQuotes);
    }

    public boolean getCheckCharacters() {
        return this.getBoolean(CHECKCHARACTERS);
    }

    public void setCheckCharacters(boolean checkCharacters) {
        this.setBoolean(CHECKCHARACTERS, checkCharacters);
    }

    public boolean getMatchRegexExpressions() {
        return this.getBoolean(MATCHREGEXEXPRESSIONS);
    }

    public void setMatchRegexExpressions(boolean matchRegexExpressions) {
        this.setBoolean(MATCHREGEXEXPRESSIONS, matchRegexExpressions);
    }

    public boolean getMatchUserRegex() {
        return this.getBoolean(MATCHUSERREGEX);
    }

    public void setMatchUserRegex(boolean matchUserRegex) {
        this.setBoolean(MATCHUSERREGEX, matchUserRegex);
    }

    public String getUserRegex() {
        return this.getString(USERREGEX);
    }

    public void setUserRegex(String userRegex) {
        this.setString(USERREGEX, userRegex);
    }

    public boolean getPruneTextUnit() {
        return this.getBoolean(PRUNETEXTUNIT);
    }

    public void setPruneTextUnit(boolean pruneTextUnit) {
        this.setBoolean(PRUNETEXTUNIT, pruneTextUnit);
    }

    public boolean getNormalizePunctuations() {
        return this.getBoolean(NORMALIZEPUNCTUATIONS);
    }

    public void setNormalizePunctuations(boolean normalizePunctuations) {
        this.setBoolean(NORMALIZEPUNCTUATIONS, normalizePunctuations);
    }

    public boolean getKeepCrNlIntact() {
        return this.getBoolean(KEEPCRNLINTACT);
    }

    public void setKeepCrNlIntact(boolean keepCrNlIntact) {
        this.setBoolean(KEEPCRNLINTACT, keepCrNlIntact);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(NORMALIZEQUOTES, "Normalize quotation marks", null);
        desc.add(CHECKCHARACTERS, "Check for corrupt or unexpected characters", null);
        desc.add(MATCHREGEXEXPRESSIONS, "Mark segments matching default regular expressions for removal", null);
        desc.add(MATCHUSERREGEX, "Mark segments matching user defined regular expressions for removal", null);
        desc.add(USERREGEX, "User defined regex string", null);
        desc.add(PRUNETEXTUNIT, "Remove unnecessary segments from text unit", null);
        desc.add(NORMALIZEPUNCTUATIONS, "Standardize spaces before and after certain punctuation marks to English writing style.", null);
        desc.add(KEEPCRNLINTACT, "Keep CR and NL characters intact. They are not normalized to an ASCII space with spaces and tabs.", null);
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Cleanup", true, false);
        desc.addCheckboxPart(paramDesc.get(NORMALIZEQUOTES));
        desc.addCheckboxPart(paramDesc.get(MATCHREGEXEXPRESSIONS));
        desc.addCheckboxPart(paramDesc.get(MATCHUSERREGEX));
        TextInputPart tip = desc.addTextInputPart(paramDesc.get(USERREGEX));
        tip.setAllowEmpty(true);
        desc.addCheckboxPart(paramDesc.get(CHECKCHARACTERS));
        desc.addCheckboxPart(paramDesc.get(PRUNETEXTUNIT));
        desc.addCheckboxPart(paramDesc.get(NORMALIZEPUNCTUATIONS));
        desc.addCheckboxPart(paramDesc.get(KEEPCRNLINTACT));
        return desc;
    }
}

