/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.cleanup;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.cleanup.Cleaner;
import net.sf.okapi.steps.cleanup.Parameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PunctuationTest {
    private final LocaleId locFR = LocaleId.FRENCH;
    private GenericContent fmt;
    private Cleaner cleaner;
    private Parameters params;

    @Before
    public void setup() {
        this.params = new Parameters();
        this.params.setNormalizeQuotes(false);
        this.fmt = new GenericContent();
        this.cleaner = new Cleaner(this.params);
    }

    @Test
    public void testSimpleQuotation() {
        TextFragment srcTf = new TextFragment("t1 \u201ct2\u201d t3");
        TextFragment trgTf = new TextFragment("t1 \u00ab\u00a0t2\u00a0\u00bb t3");
        TextUnit tu = new TextUnit("tu1");
        TextContainer srcTc = tu.getSource();
        srcTc.append((TextPart)new Segment("seg1", srcTf));
        TextContainer frTc = tu.createTarget(this.locFR, true, 0);
        frTc.append((TextPart)new Segment("seg1", trgTf));
        if (!tu.isEmpty()) {
            ISegments srcSegs = tu.getSourceSegments();
            for (Segment srcSeg : srcSegs) {
                Segment trgSeg = tu.getTargetSegment(this.locFR, srcSeg.getId(), false);
                if (trgSeg == null) continue;
                this.cleaner.normalizeQuotation((ITextUnit)tu, srcSeg, this.locFR);
            }
        }
        Assert.assertEquals((Object)"[t1 \"t2\" t3]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true, false));
        Assert.assertEquals((Object)"[t1 \"t2\" t3]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true, true));
        Assert.assertEquals((Object)"[t1 \"t2\" t3]", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true, false));
        Assert.assertEquals((Object)"[t1 \"t2\" t3]", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true, true));
    }

    @Test
    public void testUnitQuotation() {
        TextFragment srcTf1 = new TextFragment("\u201ct1\u201d t2 \u201c\u2018t3\u2019 t4\u201d");
        TextFragment srcTf2 = new TextFragment("t1 \u201ct2\u201d");
        TextFragment srcTf3 = new TextFragment("t1 \u2018t2 \u2019 \u201c\u201ct3\u201d\u201d");
        TextFragment frTf1 = new TextFragment("\u00ab\u00a0t1\u00a0\u00bb l\u2019t2 \u00ab\u00a0t3 t4\u00a0\u00bb");
        TextFragment frTf2 = new TextFragment("t1 \u00ab\u00a0 t2\u00bb");
        TextFragment frTf3 = new TextFragment("t1 \u2018t2\u2019 \u00ab\u00a0t3\u00a0\u00bb");
        TextUnit tu = new TextUnit("tu1");
        TextContainer srcTc = tu.getSource();
        srcTc.append((TextPart)new Segment("seg1", srcTf1));
        srcTc.append(new TextPart(" "));
        srcTc.append((TextPart)new Segment("seg2", srcTf2));
        srcTc.append(new TextPart(" "));
        srcTc.append((TextPart)new Segment("seg3", srcTf3));
        TextContainer frTc = tu.createTarget(this.locFR, true, 0);
        frTc.append((TextPart)new Segment("seg1", frTf1));
        frTc.append(new TextPart(" "));
        frTc.append((TextPart)new Segment("seg2", frTf2));
        frTc.append(new TextPart(" "));
        frTc.append((TextPart)new Segment("seg3", frTf3));
        if (!tu.isEmpty()) {
            ISegments srcSegs = tu.getSourceSegments();
            for (Segment srcSeg : srcSegs) {
                Segment trgSeg = tu.getTargetSegment(this.locFR, srcSeg.getId(), false);
                if (trgSeg == null) continue;
                this.cleaner.normalizeQuotation((ITextUnit)tu, srcSeg, this.locFR);
            }
        }
        Assert.assertEquals((Object)"[\"t1\" t2 \"'t3' t4\"] [t1 \"t2\"] [t1 't2 ' \"\"t3\"\"]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true, false));
        Assert.assertEquals((Object)"[\"t1\" t2 \"'t3' t4\"] [t1 \"t2\"] [t1 't2 ' \"\"t3\"\"]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true, true));
        Assert.assertEquals((Object)"[\"t1\" l't2 \"t3 t4\"] [t1 \"t2\"] [t1 't2' \"t3\"]", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true, false));
        Assert.assertEquals((Object)"[\"t1\" l't2 \"t3 t4\"] [t1 \"t2\"] [t1 't2' \"t3\"]", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true, true));
    }
}

